/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.model.utils;

import java.util.Arrays;
import java.util.Collection;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.Face;
import net.comp_lot.glui.model.Shape;
import net.comp_lot.glui.model.utils.TouchInfo;

public class TouchTester {
    private static final double MIN_SIZE = 0.005;

    public static void testShape(Shape a, Shape b, Collection<TouchInfo> list) {
        TouchTester.testFaces(a, b, a.getFacesArray(), b.getFacesArray(), list);
    }

    private static void testFaces(Shape a, Shape b, Face[] aFaces, Face[] bFaces, Collection<TouchInfo> list) {
        if (!a.getBound().crossing(b.getBound())) {
            return;
        }
        int i = 0;
        while (i < aFaces.length) {
            int j = 0;
            while (j < bFaces.length) {
                MutVector d;
                MutVector c;
                if (!(aFaces[i].getBound().getDepth(bFaces[j].getBound()) <= 2.5E-5) && (c = TouchTester.testFace(aFaces[i], bFaces[j])) != null && (d = TouchTester.getDepth(c, aFaces[i], bFaces[j])).getSize() > 0.005) {
                    list.add(new TouchInfo(c, d, a, b));
                }
                ++j;
            }
            ++i;
        }
    }

    private static MutVector testFace(Face aFace, Face bFace) {
        if (TouchTester.abs(Vector.Dot(aFace.getNormal(), bFace.getNormal())) > 0.6) {
            return null;
        }
        double[] dA = new double[3];
        double[] dB = new double[3];
        MutVector buf1 = new MutVector();
        MutVector buf2 = new MutVector();
        int i = 0;
        while (i < 3) {
            buf1.set(bFace.getA(), aFace.get(i));
            dA[i] = Vector.Dot(bFace.getNormal(), buf1);
            buf2.set(aFace.getA(), bFace.get(i));
            dB[i] = Vector.Dot(aFace.getNormal(), buf2);
            ++i;
        }
        if (dA[0] <= 0.0 && dA[1] <= 0.0 && dA[2] <= 0.0 || dA[0] >= 0.0 && dA[1] >= 0.0 && dA[2] >= 0.0 || dB[0] <= 0.0 && dB[1] <= 0.0 && dB[2] <= 0.0 || dB[0] >= 0.0 && dB[1] >= 0.0 && dB[2] >= 0.0) {
            return null;
        }
        int numA = dA[0] > 0.0 && dA[1] < 0.0 && dA[2] < 0.0 || dA[0] < 0.0 && dA[1] > 0.0 && dA[2] > 0.0 ? 0 : (dA[0] < 0.0 && dA[1] > 0.0 || dA[0] > 0.0 && dA[1] < 0.0 ? 1 : 2);
        int numB = dB[0] > 0.0 && dB[1] < 0.0 && dB[2] < 0.0 || dB[0] < 0.0 && dB[1] > 0.0 && dB[2] > 0.0 ? 0 : (dB[0] < 0.0 && dB[1] > 0.0 || dB[0] > 0.0 && dB[1] < 0.0 ? 1 : 2);
        MutVector[] xA = new MutVector[2];
        MutVector[] xB = new MutVector[2];
        xA[0] = MutVector.iDivision(aFace.get(numA), aFace.get((numA + 1) % 3), TouchTester.abs(dA[numA]), TouchTester.abs(dA[(numA + 1) % 3]));
        xA[1] = MutVector.iDivision(aFace.get(numA), aFace.get((numA + 2) % 3), TouchTester.abs(dA[numA]), TouchTester.abs(dA[(numA + 2) % 3]));
        xB[0] = MutVector.iDivision(bFace.get(numB), bFace.get((numB + 1) % 3), TouchTester.abs(dB[numB]), TouchTester.abs(dB[(numB + 1) % 3]));
        xB[1] = MutVector.iDivision(bFace.get(numB), bFace.get((numB + 2) % 3), TouchTester.abs(dB[numB]), TouchTester.abs(dB[(numB + 2) % 3]));
        MutVector cross = MutVector.Cross(aFace.getNormal(), bFace.getNormal()).resize(1.0);
        double[] xpA = new double[2];
        double[] xpB = new double[2];
        xpA[0] = 0.0;
        buf1.set(xA[0], xA[1]);
        xpA[1] = Vector.Dot(cross, buf1);
        buf1.set(xA[0], xB[0]);
        xpB[0] = Vector.Dot(cross, buf1);
        buf1.set(xA[0], xB[1]);
        xpB[1] = Vector.Dot(cross, buf1);
        Object[] cps = new CrossPoint[]{new CrossPoint(xA[0], xpA[0], true), new CrossPoint(xA[1], xpA[1], true), new CrossPoint(xB[0], xpB[0], false), new CrossPoint(xB[1], xpB[1], false)};
        Arrays.sort(cps);
        if (((CrossPoint)cps[0]).isShapeA == ((CrossPoint)cps[1]).isShapeA) {
            return null;
        }
        return MutVector.iDivision(((CrossPoint)cps[1]).pos, ((CrossPoint)cps[2]).pos, 1.0, 1.0);
    }

    private static MutVector getDepth(Vector c, Face aFace, Face bFace) {
        MutVector[] pA = new MutVector[]{new MutVector().set(c, aFace.getA()), new MutVector().set(c, aFace.getB()), new MutVector().set(c, aFace.getC())};
        MutVector[] pB = new MutVector[]{new MutVector().set(c, bFace.getA()), new MutVector().set(c, bFace.getB()), new MutVector().set(c, bFace.getC())};
        MutVector nA = new MutVector().set(aFace.getNormal());
        MutVector nB = new MutVector().set(bFace.getNormal());
        double dA = 0.0;
        double dB = 0.0;
        int i = 0;
        while (i < 3) {
            dA = TouchTester.max(dA, -Vector.Dot(nA, pB[i]));
            dB = TouchTester.max(dB, -Vector.Dot(nB, pA[i]));
            ++i;
        }
        nA.resize(-dA);
        nB.resize(dB);
        MutVector rtn = nA.getSize() < nB.getSize() ? nA : nB;
        MutVector v1 = new MutVector();
        MutVector v2 = new MutVector();
        MutVector va = new MutVector();
        MutVector vb = new MutVector();
        MutVector d = new MutVector();
        int i2 = 0;
        while (i2 < 3) {
            if (!aFace.isInPlane(i2) || !(rtn.getSize() < 0.1)) {
                Vector p1 = aFace.get(i2);
                v1.set(p1, aFace.get((i2 + 1) % 3)).resize(1.0);
                int j = 0;
                while (j < 3) {
                    if (!bFace.isInPlane(j) || !(rtn.getSize() < 0.1)) {
                        Vector p2 = bFace.get(j);
                        v2.set(p2, bFace.get((j + 1) % 3)).resize(1.0);
                        MutVector n = MutVector.Cross(v1, v2);
                        va.set(p1, aFace.get((i2 + 2) % 3));
                        vb.set(p2, bFace.get((j + 2) % 3));
                        if (!(Vector.Dot(n, va) * Vector.Dot(n, vb) >= 0.0)) {
                            TouchTester.lineDist(d, p1, v1, p2, v2);
                            if (d.getSize() + 0.05 < rtn.getSize()) {
                                if (aFace.isInPlane(i2) || bFace.isInPlane(j)) {
                                    if (d.getSize() * 8.0 < rtn.getSize()) {
                                        rtn.set(Vector.ZERO);
                                    }
                                } else {
                                    rtn.set(d);
                                }
                            }
                        }
                    }
                    ++j;
                }
            }
            ++i2;
        }
        if (Vector.Dot(rtn, aFace.getNormal()) / rtn.getSize() > 0.0 || Vector.Dot(rtn, bFace.getNormal()) / rtn.getSize() < 0.0) {
            rtn.set(Vector.ZERO);
        }
        return rtn;
    }

    private static void lineDist(MutVector dst, Vector p1, Vector v1, Vector p2, Vector v2) {
        dst.set(p1, p2);
        double d1 = Vector.Dot(dst, v1);
        double d2 = Vector.Dot(dst, v2);
        double dv = Vector.Dot(v1, v2);
        if (TouchTester.abs(dv) > 0.999) {
            dst.toOrthogonal(v1);
            return;
        }
        dst.add(v1, -(d1 - d2 * dv) / (1.0 - dv * dv)).add(v2, (d2 - d1 * dv) / (dv * dv - 1.0));
    }

    private static final double abs(double a) {
        return a < 0.0 ? -a : a;
    }

    private static final double max(double a, double b) {
        return a < b ? b : a;
    }

    private static class CrossPoint
    implements Comparable<CrossPoint> {
        final MutVector pos;
        final double dp;
        final boolean isShapeA;

        CrossPoint(MutVector pos, double dp, boolean isShapeA) {
            this.pos = pos;
            this.dp = dp;
            this.isShapeA = isShapeA;
        }

        @Override
        public int compareTo(CrossPoint o) {
            return Double.compare(this.dp, o.dp);
        }
    }
}

