/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.model.utils;

import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.Face;
import net.comp_lot.glui.model.Model;
import net.comp_lot.glui.model.ModelGroup;
import net.comp_lot.glui.model.Shape;
import net.comp_lot.glui.model.utils.Bound;

public class RayCast {
    private final Vector pos;
    private final Vector vec;
    private final double maxLength;
    private CastResult result;
    private final Bound bound = new Bound();
    private final MutVector endPos = new MutVector();
    private double length;

    public RayCast(Vector pos, Vector vec, double maxLength) {
        this.pos = pos;
        this.vec = vec.getSize() == 1.0 ? vec : new MutVector().set(vec).resize(1.0);
        this.maxLength = maxLength;
    }

    private void updateBound(double length) {
        this.length = length;
        this.bound.reset(this.pos);
        this.bound.set(this.endPos.set(this.pos).add(this.vec, length));
    }

    public CastResult cast(Model m) {
        return this.cast(m, null);
    }

    public CastResult cast(Model m, Model except) {
        this.result = null;
        this.updateBound(this.maxLength);
        this.castRec(m, except);
        return this.result;
    }

    private void castRec(Model m, Model except) {
        if (m != except && m.isVisible() && !m.isDecorative() && this.bound.crossing(m.getBound())) {
            if (m instanceof ModelGroup) {
                this.castGroup((ModelGroup)m, except);
            } else {
                this.castShape((Shape)m);
            }
        }
    }

    private void castGroup(ModelGroup m, Model except) {
        for (Model c : m.getAllChildren()) {
            this.castRec(c, except);
        }
    }

    private void castShape(Shape s) {
        int i = 0;
        while (i < s.getFacesNum()) {
            this.castFace(s, s.getFacesArray()[i], i);
            ++i;
        }
    }

    private void castFace(Shape s, Face face, int i) {
        if (!face.getBound().crossing(this.bound)) {
            return;
        }
        Vector n = face.getNormal();
        double nVecDot = Vector.Dot(this.vec, n);
        if (nVecDot >= 0.0) {
            return;
        }
        MutVector v = new MutVector().set(this.pos, face.getA());
        double dist = Vector.Dot(v, n) / nVecDot;
        if (dist < 0.0 || dist >= this.length) {
            return;
        }
        MutVector p = v.set(this.pos).add(this.vec, dist);
        if (RayCast.isInTriangle(face.getA(), face.getB(), face.getC(), p, -0.001)) {
            this.updateBound(dist);
            this.result = new CastResult(s, i, p, dist);
        }
    }

    private static boolean isInTriangle(Vector a, Vector b, Vector c, Vector p, double margin) {
        MutVector ba = new MutVector().set(b, a);
        MutVector bc = new MutVector().set(b, c);
        MutVector bp = new MutVector().set(b, p);
        MutVector bao = new MutVector().set(ba).toOrthogonal(bc);
        double ka = Vector.Dot(bp, bao) / (((Vector)bao).getSize() * ((Vector)bao).getSize());
        bp.add(ba, -ka);
        double kc = Vector.Dot(bp, bc) / (((Vector)bc).getSize() * ((Vector)bc).getSize());
        return margin < ka && margin < kc && ka + kc < 1.0 - margin;
    }

    public static class CastResult {
        public final Shape shape;
        public final int faceIndex;
        public final Vector point;
        public final double dist;

        private CastResult(Shape shape, int faceIndex, MutVector point, double dist) {
            this.shape = shape;
            this.faceIndex = faceIndex;
            this.point = point;
            this.dist = dist;
        }

        public Vector getNormal() {
            return this.shape.getFacesArray()[this.faceIndex].getNormal();
        }
    }
}

