/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.model.utils;

import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.Face;
import net.comp_lot.glui.model.utils.AbstractBound;

public class BoundSphere
extends AbstractBound {
    private final MutVector center = new MutVector();
    private transient double size = -1.0;
    private transient double sizeSqr = 0.0;

    public BoundSphere() {
        this.reset();
    }

    @Override
    public boolean crossing(AbstractBound b) {
        return Math.sqrt(this.center.getDistS(b.getCenter())) < this.size + b.getSize();
    }

    @Override
    public double getDepth(AbstractBound b) {
        double a = this.size + b.getSize() - Math.sqrt(this.center.getDistS(b.getCenter()));
        return a > 0.0 ? a * a : 0.0;
    }

    @Override
    public boolean contain(Vector c) {
        return this.center.getDistS(c) <= this.sizeSqr;
    }

    @Override
    public boolean contain(AbstractBound b) {
        return Math.sqrt(this.center.getDistS(b.getCenter())) + b.getSize() <= this.size;
    }

    @Override
    public void addBound(AbstractBound b) {
        if (this.size < 0.0 || !this.contain(b)) {
            this.set(b.getCenter(), b.getSize());
        }
    }

    @Override
    public void set(Vector c) {
        this.set(c, 0.0);
    }

    private void set(Vector c, double s) {
        if (this.size < 0.0) {
            this.center.set(c);
            this.size = s;
            this.sizeSqr = this.size * this.size;
        } else {
            MutVector d = new MutVector().set(this.center, c);
            if (((Vector)d).getSize() + s > this.size) {
                this.center.add(d, -this.size / ((Vector)d).getSize());
                this.size = (this.size + ((Vector)d).getSize() + s) * 0.5;
                this.sizeSqr = this.size * this.size;
                this.center.add(d, this.size / ((Vector)d).getSize());
            }
        }
    }

    @Override
    public double getMinX() {
        return this.center.getX() - this.size;
    }

    @Override
    public double getMaxX() {
        return this.center.getX() + this.size;
    }

    @Override
    public double getMinY() {
        return this.center.getY() - this.size;
    }

    @Override
    public double getMaxY() {
        return this.center.getY() + this.size;
    }

    @Override
    public double getMinZ() {
        return this.center.getZ() - this.size;
    }

    @Override
    public double getMaxZ() {
        return this.center.getZ() + this.size;
    }

    @Override
    public double getWidth() {
        return this.size * 2.0;
    }

    @Override
    public double getHeight() {
        return this.size * 2.0;
    }

    @Override
    public double getDepth() {
        return this.size * 2.0;
    }

    @Override
    public Vector getCenter() {
        return this.center;
    }

    @Override
    public double getSize() {
        return Math.max(0.0, this.size);
    }

    @Override
    public void reset() {
        this.size = -1.0;
    }

    @Override
    public void reset(Vector p) {
        this.center.set(p);
        this.size = 0.0;
        this.sizeSqr = 0.0;
    }

    @Override
    public void reset(Face face) {
        this.reset(face.getA());
        this.set(face.getB());
        this.set(face.getC());
    }

    @Override
    public void expand(double size) {
        this.size += size;
        this.sizeSqr = this.size * this.size;
    }

    @Override
    public boolean exist() {
        return this.size >= 0.0;
    }
}

