/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.model.utils;

import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.Face;
import net.comp_lot.glui.model.utils.AbstractBound;
import net.comp_lot.glui.model.utils.Bound;
import net.comp_lot.glui.model.utils.BoundSphere;

public class BoundPair
extends AbstractBound {
    private final Bound rect = new Bound();
    private final BoundSphere sphere = new BoundSphere();

    @Override
    public boolean crossing(AbstractBound b) {
        if (b instanceof BoundPair) {
            BoundPair bd = (BoundPair)b;
            return this.rect.crossing(bd.rect) && this.sphere.crossing(bd.sphere);
        }
        return this.rect.crossing(b) && this.sphere.crossing(b);
    }

    @Override
    public double getDepth(AbstractBound b) {
        if (b instanceof BoundPair) {
            BoundPair bd = (BoundPair)b;
            return Math.min(this.rect.getDepth(bd.rect), this.sphere.getDepth(bd.sphere));
        }
        return Math.min(this.rect.getDepth(b), this.sphere.getDepth(b));
    }

    @Override
    public boolean contain(Vector c) {
        return this.rect.contain(c) && this.sphere.contain(c);
    }

    @Override
    public boolean contain(AbstractBound b) {
        if (b instanceof BoundPair) {
            BoundPair bd = (BoundPair)b;
            return this.rect.contain(bd.rect) && this.sphere.contain(bd.sphere);
        }
        return this.rect.contain(b) && this.sphere.contain(b);
    }

    @Override
    public void addBound(AbstractBound b) {
        if (b instanceof BoundPair) {
            BoundPair bd = (BoundPair)b;
            this.rect.addBound(bd.rect);
            this.sphere.addBound(bd.sphere);
        } else {
            this.rect.addBound(b);
            this.sphere.addBound(b);
        }
    }

    @Override
    public void set(Vector c) {
        this.rect.set(c);
        this.sphere.set(c);
    }

    @Override
    public double getMinX() {
        return this.rect.getMinX();
    }

    @Override
    public double getMaxX() {
        return this.rect.getMaxX();
    }

    @Override
    public double getMinY() {
        return this.rect.getMinY();
    }

    @Override
    public double getMaxY() {
        return this.rect.getMaxY();
    }

    @Override
    public double getMinZ() {
        return this.rect.getMinZ();
    }

    @Override
    public double getMaxZ() {
        return this.rect.getMaxZ();
    }

    @Override
    public double getWidth() {
        return this.rect.getWidth();
    }

    @Override
    public double getHeight() {
        return this.rect.getHeight();
    }

    @Override
    public double getDepth() {
        return this.rect.getDepth();
    }

    @Override
    public Vector getCenter() {
        return this.rect.getCenter();
    }

    @Override
    public double getSize() {
        return this.rect.getSize();
    }

    @Override
    public void reset() {
        this.rect.reset();
        this.sphere.reset();
    }

    @Override
    public void reset(Vector p) {
        this.rect.reset(p);
        this.sphere.reset(p);
    }

    @Override
    public void reset(Face face) {
        this.rect.reset(face);
        this.sphere.reset(face);
    }

    @Override
    public void expand(double size) {
        this.rect.expand(size);
        this.sphere.expand(size);
    }

    @Override
    public boolean exist() {
        return this.rect.exist() && this.sphere.exist();
    }
}

