/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.model.utils;

import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.Face;
import net.comp_lot.glui.model.utils.AbstractBound;

public final class Bound
extends AbstractBound {
    private transient double tMinX;
    private transient double tMaxX;
    private transient double tMinY;
    private transient double tMaxY;
    private transient double tMinZ;
    private transient double tMaxZ;

    public Bound() {
        this.reset();
    }

    @Override
    public boolean crossing(AbstractBound b) {
        return !(this.tMinX > b.getMaxX() || this.tMaxX < b.getMinX() || this.tMinY > b.getMaxY() || this.tMaxY < b.getMinY() || this.tMinZ > b.getMaxZ() || this.tMaxZ < b.getMinZ());
    }

    @Override
    public double getDepth(AbstractBound b) {
        if (!this.crossing(b)) {
            return -1.0;
        }
        return Bound.sqrSum(Bound.min(this.tMaxX, b.getMaxX()) - Bound.max(this.tMinX, b.getMinX()), Bound.min(this.tMaxY, b.getMaxY()) - Bound.max(this.tMinY, b.getMinY()), Bound.min(this.tMaxZ, b.getMaxZ()) - Bound.max(this.tMinZ, b.getMinZ()));
    }

    private static double sqrSum(double x, double y, double z) {
        return x * x + y * y + z * z;
    }

    @Override
    public boolean contain(Vector c) {
        return this.tMinX <= c.getX() && c.getX() < this.tMaxX && this.tMinY <= c.getY() && c.getY() < this.tMaxY && this.tMinZ <= c.getZ() && c.getZ() < this.tMaxZ;
    }

    @Override
    public boolean contain(AbstractBound b) {
        return this.tMinX <= b.getMinX() && b.getMaxX() <= this.tMaxX && this.tMinY <= b.getMinY() && b.getMaxY() <= this.tMaxY && this.tMinZ <= b.getMinZ() && b.getMaxZ() <= this.tMaxZ;
    }

    @Override
    public void addBound(AbstractBound b) {
        if (b.getMinX() < this.tMinX) {
            this.tMinX = b.getMinX();
        }
        if (b.getMaxX() > this.tMaxX) {
            this.tMaxX = b.getMaxX();
        }
        if (b.getMinY() < this.tMinY) {
            this.tMinY = b.getMinY();
        }
        if (b.getMaxY() > this.tMaxY) {
            this.tMaxY = b.getMaxY();
        }
        if (b.getMinZ() < this.tMinZ) {
            this.tMinZ = b.getMinZ();
        }
        if (b.getMaxZ() > this.tMaxZ) {
            this.tMaxZ = b.getMaxZ();
        }
    }

    @Override
    public void set(Vector c) {
        this.setX(c.getX());
        this.setY(c.getY());
        this.setZ(c.getZ());
    }

    private void setX(double x) {
        this.tMinX = Bound.min(x, this.tMinX);
        this.tMaxX = Bound.max(x, this.tMaxX);
    }

    private void setY(double y) {
        this.tMinY = Bound.min(y, this.tMinY);
        this.tMaxY = Bound.max(y, this.tMaxY);
    }

    private void setZ(double z) {
        this.tMinZ = Bound.min(z, this.tMinZ);
        this.tMaxZ = Bound.max(z, this.tMaxZ);
    }

    @Override
    public double getMinX() {
        return this.tMinX;
    }

    @Override
    public double getMaxX() {
        return this.tMaxX;
    }

    @Override
    public double getMinY() {
        return this.tMinY;
    }

    @Override
    public double getMaxY() {
        return this.tMaxY;
    }

    @Override
    public double getMinZ() {
        return this.tMinZ;
    }

    @Override
    public double getMaxZ() {
        return this.tMaxZ;
    }

    @Override
    public double getWidth() {
        return this.getMaxX() - this.getMinX();
    }

    @Override
    public double getHeight() {
        return this.getMaxY() - this.getMinY();
    }

    @Override
    public double getDepth() {
        return this.getMaxZ() - this.getMinZ();
    }

    @Override
    public Vector getCenter() {
        return new MutVector().set((this.getMinX() + this.getMaxX()) * 0.5, (this.getMinY() + this.getMaxY()) * 0.5, (this.getMinZ() + this.getMaxZ()) * 0.5);
    }

    @Override
    public double getSize() {
        return Math.sqrt(Bound.pow(this.getMaxX() - this.getMinX()) + Bound.pow(this.getMaxY() - this.getMinY()) + Bound.pow(this.getMaxZ() - this.getMinZ())) / 2.0;
    }

    @Override
    public void reset() {
        this.tMinX = 3.4028234663852886E38;
        this.tMaxX = -3.4028234663852886E38;
        this.tMinY = 3.4028234663852886E38;
        this.tMaxY = -3.4028234663852886E38;
        this.tMinZ = 3.4028234663852886E38;
        this.tMaxZ = -3.4028234663852886E38;
    }

    @Override
    public void reset(Vector p) {
        this.tMinX = p.getX();
        this.tMaxX = p.getX();
        this.tMinY = p.getY();
        this.tMaxY = p.getY();
        this.tMinZ = p.getZ();
        this.tMaxZ = p.getZ();
    }

    @Override
    public void reset(Face face) {
        this.reset(face.getA());
        this.set(face.getB());
        this.set(face.getC());
    }

    private static final double max(double a, double b) {
        return a > b ? a : b;
    }

    private static final double min(double a, double b) {
        return a < b ? a : b;
    }

    private static final double pow(double a) {
        return a * a;
    }

    @Override
    public void expand(double size) {
        this.expandX(size);
        this.expandY(size);
        this.expandZ(size);
    }

    public void expandZ(double size) {
        this.tMinZ -= size;
        this.tMaxZ += size;
    }

    public void expandY(double size) {
        this.tMinY -= size;
        this.tMaxY += size;
    }

    public void expandX(double size) {
        this.tMinX -= size;
        this.tMaxX += size;
    }

    @Override
    public boolean exist() {
        return this.tMinX < this.tMaxX;
    }
}

