/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.model.model;

import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.Shape;
import net.comp_lot.glui.model.TextureInfo;

public class PolygonShape
extends Shape {
    private static final long serialVersionUID = 139744172560743082L;
    private static final int[] VERTEX_MAP;
    private static final int[] FACES;
    private final float[] tex;

    static {
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        VERTEX_MAP = nArray;
        int[] nArray2 = new int[3];
        nArray2[1] = 1;
        nArray2[2] = 2;
        FACES = nArray2;
    }

    public PolygonShape(Vector v1, Vector v2, Vector v3, TextureInfo tex) {
        this(v1, v2, v3, new Vector[0], tex);
    }

    public PolygonShape(Vector v1, Vector v2, Vector v3, Vector n1, Vector n2, Vector n3, TextureInfo tex) {
        this(v1, v2, v3, new Vector[]{n1, n2, n3}, tex);
    }

    private PolygonShape(Vector v1, Vector v2, Vector v3, Vector[] normals, TextureInfo tex) {
        super(3);
        this.vertex_local = new MutVector[3];
        this.vertex_local[0] = new MutVector().set(v1);
        this.vertex_local[1] = new MutVector().set(v2);
        this.vertex_local[2] = new MutVector().set(v3);
        this.tex = new float[]{tex.getX(), tex.getY(), tex.getWidth(), tex.getHeight(), 1.0f};
        this.initFaces(this.getFacesNum(), normals);
    }

    public PolygonShape(int width, int height, TextureInfo tex) {
        this(width, height, tex.getX(), tex.getY(), tex.getWidth(), tex.getHeight());
    }

    public PolygonShape(double width, double height, float texX, float texY, float texW, float texH) {
        super(3);
        this.vertex_local = new MutVector[3];
        this.vertex_local[0] = new MutVector().set(0.0, 0.0, 0.0);
        this.vertex_local[1] = new MutVector().set(0.0, -height, 0.0);
        this.vertex_local[2] = new MutVector().set(width, -height / 2.0, 0.0);
        this.tex = new float[]{texX, texY, texW, texH, 1.0f};
        this.initFaces();
    }

    @Override
    protected int getPointNum() {
        return 3;
    }

    @Override
    public int getFacesNum() {
        return 1;
    }

    @Override
    protected int[] getFaces() {
        return FACES;
    }

    @Override
    protected int getVertexNum() {
        return 3;
    }

    @Override
    protected int[] getVertexMap() {
        return VERTEX_MAP;
    }

    @Override
    protected float[] getTexCoords() {
        return this.tex;
    }
}

