/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.model.model;

import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.Shape;
import net.comp_lot.glui.model.TextureInfo;

public class PlaneShape
extends Shape {
    private static final long serialVersionUID = 2976608141575956216L;
    private static final int[] VERTEX_MAP;
    private static final int[] FACES;
    private final float[] tex;

    static {
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        VERTEX_MAP = nArray;
        int[] nArray2 = new int[6];
        nArray2[1] = 1;
        nArray2[2] = 2;
        nArray2[3] = 2;
        nArray2[4] = 3;
        FACES = nArray2;
    }

    public PlaneShape(double width, double height, TextureInfo tex) {
        this(width, height, tex.getX(), tex.getY(), tex.getWidth(), tex.getHeight());
    }

    public PlaneShape(double width, double height, float texX, float texY, float texW, float texH) {
        this(new MutVector().set(0.0, 0.0, 0.0), new MutVector().set(0.0, -height, 0.0), new MutVector().set(width, -height, 0.0), new MutVector().set(width, 0.0, 0.0), texX, texY, texW, texH);
    }

    private PlaneShape(MutVector v1, MutVector v2, MutVector v3, MutVector v4, float texX, float texY, float texW, float texH) {
        super(4);
        this.vertex_local = new MutVector[]{v1, v2, v3, v4};
        this.tex = PlaneShape.getTex(texX, texY, texW, texH);
        this.initFaces();
    }

    public PlaneShape(Vector v1, Vector v2, Vector v3, Vector v4, TextureInfo tex) {
        this(v1, v2, v3, v4, new Vector[0], tex);
    }

    public PlaneShape(Vector v1, Vector v2, Vector v3, Vector v4, Vector n1, Vector n2, Vector n3, Vector n4, TextureInfo tex) {
        this(v1, v2, v3, v4, new Vector[]{n1, n2, n3, n4}, tex);
    }

    private PlaneShape(Vector v1, Vector v2, Vector v3, Vector v4, Vector[] normals, TextureInfo tex) {
        super(4);
        this.vertex_local = new MutVector[4];
        this.vertex_local[0] = new MutVector().set(v1);
        this.vertex_local[1] = new MutVector().set(v2);
        this.vertex_local[2] = new MutVector().set(v3);
        this.vertex_local[3] = new MutVector().set(v4);
        this.tex = PlaneShape.getTex(tex.getX(), tex.getY(), tex.getWidth(), tex.getHeight());
        this.initFaces(this.getFacesNum(), normals);
    }

    private static float[] getTex(float texX, float texY, float texW, float texH) {
        return new float[]{texX, texY, texW, texH, 1.0f, texX, texY, texW, texH, 0.0f};
    }

    @Override
    protected int getPointNum() {
        return 4;
    }

    @Override
    public int getFacesNum() {
        return 2;
    }

    @Override
    protected int[] getFaces() {
        return FACES;
    }

    @Override
    protected int getVertexNum() {
        return 4;
    }

    @Override
    protected int[] getVertexMap() {
        return VERTEX_MAP;
    }

    @Override
    protected float[] getTexCoords() {
        return this.tex;
    }
}

