/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.model.model;

import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.Shape;
import net.comp_lot.glui.model.TextureInfo;

public class IcosahedronShape
extends Shape {
    private static final long serialVersionUID = -8179564965509142644L;
    private static final double T = (1.0 + Math.sqrt(5.0)) / 2.0;
    private static final Vector[] POINTS = new Vector[]{new MutVector().set(0.0, T, -1.0), new MutVector().set(0.0, T, 1.0), new MutVector().set(0.0, -T, 1.0), new MutVector().set(0.0, -T, -1.0), new MutVector().set(-1.0, 0.0, T), new MutVector().set(1.0, 0.0, T), new MutVector().set(1.0, 0.0, -T), new MutVector().set(-1.0, 0.0, -T), new MutVector().set(T, -1.0, 0.0), new MutVector().set(T, 1.0, 0.0), new MutVector().set(-T, 1.0, 0.0), new MutVector().set(-T, -1.0, 0.0)};
    private static final int[] VERTEX_MAP;
    private static final int[] FACES;
    private final float[] tex = new float[120];

    static {
        int[] nArray = new int[60];
        nArray[0] = 1;
        nArray[1] = 9;
        nArray[2] = 5;
        nArray[3] = 1;
        nArray[4] = 5;
        nArray[5] = 4;
        nArray[6] = 1;
        nArray[7] = 4;
        nArray[8] = 10;
        nArray[9] = 1;
        nArray[10] = 10;
        nArray[13] = 9;
        nArray[14] = 1;
        nArray[16] = 10;
        nArray[17] = 7;
        nArray[19] = 7;
        nArray[20] = 6;
        nArray[22] = 6;
        nArray[23] = 9;
        nArray[24] = 6;
        nArray[25] = 8;
        nArray[26] = 9;
        nArray[27] = 5;
        nArray[28] = 9;
        nArray[29] = 8;
        nArray[30] = 4;
        nArray[31] = 11;
        nArray[32] = 10;
        nArray[33] = 7;
        nArray[34] = 10;
        nArray[35] = 11;
        nArray[36] = 3;
        nArray[37] = 6;
        nArray[38] = 7;
        nArray[39] = 3;
        nArray[40] = 8;
        nArray[41] = 6;
        nArray[42] = 3;
        nArray[43] = 2;
        nArray[44] = 8;
        nArray[45] = 2;
        nArray[46] = 5;
        nArray[47] = 8;
        nArray[48] = 2;
        nArray[49] = 4;
        nArray[50] = 5;
        nArray[51] = 2;
        nArray[52] = 11;
        nArray[53] = 4;
        nArray[54] = 3;
        nArray[55] = 11;
        nArray[56] = 2;
        nArray[57] = 3;
        nArray[58] = 7;
        nArray[59] = 11;
        VERTEX_MAP = nArray;
        FACES = new int[60];
        int i = 0;
        while (i < 20) {
            IcosahedronShape.FACES[i * 3] = i * 3;
            IcosahedronShape.FACES[i * 3 + 1] = i * 3 + 1;
            IcosahedronShape.FACES[i * 3 + 2] = i * 3 + 2;
            ++i;
        }
    }

    public IcosahedronShape(double size, TextureInfo tex) {
        super(12);
        this.vertex_local = new MutVector[12];
        int i = 0;
        while (i < 12) {
            this.vertex_local[i] = new MutVector().set(POINTS[i]).resize(size);
            ++i;
        }
        this.setOpaque(false);
        this.initFaces();
        this.initTex(tex);
    }

    private void initTex(TextureInfo tex) {
        int i = 0;
        while (i < 20) {
            this.tex[i * 5] = tex.getX();
            this.tex[i * 5 + 1] = tex.getY();
            this.tex[i * 5 + 2] = tex.getWidth();
            this.tex[i * 5 + 3] = tex.getHeight();
            this.tex[i * 5 + 4] = 0.0f;
            ++i;
        }
    }

    @Override
    protected int getPointNum() {
        return 12;
    }

    @Override
    public int getFacesNum() {
        return 20;
    }

    @Override
    protected int[] getFaces() {
        return FACES;
    }

    @Override
    protected float[] getTexCoords() {
        return this.tex;
    }

    @Override
    protected int getVertexNum() {
        return 60;
    }

    @Override
    protected int[] getVertexMap() {
        return VERTEX_MAP;
    }
}

