/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.model.model;

import java.util.Collection;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.Face;
import net.comp_lot.glui.model.model.BoxShape;
import net.comp_lot.glui.model.utils.Bound;
import net.comp_lot.glui.model.utils.TouchInfo;

public class BoxShapeTouchTester {
    private static final double MIN_SIZE = 0.005;
    private static final double MIN_SIZE_EDGE = 0.05;
    private static final int[][] EDGES;

    static {
        int[][] nArrayArray = new int[12][];
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[3] = 2;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[4];
        nArray2[0] = 1;
        nArray2[1] = 2;
        nArray2[3] = 3;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[4];
        nArray3[0] = 2;
        nArray3[1] = 3;
        nArray3[3] = 4;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[4];
        nArray4[0] = 3;
        nArray4[3] = 5;
        nArrayArray[3] = nArray4;
        int[] nArray5 = new int[4];
        nArray5[1] = 4;
        nArray5[2] = 5;
        nArray5[3] = 2;
        nArrayArray[4] = nArray5;
        nArrayArray[5] = new int[]{1, 5, 2, 3};
        nArrayArray[6] = new int[]{2, 6, 3, 4};
        nArrayArray[7] = new int[]{3, 7, 4, 5};
        nArrayArray[8] = new int[]{4, 5, 1, 2};
        nArrayArray[9] = new int[]{5, 6, 1, 3};
        nArrayArray[10] = new int[]{6, 7, 1, 4};
        nArrayArray[11] = new int[]{7, 4, 1, 5};
        EDGES = nArrayArray;
    }

    public static void testShape(BoxShape a, BoxShape b, Collection<TouchInfo> list) {
        BoxShapeTouchTester.testVertices(a, b, list, false);
        BoxShapeTouchTester.testVertices(b, a, list, true);
        BoxShapeTouchTester.testEdges(a, b, list, false);
        BoxShapeTouchTester.testEdges(b, a, list, true);
    }

    private static void testEdges(BoxShape a, BoxShape b, Collection<TouchInfo> list, boolean rev) {
        Bound bound = new Bound();
        int i = 0;
        while (i < EDGES.length) {
            Vector p1 = a.getVertexGlobal()[EDGES[i][0]];
            Vector p2 = a.getVertexGlobal()[EDGES[i][1]];
            bound.reset(p1);
            bound.set(p2);
            if (b.getBound().crossing(bound)) {
                BoxShapeTouchTester.testEdge(p1, p2, a, b, list, rev, bound);
            }
            ++i;
        }
    }

    private static void testEdge(Vector ap1, Vector ap2, BoxShape a, BoxShape b, Collection<TouchInfo> list, boolean rev, Bound edgeBound) {
        MutVector av = new MutVector().set(ap1, ap2);
        PosDepth[] faces = new PosDepth[6];
        int cnt = 0;
        int i = 0;
        while (i < 6) {
            if (edgeBound.crossing(b.getFacesArray()[i * 2].getBound()) || edgeBound.crossing(b.getFacesArray()[i * 2 + 1].getBound())) {
                faces[i] = BoxShapeTouchTester.testEdgeFace(ap1, av, b.getFacesArray()[i * 2], 0.05);
                if (faces[i] != null && ++cnt >= 2) break;
            }
            ++i;
        }
        if (cnt >= 2) {
            TouchInfo ee = null;
            int i2 = 0;
            while (i2 < EDGES.length) {
                if (faces[EDGES[i2][2]] != null && faces[EDGES[i2][3]] != null) {
                    PosDepth pd = BoxShapeTouchTester.edgeDist(ap1, ap2, b.getVertexGlobal()[EDGES[i2][0]], b.getVertexGlobal()[EDGES[i2][1]], rev);
                    if (rev) {
                        ee = new TouchInfo(pd.pos, pd.vec, b, a);
                        break;
                    }
                    ee = new TouchInfo(pd.pos, pd.vec, a, b);
                    break;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < 6) {
                if (faces[i2] != null) {
                    MutVector v = faces[i2].vec;
                    if (ee != null && v.getSize() < ee.getVec().getSize()) {
                        ee = null;
                    }
                    if (v.getSize() > 0.05) {
                        if (ee != null && v.getSize() > ee.getVec().getSize()) {
                            list.add(ee);
                            return;
                        }
                        if (rev) {
                            list.add(new TouchInfo(faces[i2].pos, v.reverse(), b, a));
                        } else {
                            list.add(new TouchInfo(faces[i2].pos, v, a, b));
                        }
                    }
                }
                ++i2;
            }
        }
    }

    private static PosDepth testEdgeFace(Vector p1, Vector v, Face face, double margin) {
        MutVector dist = new MutVector().set(p1, face.getB()).toParallel(face.getNormal());
        double k = dist.getSize() * dist.getSize() / Vector.Dot(v, dist);
        if (k * v.getSize() < 0.05 || (1.0 - k) * v.getSize() < 0.05) {
            return null;
        }
        MutVector p = new MutVector().set(p1).add(v, k);
        MutVector bp = new MutVector().set(face.getB(), p);
        MutVector ba = new MutVector().set(face.getB(), face.getA());
        MutVector bc = new MutVector().set(face.getB(), face.getC());
        double ka = Vector.Dot(bp, ba) / ba.getSize();
        double kc = Vector.Dot(bp, bc) / bc.getSize();
        double da = ba.getSize() - ka;
        double dc = bc.getSize() - kc;
        if (ka < da) {
            if (kc < dc) {
                if (ka < kc) {
                    if (ka < margin) {
                        return null;
                    }
                    return new PosDepth(p, ba.resize(-ka));
                }
                if (kc < margin) {
                    return null;
                }
                return new PosDepth(p, bc.resize(-kc));
            }
            if (ka < dc) {
                if (ka < margin) {
                    return null;
                }
                return new PosDepth(p, ba.resize(-ka));
            }
            if (dc < margin) {
                return null;
            }
            return new PosDepth(p, bc.resize(dc));
        }
        if (kc < dc) {
            if (da < kc) {
                if (da < margin) {
                    return null;
                }
                return new PosDepth(p, ba.resize(da));
            }
            if (kc < margin) {
                return null;
            }
            return new PosDepth(p, bc.resize(-kc));
        }
        if (da < dc) {
            if (da < margin) {
                return null;
            }
            return new PosDepth(p, ba.resize(da));
        }
        if (dc < margin) {
            return null;
        }
        return new PosDepth(p, bc.resize(dc));
    }

    private static PosDepth edgeDist(Vector ap1, Vector ap2, Vector bp1, Vector bp2, boolean rev) {
        MutVector v1 = new MutVector().set(ap1, ap2).resize(1.0);
        MutVector v2 = new MutVector().set(bp1, bp2).resize(1.0);
        MutVector dst = new MutVector().set(ap1, bp1);
        double d1 = Vector.Dot(dst, v1);
        double d2 = Vector.Dot(dst, v2);
        double v1v2 = Vector.Dot(v1, v2);
        double k1 = (d1 - d2 * v1v2) / (1.0 - v1v2 * v1v2);
        double k2 = (d2 - d1 * v1v2) / (v1v2 * v1v2 - 1.0);
        v1.scale(k1).add(ap1);
        v2.scale(k2).add(bp1);
        if (rev) {
            return new PosDepth(v2, dst.set(v2, v1));
        }
        return new PosDepth(v1, dst.set(v1, v2));
    }

    private static void testVertices(BoxShape a, BoxShape b, Collection<TouchInfo> list, boolean rev) {
        MutVector aCenter = new MutVector().set(a.getVertexGlobal()[0]).add(a.getVertexGlobal()[6]).scale(0.5);
        MutVector bCenter = new MutVector().set(b.getVertexGlobal()[0]).add(b.getVertexGlobal()[6]).scale(0.5);
        MutVector inside = new MutVector();
        int i = 0;
        while (i < 8) {
            Vector p = a.getVertexGlobal()[i];
            if (b.getBound().contain(p)) {
                inside.set(p, aCenter);
                Vector v = BoxShapeTouchTester.testVertex(p, inside, b, bCenter);
                if (v != null && v.getSize() > 0.005) {
                    if (rev) {
                        list.add(new TouchInfo(new MutVector().set(p), new MutVector().set(v).reverse(), b, a));
                    } else {
                        list.add(new TouchInfo(new MutVector().set(p), new MutVector().set(v), a, b));
                    }
                }
            }
            ++i;
        }
    }

    private static Vector testVertex(Vector vertex, Vector inside, BoxShape b, Vector bCenter) {
        Vector rtn = null;
        MutVector bv = new MutVector().set(bCenter, vertex);
        int i = 0;
        while (i < 6) {
            Vector v = BoxShapeTouchTester.testVertexFace(vertex, inside, b.getFacesArray()[i * 2]);
            if (v != null && (rtn == null || v.getSize() < rtn.getSize()) && Vector.Dot(v, bv) > 0.0) {
                rtn = v;
            }
            ++i;
        }
        return rtn;
    }

    private static Vector testVertexFace(Vector vertex, Vector inside, Face face) {
        if (Vector.Dot(inside, face.getNormal()) <= 0.0) {
            return null;
        }
        MutVector dist = new MutVector().set(vertex, face.getB());
        if (Vector.Dot(dist, face.getNormal()) <= 0.0) {
            return null;
        }
        dist.toParallel(face.getNormal());
        MutVector ba = new MutVector().set(face.getB(), face.getA());
        MutVector bc = new MutVector().set(face.getB(), face.getC());
        MutVector bp1 = new MutVector().set(face.getB(), vertex).add(dist);
        if (BoxShapeTouchTester.inRect(bp1, ba, bc, 0.01)) {
            return dist;
        }
        MutVector bp2 = new MutVector().set(face.getB(), vertex).add(inside, dist.getSize() / Vector.Dot(inside, face.getNormal()));
        if (BoxShapeTouchTester.inRect(bp1, ba, bc, -1.0E-5) && BoxShapeTouchTester.inRect(bp2, ba, bc, 0.01)) {
            return dist;
        }
        return null;
    }

    private static boolean inRect(Vector p, Vector a, Vector b, double margin) {
        double ka = Vector.Dot(p, a) / a.getSize();
        double kb = Vector.Dot(p, b) / b.getSize();
        return margin < ka && ka < a.getSize() - margin && margin < kb && kb < b.getSize() - margin;
    }

    private static class PosDepth {
        private MutVector pos;
        private MutVector vec;

        private PosDepth(MutVector pos, MutVector vec) {
            this.pos = pos;
            this.vec = vec;
        }
    }
}

