/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.model.model;

import java.util.Collection;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.Face;
import net.comp_lot.glui.model.Shape;
import net.comp_lot.glui.model.TextureInfo;
import net.comp_lot.glui.model.model.BoxShapeTouchTester;
import net.comp_lot.glui.model.utils.TouchInfo;

public class BoxShape
extends Shape {
    private static final long serialVersionUID = -1890337205051175548L;
    private static final int VERTEX_NUM = 8;
    private static final int[] VERTEX_MAP;
    private static final int VERTEX_MAP_NUM;
    private static final int[] FACES;
    private static final int FACES_NUM;
    private float[] tex;
    private transient boolean isRect = false;

    static {
        int[] nArray = new int[24];
        nArray[0] = 1;
        nArray[1] = 2;
        nArray[2] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        nArray[7] = 7;
        nArray[9] = 4;
        nArray[10] = 5;
        nArray[11] = 1;
        nArray[12] = 2;
        nArray[13] = 6;
        nArray[14] = 7;
        nArray[15] = 3;
        nArray[16] = 3;
        nArray[17] = 7;
        nArray[18] = 4;
        nArray[20] = 1;
        nArray[21] = 5;
        nArray[22] = 6;
        nArray[23] = 2;
        VERTEX_MAP = nArray;
        VERTEX_MAP_NUM = VERTEX_MAP.length;
        int[] nArray2 = new int[36];
        nArray2[1] = 1;
        nArray2[2] = 2;
        nArray2[3] = 2;
        nArray2[4] = 3;
        nArray2[6] = 4;
        nArray2[7] = 7;
        nArray2[8] = 6;
        nArray2[9] = 6;
        nArray2[10] = 5;
        nArray2[11] = 4;
        nArray2[12] = 8;
        nArray2[13] = 9;
        nArray2[14] = 10;
        nArray2[15] = 10;
        nArray2[16] = 11;
        nArray2[17] = 8;
        nArray2[18] = 20;
        nArray2[19] = 21;
        nArray2[20] = 22;
        nArray2[21] = 22;
        nArray2[22] = 23;
        nArray2[23] = 20;
        nArray2[24] = 12;
        nArray2[25] = 13;
        nArray2[26] = 14;
        nArray2[27] = 14;
        nArray2[28] = 15;
        nArray2[29] = 12;
        nArray2[30] = 16;
        nArray2[31] = 17;
        nArray2[32] = 18;
        nArray2[33] = 18;
        nArray2[34] = 19;
        nArray2[35] = 16;
        FACES = nArray2;
        FACES_NUM = FACES.length / 3;
    }

    public BoxShape(float[] vertex, TextureInfo texture) {
        super(8);
        this.init(vertex);
        this.initDefaultTex(texture);
        this.initFaces();
        this.onConfirmCoordinate(true);
        this.isRect = true;
        Face[] faceArray = this.getFacesArray();
        int n = faceArray.length;
        int n2 = 0;
        while (n2 < n) {
            Face a = faceArray[n2];
            Face[] faceArray2 = this.getFacesArray();
            int n3 = faceArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                Face b = faceArray2[n4];
                double d = Math.abs(Vector.Dot(a.getNormal(), b.getNormal()));
                if (!(-0.01 < d && d < 0.01 || 0.99 < d && d < 1.01)) {
                    this.isRect = false;
                }
                ++n4;
            }
            ++n2;
        }
    }

    public BoxShape(float width, float height, float depth, TextureInfo texture) {
        this(new float[]{-width / 2.0f, height / 2.0f, -depth / 2.0f, width / 2.0f, height / 2.0f, -depth / 2.0f, width / 2.0f, height / 2.0f, depth / 2.0f, -width / 2.0f, height / 2.0f, depth / 2.0f, -width / 2.0f, -height / 2.0f, -depth / 2.0f, width / 2.0f, -height / 2.0f, -depth / 2.0f, width / 2.0f, -height / 2.0f, depth / 2.0f, -width / 2.0f, -height / 2.0f, depth / 2.0f}, texture);
    }

    public void setTex(int face, TextureInfo texture) {
        this.tex[face * 5] = texture.getX();
        this.tex[face * 5 + 1] = texture.getY();
    }

    public void setTex(TextureInfo texture) {
        int i = 0;
        while (i < FACES_NUM) {
            this.setTex(i, texture);
            ++i;
        }
    }

    private void init(float[] vertex) {
        this.vertex_local = new MutVector[8];
        int i = 0;
        while (i < 8) {
            this.vertex_local[i] = new MutVector().set(vertex[i * 3], vertex[i * 3 + 1], vertex[i * 3 + 2]);
            ++i;
        }
    }

    private void initDefaultTex(TextureInfo texture) {
        this.tex = new float[FACES_NUM * 5];
        MutVector buf = new MutVector();
        int i = 0;
        while (i < FACES_NUM) {
            int h = (int)Math.round(buf.set(this.vertex_local[VERTEX_MAP[FACES[i * 3]]], this.vertex_local[VERTEX_MAP[FACES[i * 3 + 1]]]).getSize() / 2.0);
            int w = (int)Math.round(buf.set(this.vertex_local[VERTEX_MAP[FACES[i * 3 + 1]]], this.vertex_local[VERTEX_MAP[FACES[i * 3 + 2]]]).getSize() / 2.0);
            this.tex[i * 5] = texture.getX();
            this.tex[i * 5 + 1] = texture.getY();
            this.tex[i * 5 + 2] = w * texture.getWidth();
            this.tex[i * 5 + 3] = h * texture.getHeight();
            this.tex[i * 5 + 4] = (i + 1) % 2;
            ++i;
        }
    }

    @Override
    public int getPointNum() {
        return 8;
    }

    @Override
    public int[] getFaces() {
        return FACES;
    }

    @Override
    public int getFacesNum() {
        return FACES_NUM;
    }

    @Override
    public int getVertexNum() {
        return VERTEX_MAP_NUM;
    }

    @Override
    public int[] getVertexMap() {
        return VERTEX_MAP;
    }

    @Override
    public float[] getTexCoords() {
        return this.tex;
    }

    @Override
    protected void initFaces(int facesNum, Vector[] normals) {
        super.initFaces(facesNum, normals);
        int i = 0;
        while (i < 6) {
            this.getFacesArray()[i * 2].setInPlane(2, true);
            this.getFacesArray()[i * 2 + 1].setInPlane(2, true);
            ++i;
        }
    }

    @Override
    protected void onShapeTouchTest(Shape s, Collection<TouchInfo> list) {
        if (this.isRect && s instanceof BoxShape && ((BoxShape)s).isRect) {
            BoxShapeTouchTester.testShape(this, (BoxShape)s, list);
        } else {
            super.onShapeTouchTest(s, list);
        }
    }
}

