/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.model;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.RGBAColor;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.display.DrawData;
import net.comp_lot.glui.display.DualDrawData;
import net.comp_lot.glui.model.Face;
import net.comp_lot.glui.model.Model;
import net.comp_lot.glui.model.ModelGroup;
import net.comp_lot.glui.model.utils.TouchInfo;
import net.comp_lot.glui.model.utils.TouchTester;

public abstract class Shape
extends Model {
    private static final long serialVersionUID = -336501426160647615L;
    private boolean opaque = true;
    private float red;
    private float green;
    private float blue;
    private float alpha;
    private transient RGBAColor color;
    private int tex = 0;
    protected MutVector[] vertex_local;
    private transient MutVector[] vertex_global;
    private transient boolean boundUpdated = true;
    private boolean vertexNormal = false;
    private transient Vector[] normalLocal;
    private transient MutVector[] normalGlobal;
    private transient Face[] faces;
    private transient int dataOffset = -1;
    private transient int prevCnt;
    private transient boolean updateTransform;
    private transient boolean updateMaterial;

    public Shape(int pointNum) {
        this.setColor(-1);
        this.vertex_global = new MutVector[pointNum];
        int i = 0;
        while (i < pointNum) {
            this.vertex_global[i] = new MutVector();
            ++i;
        }
    }

    public final void setTexture(int tex) {
        this.tex = tex;
    }

    protected final void initFaces() {
        this.initFaces(this.getFacesNum(), new Vector[0]);
    }

    protected void initFaces(int facesNum, Vector[] normals) {
        this.vertexNormal = normals.length != 0;
        this.faces = new Face[facesNum];
        this.normalLocal = new Vector[facesNum + normals.length];
        this.normalGlobal = new MutVector[facesNum + normals.length];
        int i = 0;
        while (i < facesNum) {
            this.normalLocal[i] = MutVector.Cross(new MutVector().set(this.vertex_local[this.getVertexMap()[this.getFaces()[i * 3]]], this.vertex_local[this.getVertexMap()[this.getFaces()[i * 3 + 2]]]), new MutVector().set(this.vertex_local[this.getVertexMap()[this.getFaces()[i * 3]]], this.vertex_local[this.getVertexMap()[this.getFaces()[i * 3 + 1]]])).resize(1.0);
            this.normalGlobal[i] = new MutVector();
            this.faces[i] = new Face(this.vertex_global[this.getVertexMap()[this.getFaces()[i * 3]]], this.vertex_global[this.getVertexMap()[this.getFaces()[i * 3 + 1]]], this.vertex_global[this.getVertexMap()[this.getFaces()[i * 3 + 2]]], this.normalGlobal[i]);
            ++i;
        }
        i = 0;
        while (i < normals.length) {
            this.normalLocal[facesNum + i] = normals[i];
            this.normalGlobal[facesNum + i] = new MutVector();
            ++i;
        }
    }

    public void setOpaque(boolean opaque) {
        this.opaque = opaque;
    }

    public boolean isOpaque() {
        return this.opaque;
    }

    public void setColor(int color) {
        this.red = (float)(color >> 24 & 0xFF) / 255.0f;
        this.green = (float)(color >> 16 & 0xFF) / 255.0f;
        this.blue = (float)(color >> 8 & 0xFF) / 255.0f;
        this.alpha = (float)(color & 0xFF) / 255.0f;
        this.color = new RGBAColor(this.red, this.green, this.blue, this.alpha);
        this.updateMaterial = true;
    }

    protected abstract int getPointNum();

    public abstract int getFacesNum();

    protected abstract int[] getFaces();

    protected abstract float[] getTexCoords();

    protected abstract int getVertexNum();

    protected abstract int[] getVertexMap();

    public final Vector[] getVertexGlobal() {
        return this.vertex_global;
    }

    public Color getFaceColor(int i) {
        return new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.color.getAlpha());
    }

    public Face[] getFacesArray() {
        return this.faces;
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && this.color.getAlpha() != 0.0f;
    }

    @Override
    public final void putDrawData(DualDrawData dualData) {
        int i;
        boolean update;
        DrawData data = this.opaque ? dualData.getOpaqueData() : dualData.getTransparentData();
        int vertexNum = this.getVertexNum();
        int facesNum = this.getFacesNum();
        int index = data.getVertexNum();
        boolean bl = update = this.dataOffset != index || data.getCnt() != this.prevCnt + 1;
        if (update || this.updateTransform || this.updateMaterial) {
            data.setVertexFirst();
        }
        if (update || this.updateTransform) {
            int[] vertexMap = this.getVertexMap();
            i = 0;
            while (i < vertexNum) {
                data.addVertex(this.getVertexGlobal()[vertexMap[i]]);
                ++i;
            }
            i = 0;
            while (i < facesNum) {
                this.addTriangle(data, i);
                ++i;
            }
        } else {
            data.skipVertex(vertexNum);
            data.skipIndex(facesNum * 3);
        }
        if (update || this.updateMaterial) {
            float[] tex = this.getTexCoords();
            i = 0;
            while (i < facesNum) {
                this.setMaterial(data, i, tex[i * 5], tex[i * 5 + 1], tex[i * 5 + 2], tex[i * 5 + 3], tex[i * 5 + 4] == 1.0f);
                ++i;
            }
        }
        this.updateTransform = false;
        this.updateMaterial = false;
        this.dataOffset = index;
        this.prevCnt = data.getCnt();
    }

    private final void addTriangle(DrawData data, int faceIndex) {
        int[] faces = this.getFaces();
        if (this.vertexNormal) {
            int facesNum = this.getFacesNum();
            data.addTriangle(faces[faceIndex * 3], faces[faceIndex * 3 + 1], faces[faceIndex * 3 + 2], this.normalGlobal[facesNum + faces[faceIndex * 3]], this.normalGlobal[facesNum + faces[faceIndex * 3 + 1]], this.normalGlobal[facesNum + faces[faceIndex * 3 + 2]]);
        } else {
            data.addTriangle(faces[faceIndex * 3], faces[faceIndex * 3 + 1], faces[faceIndex * 3 + 2], this.normalGlobal[faceIndex], this.normalGlobal[faceIndex], this.normalGlobal[faceIndex]);
        }
    }

    private final void setMaterial(DrawData data, int faceIndex, float texX, float texY, float texW, float texH, boolean first) {
        int[] faces = this.getFaces();
        data.setTriangleMaterial(faces[faceIndex * 3], faces[faceIndex * 3 + 1], faces[faceIndex * 3 + 2], this.tex, texX, texY, texW, texH, first, this.color);
    }

    @Override
    public final void onConfirmCoordinate(boolean updated) {
        if (updated) {
            this.confirmGlobal();
            int i = 0;
            while (i < this.vertex_local.length) {
                this.LocalToGlobalCoord(this.vertex_global[i], this.vertex_local[i]);
                ++i;
            }
            i = 0;
            while (i < this.normalLocal.length) {
                this.LocalToGlobal(this.normalGlobal[i], this.normalLocal[i]);
                ++i;
            }
            this.boundUpdated = true;
            this.updateTransform = true;
        }
    }

    @Override
    public final boolean setBound() {
        if (this.boundUpdated) {
            this.boundUpdated = false;
            this.bound.reset();
            Face[] faceArray = this.faces;
            int n = this.faces.length;
            int n2 = 0;
            while (n2 < n) {
                Face f = faceArray[n2];
                f.setBound();
                this.bound.addBound(f.getBound());
                ++n2;
            }
            return true;
        }
        return false;
    }

    @Override
    public void moveShapes(Vector v, double rate) {
        MutVector vL = new MutVector();
        this.GlobalToLocal(vL, v);
        this.moveL(vL, rate);
    }

    @Override
    public void rotateShapes(Vector center, Vector axis, double angle) {
        MutVector centerL = new MutVector();
        MutVector axisL = new MutVector();
        this.GlobalToLocalCoord(centerL, center);
        this.GlobalToLocal(axisL, axis);
        this.rotateL(centerL, axisL, angle);
    }

    @Override
    protected final void onTouchTest(Model m, Collection<TouchInfo> list) {
        if (m == this) {
            return;
        }
        if (m instanceof Shape) {
            this.onShapeTouchTest((Shape)m, list);
        } else if (m.hasCollider()) {
            ((ModelGroup)m).getAllChildren().stream().forEach(c -> this.touchTest((Model)c, list));
        }
    }

    protected void onShapeTouchTest(Shape s, Collection<TouchInfo> list) {
        TouchTester.testShape(this, s, list);
    }

    public String toString() {
        return this.getClass().getName();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        if (this.vertexNormal) {
            Vector[] normal = new Vector[this.normalLocal.length - this.getFacesNum()];
            int i = 0;
            while (i < normal.length) {
                normal[i] = this.normalLocal[this.getFacesNum() + i];
                ++i;
            }
            s.writeObject(normal);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.vertex_global = new MutVector[this.vertex_local.length];
        int i = 0;
        while (i < this.vertex_global.length) {
            this.vertex_global[i] = new MutVector();
            ++i;
        }
        if (this.vertexNormal) {
            Vector[] normal = (Vector[])s.readObject();
            this.initFaces(this.getFacesNum(), normal);
        } else {
            this.initFaces();
        }
        this.color = new RGBAColor(this.red, this.green, this.blue, this.alpha);
    }
}

