/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.display.DrawData;
import net.comp_lot.glui.display.DualDrawData;
import net.comp_lot.glui.model.Model;
import net.comp_lot.glui.model.ModelOwner;
import net.comp_lot.glui.model.Shape;
import net.comp_lot.glui.model.utils.TouchInfo;

public class ModelGroup
extends Model {
    private static final long serialVersionUID = -7177989074727941005L;
    private List<Model> children = new ArrayList<Model>();
    private transient boolean fixed = false;
    private transient List<Shape> shapes;
    private transient int prevCnt;
    private transient int dataOffsetOp = -1;
    private transient int vertexSizeOp;
    private transient int indexSizeOp;
    private transient int dataOffsetTp = -1;
    private transient int vertexSizeTp;
    private transient int indexSizeTp;
    private transient boolean lazy;
    private transient boolean lazyUpdated;

    public ModelGroup() {
    }

    public ModelGroup(boolean isVisible) {
        super(isVisible);
    }

    public ModelGroup(boolean isVisible, boolean hasCollider) {
        super(isVisible, hasCollider);
    }

    public boolean removeModel(Model model) {
        return this.children.remove(model);
    }

    public void addModels(Model ... model) {
        Model[] modelArray = model;
        int n = model.length;
        int n2 = 0;
        while (n2 < n) {
            Model m = modelArray[n2];
            m.setParent(this);
            this.children.add(m);
            ++n2;
        }
    }

    public void clearChildren() {
        this.children.clear();
    }

    public List<Model> getAllChildren() {
        return this.children;
    }

    @Override
    public final void setOwnerRec(ModelOwner o) {
        this.setOwner(o);
        this.children.parallelStream().forEach(c -> c.setOwnerRec(o));
    }

    @Override
    public void fix() {
        this.callConfirmCoordinate();
        this.setBound();
        this.fixed = true;
        this.shapes = this.getShapes().filter(s -> s.isVisible()).collect(Collectors.toList());
    }

    private Stream<Shape> getShapes() {
        return this.children.stream().flatMap(c -> c instanceof Shape ? Stream.of((Shape)c) : ((ModelGroup)c).getShapes());
    }

    @Override
    public final void onConfirmCoordinate(boolean updated) {
        if (this.fixed) {
            return;
        }
        if (updated) {
            this.confirmGlobal();
        }
        if (this.isDecorative()) {
            this.lazy = true;
            this.lazyUpdated = this.lazyUpdated || updated;
        } else {
            this.children.parallelStream().forEach(m -> m.confirmCoordinate(updated));
        }
    }

    @Override
    public final boolean setBound() {
        if (this.fixed || this.isDecorative()) {
            return false;
        }
        boolean updated = this.children.parallelStream().map(m -> m.setBound()).reduce(false, (a, b) -> a != false || b != false);
        if (updated) {
            this.bound.reset();
            this.children.stream().filter(m -> !m.isDecorative() && (m.hasCollider() || m.isVisible())).forEach(m -> this.bound.addBound(m.getBound()));
            return true;
        }
        return false;
    }

    @Override
    public void resetBound() {
        if (this.fixed || this.isDecorative()) {
            return;
        }
        super.resetBound();
        this.children.stream().forEach(m -> m.resetBound());
    }

    @Override
    public void moveShapes(Vector v, double rate) {
        this.getAllChildren().stream().forEach(c -> c.moveShapes(v, rate));
    }

    @Override
    public void rotateShapes(Vector center, Vector axis, double angle) {
        this.getAllChildren().stream().forEach(c -> c.rotateShapes(center, axis, angle));
    }

    @Override
    public void putDrawData(DualDrawData data) {
        if (this.lazy) {
            this.children.parallelStream().forEach(m -> m.confirmCoordinate(this.lazyUpdated));
            this.lazy = false;
            this.lazyUpdated = false;
        }
        if (this.fixed) {
            DrawData dataOp = data.getOpaqueData();
            DrawData dataTp = data.getTransparentData();
            if (dataOp.getCnt() == ++this.prevCnt && this.dataOffsetOp == dataOp.getVertexNum() && this.dataOffsetTp == dataTp.getVertexNum()) {
                dataOp.skipVertex(this.vertexSizeOp);
                dataOp.skipIndex(this.indexSizeOp);
                dataTp.skipVertex(this.vertexSizeTp);
                dataTp.skipIndex(this.indexSizeTp);
            } else {
                this.dataOffsetOp = dataOp.getVertexNum();
                this.vertexSizeOp = -dataOp.getVertexNum();
                this.indexSizeOp = -dataOp.getIndexNum();
                this.dataOffsetTp = dataTp.getVertexNum();
                this.vertexSizeTp = -dataTp.getVertexNum();
                this.indexSizeTp = -dataTp.getIndexNum();
                this.shapes.stream().forEach(s -> s.putDrawData(data));
                this.vertexSizeOp += dataOp.getVertexNum();
                this.indexSizeOp += dataOp.getIndexNum();
                this.vertexSizeTp += dataTp.getVertexNum();
                this.indexSizeTp += dataTp.getIndexNum();
                this.prevCnt = dataOp.getCnt();
            }
        } else {
            this.children.stream().filter(m -> m.isVisible()).forEach(m -> m.putDrawData(data));
        }
    }

    @Override
    protected void onTouchTest(Model m, Collection<TouchInfo> list) {
        this.children.parallelStream().forEach(c -> c.touchTest(m, list));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append("[");
        sb.append(this.children.size());
        sb.append("]\n");
        this.children.stream().filter(c -> c instanceof ModelGroup).forEach(c -> {
            String cs = c.toString();
            String[] stringArray = cs.split("\\n");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                sb.append("\t");
                sb.append(line);
                sb.append("\n");
                ++n2;
            }
        });
        return sb.toString();
    }
}

