/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import net.comp_lot.glui.amount.Matrix;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.display.DualDrawData;
import net.comp_lot.glui.model.CoordinateSystem;
import net.comp_lot.glui.model.ModelGroup;
import net.comp_lot.glui.model.ModelOwner;
import net.comp_lot.glui.model.utils.Bound;
import net.comp_lot.glui.model.utils.TouchInfo;

public abstract class Model
implements Serializable {
    private static final long serialVersionUID = 1226074107955115034L;
    private static final AtomicInteger nextId = new AtomicInteger(0);
    private transient ModelOwner owner;
    public final int id;
    private final CoordinateSystem local;
    private final CoordinateSystem global;
    private int parentId = -1;
    private transient ModelGroup parent = null;
    protected transient Bound bound = new Bound();
    private boolean isVisible;
    private boolean isDecorative = false;
    private transient boolean hasCollider;
    private transient boolean updated = true;

    public Model() {
        this(true);
    }

    public Model(boolean isVisible) {
        this(isVisible, true);
    }

    public Model(boolean isVisible, boolean hasCollider) {
        this.id = nextId.getAndIncrement();
        this.isVisible = isVisible;
        this.hasCollider = hasCollider;
        this.local = new CoordinateSystem(this.id);
        this.global = new CoordinateSystem(this.id);
    }

    public void fix() {
    }

    public final void setOwner(ModelOwner o) {
        this.owner = o;
    }

    public void setOwnerRec(ModelOwner o) {
        this.setOwner(o);
    }

    public final ModelOwner getOwner() {
        if (this.owner != null || this.getParent() == null) {
            return this.owner;
        }
        return this.getParent().getOwner();
    }

    public final void callConfirmCoordinate() {
        this.confirmCoordinate(false);
    }

    protected final void confirmCoordinate(boolean updated) {
        this.onConfirmCoordinate(this.updated || updated);
        this.updated = false;
    }

    public abstract void onConfirmCoordinate(boolean var1);

    public abstract boolean setBound();

    public abstract void putDrawData(DualDrawData var1);

    public final CoordinateSystem getCoordinateSystem() {
        return this.local;
    }

    public final void setCoordinateSystem(CoordinateSystem c) {
        this.local.set(c);
        this.updated = true;
    }

    public final void moveL(Vector move) {
        this.moveL(move, 1.0);
    }

    public final void moveL(Vector move, double rate) {
        MutVector mp = new MutVector();
        this.LocalToParent(mp, move);
        this.local.move(mp, rate);
        this.updated = true;
    }

    public final void moveP(Vector move) {
        this.moveP(move, 1.0);
    }

    public final void moveP(Vector move, double rate) {
        this.local.move(move, rate);
        this.updated = true;
    }

    public final void moveToP(Vector v) {
        this.local.setCenter(v);
        this.updated = true;
    }

    public final void rotateL(Vector center, Vector axis, double angle) {
        MutVector pc = new MutVector();
        MutVector pv = new MutVector();
        this.LocalToParentCoord(pc, center);
        this.LocalToParent(pv, axis);
        this.rotateP(pc, pv, angle);
    }

    public final void rotateP(Vector center, Vector axis, double angle) {
        this.local.rotate(center, axis, angle);
        this.updated = true;
    }

    public final void rotateToP(Vector center, Vector axis, double angle) {
        this.setRotation(Vector.X_AXIS, Vector.Y_AXIS, Vector.Z_AXIS);
        this.rotateP(center, axis, angle);
    }

    public final void setRotation(Vector x_axis, Vector y_axis, Vector z_axis) {
        this.local.setAxis(x_axis, y_axis, z_axis);
        this.updated = true;
    }

    public final void setPosition(Vector pos) {
        this.local.setCenter(pos);
        this.updated = true;
    }

    public abstract void moveShapes(Vector var1, double var2);

    public abstract void rotateShapes(Vector var1, Vector var2, double var3);

    public final void setParent(ModelGroup parent) {
        if (this.parent == parent) {
            return;
        }
        this.parent = parent;
        this.parentId = parent != null ? parent.id : -1;
        this.updated = true;
    }

    public final ModelGroup getParent() {
        return this.parent;
    }

    public final int getParentId() {
        return this.parentId;
    }

    public final boolean isParent(Model p) {
        if (this == p) {
            return true;
        }
        if (this.getParent() != null) {
            return this.getParent().isParent(p);
        }
        return false;
    }

    protected final void confirmGlobal() {
        if (this.parent != null) {
            this.parent.global.LocalToParent(this.global, this.local);
        } else {
            CoordinateSystem.WORLD.LocalToParent(this.global, this.local);
        }
    }

    public final Matrix getRotationMatrix() {
        return this.global.getMatrix();
    }

    public final void LocalToGlobalCoord(MutVector dst, Vector src) {
        this.global.LocalToParentCoord(dst, src);
    }

    public final void LocalToGlobal(MutVector dst, Vector src) {
        this.global.LocalToParent(dst, src);
    }

    public final void GlobalToLocalCoord(MutVector dst, Vector src) {
        this.global.ParentToLocalCoord(dst, src);
    }

    public final void GlobalToLocal(MutVector dst, Vector src) {
        this.global.ParentToLocal(dst, src);
    }

    public final void LocalToParentCoord(MutVector dst, Vector src) {
        this.local.LocalToParentCoord(dst, src);
    }

    public final void LocalToParent(MutVector dst, Vector src) {
        this.local.LocalToParent(dst, src);
    }

    public void resetBound() {
        this.bound = new Bound();
    }

    public final Bound getBound() {
        return this.bound;
    }

    public Collection<TouchInfo> touchTest(Model m) {
        ConcurrentLinkedQueue<TouchInfo> rtn = new ConcurrentLinkedQueue<TouchInfo>();
        this.touchTest(m, rtn);
        return rtn;
    }

    public final void touchTest(Model m, Collection<TouchInfo> list) {
        if (this.hasCollider() && m.hasCollider() && this.getBound().crossing(m.getBound())) {
            this.onTouchTest(m, list);
        }
    }

    protected abstract void onTouchTest(Model var1, Collection<TouchInfo> var2);

    public boolean hasCollider() {
        return this.hasCollider;
    }

    public void setHasCollider(boolean hasCollider) {
        this.hasCollider = hasCollider;
        this.updated = true;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    public boolean isDecorative() {
        return this.isDecorative;
    }

    public void setDecorative(boolean isDecorative) {
        this.isDecorative = isDecorative;
    }

    public boolean equals(Object o) {
        if (o instanceof Model) {
            return ((Model)o).id == this.id;
        }
        return false;
    }
}

