/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.model;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import net.comp_lot.glui.amount.FastSerializable;
import net.comp_lot.glui.amount.Matrix;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;

public final class CoordinateSystem
implements Serializable,
FastSerializable {
    private static final long serialVersionUID = 1482002346225649687L;
    public static final CoordinateSystem WORLD = new CoordinateSystem(-1);
    private MutVector center = new MutVector().set(Vector.ZERO);
    private MutVector x_axis = new MutVector().set(Vector.X_AXIS);
    private MutVector y_axis = new MutVector().set(Vector.Y_AXIS);
    private transient MutVector z_axis = new MutVector().set(Vector.Z_AXIS);
    private transient int id;
    private transient boolean changed = false;
    private boolean identity = true;

    public CoordinateSystem(int id) {
        this.id = id;
    }

    public void cloneCopy(CoordinateSystem original) {
        this.id = original.id;
        this.set(original);
    }

    public void set(CoordinateSystem cs) {
        this.center.set(cs.center);
        this.x_axis.set(cs.x_axis);
        this.y_axis.set(cs.y_axis);
        this.z_axis.set(cs.z_axis);
        this.changed();
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public void setCenter(Vector center) {
        this.center.set(center);
        this.changed();
    }

    public Vector getCenter() {
        return this.center;
    }

    public void setAxis(Vector x_axis, Vector y_axis, Vector z_axis) {
        this.x_axis.set(x_axis);
        this.y_axis.set(y_axis);
        this.z_axis.set(z_axis);
        this.changed();
    }

    public void move(Vector move, double rate) {
        this.center.add(move, rate);
        this.changed();
    }

    public void rotate(Vector axis, double angle) {
        if (axis.getSize() != 1.0) {
            axis = new MutVector().set(axis).resize(1.0);
        }
        this.x_axis.rotate(axis, angle);
        this.y_axis.rotate(axis, angle);
        this.z_axis.rotate(axis, angle);
        this.changed();
    }

    public void rotate(Vector center, Vector axis, double angle) {
        if (axis.getSize() != 1.0) {
            axis = new MutVector().set(axis).resize(1.0);
        }
        this.center.rotate(center, axis, angle);
        this.rotate(axis, angle);
    }

    public void LocalToParentCoord(MutVector dst, Vector src) {
        this.LocalToParent(dst, src);
        dst.add(this.center);
    }

    public void LocalToParent(MutVector dst, Vector src) {
        double x = this.x_axis.getX() * src.getX() + this.y_axis.getX() * src.getY() + this.z_axis.getX() * src.getZ();
        double y = this.x_axis.getY() * src.getX() + this.y_axis.getY() * src.getY() + this.z_axis.getY() * src.getZ();
        double z = this.x_axis.getZ() * src.getX() + this.y_axis.getZ() * src.getY() + this.z_axis.getZ() * src.getZ();
        dst.set(x, y, z);
    }

    public void ParentToLocalCoord(MutVector dst, Vector src) {
        dst.set(src);
        dst.add(this.center, -1.0);
        this.ParentToLocal(dst, dst);
    }

    public void ParentToLocal(MutVector dst, Vector src) {
        double x = this.x_axis.getX() * src.getX() + this.x_axis.getY() * src.getY() + this.x_axis.getZ() * src.getZ();
        double y = this.y_axis.getX() * src.getX() + this.y_axis.getY() * src.getY() + this.y_axis.getZ() * src.getZ();
        double z = this.z_axis.getX() * src.getX() + this.z_axis.getY() * src.getY() + this.z_axis.getZ() * src.getZ();
        dst.set(x, y, z);
    }

    public void LocalToParent(CoordinateSystem dst, CoordinateSystem src) {
        if (this.identity) {
            dst.set(src);
            return;
        }
        if (src.identity) {
            dst.set(this);
            return;
        }
        this.LocalToParentCoord(dst.center, src.center);
        this.LocalToParent(dst.x_axis, src.x_axis);
        this.LocalToParent(dst.y_axis, src.y_axis);
        this.LocalToParent(dst.z_axis, src.z_axis);
        dst.changed();
    }

    private void changed() {
        this.changed = true;
        this.identity = false;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChangedToFalse() {
        this.changed = false;
    }

    public boolean serizalizedAsEquals(CoordinateSystem cs) {
        return this.id == cs.id && this.center.serializedAsEquals(cs.center) && this.getMatrix().toRotVec().serializedAsEquals(cs.getMatrix().toRotVec());
    }

    public boolean equalsAt(CoordinateSystem cs, double centerScale, double rotateScale) {
        return this.id == cs.id && this.center.equalsAt(cs.center, centerScale) && this.getMatrix().toRotVec().equalsAt(cs.getMatrix().toRotVec(), rotateScale);
    }

    public Matrix getMatrix() {
        return new Matrix(this.x_axis.getX(), this.y_axis.getX(), this.z_axis.getX(), this.x_axis.getY(), this.y_axis.getY(), this.z_axis.getY(), this.x_axis.getZ(), this.y_axis.getZ(), this.z_axis.getZ());
    }

    public boolean equals(Object o) {
        if (o instanceof CoordinateSystem) {
            CoordinateSystem cs = (CoordinateSystem)o;
            return this.id == cs.id;
        }
        return false;
    }

    @Override
    public void read(ObjectInputStream s) throws IOException {
        this.center.read(s);
        this.x_axis.read(s);
        Matrix m = this.x_axis.toRotMat();
        this.x_axis.set(m.fromRight(Vector.X_AXIS));
        this.y_axis.set(m.fromRight(Vector.Y_AXIS));
        this.z_axis.set(m.fromRight(Vector.Z_AXIS));
        this.changed();
    }

    @Override
    public void write(ObjectOutputStream s) throws IOException {
        this.center.write(s);
        this.getMatrix().toRotVec().write(s);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.z_axis = MutVector.Cross(this.x_axis, this.y_axis);
        this.changed();
    }
}

