/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.display_lwjgl;

import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import net.comp_lot.glui.display_lwjgl.GLDataUtil;
import org.lwjgl.opengl.GL33;

class Texture {
    private static final int[] UNIT_IDS = new int[]{33984, 33985, 33986, 33987, 33988, 33989, 33990, 33991};
    private final int num;
    private final int unitId;
    private final int textureId;
    private final int samplerId;

    public Texture(int num) {
        if (num < 0 || num >= UNIT_IDS.length) {
            throw new RuntimeException("Texture ID should 0 <= ID < 8, but ID is " + num);
        }
        this.num = num;
        this.unitId = UNIT_IDS[num];
        this.textureId = GL33.glGenTextures();
        this.samplerId = GL33.glGenSamplers();
    }

    public void setTexture(BufferedImage image, boolean antialias) {
        ByteBuffer img = GLDataUtil.imageToByte(image);
        GL33.glActiveTexture(this.unitId);
        GL33.glBindTexture(3553, this.textureId);
        GL33.glTexImage2D(3553, 0, 6408, image.getWidth(), image.getHeight(), 0, 6408, 5121, img);
        GL33.glGenerateMipmap(3553);
        if (antialias) {
            GL33.glSamplerParameteri(this.samplerId, 10241, 9987);
            GL33.glSamplerParameteri(this.samplerId, 10240, 9729);
        } else {
            GL33.glSamplerParameteri(this.samplerId, 10241, 9986);
            GL33.glSamplerParameteri(this.samplerId, 10240, 9728);
        }
        GL33.glBindTexture(3553, 0);
    }

    public void bind() {
        GL33.glActiveTexture(this.unitId);
        GL33.glBindTexture(3553, this.textureId);
        GL33.glBindSampler(this.num, this.samplerId);
    }

    public void unbind() {
        GL33.glActiveTexture(this.unitId);
        GL33.glBindTexture(3553, 0);
        GL33.glBindSampler(this.num, 0);
    }

    public void delete() {
        GL33.glDeleteSamplers(this.samplerId);
        GL33.glDeleteTextures(this.textureId);
    }
}

