/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.display_lwjgl;

import net.comp_lot.glui.display.DrawData;
import net.comp_lot.glui.display.VertexBufferObject;
import net.comp_lot.glui.display_lwjgl.ShaderProgram;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL30;

class ShaderVertexBufferObject {
    private int size = 1024;
    private final int vertexArrayID = GL30.glGenVertexArrays();
    private final int vertexBufferID;
    private final int normalBufferID;
    private final int texBufferID;
    private final int textureAreaBufferID;
    private final int textureUvBufferID;
    private final int colorBufferID;
    private final int indexBufferID;
    private int offset = 0;
    private VertexBufferObject vbo;

    public ShaderVertexBufferObject(ShaderProgram program) {
        GL30.glBindVertexArray(this.vertexArrayID);
        this.vertexBufferID = GL30.glGenBuffers();
        GL30.glBindBuffer(34962, this.vertexBufferID);
        GL30.glVertexAttribPointer(program.getAttribVertex(), 3, 5126, false, 0, 0L);
        this.normalBufferID = GL30.glGenBuffers();
        GL30.glBindBuffer(34962, this.normalBufferID);
        GL30.glVertexAttribPointer(program.getAttribNormal(), 3, 5126, false, 0, 0L);
        this.texBufferID = GL30.glGenBuffers();
        GL30.glBindBuffer(34962, this.texBufferID);
        GL30.glVertexAttribPointer(program.getAttribTextureSampler(), 1, 5126, false, 0, 0L);
        this.textureAreaBufferID = GL30.glGenBuffers();
        GL30.glBindBuffer(34962, this.textureAreaBufferID);
        GL30.glVertexAttribPointer(program.getAttribTextureArea(), 4, 5126, false, 0, 0L);
        this.textureUvBufferID = GL30.glGenBuffers();
        GL30.glBindBuffer(34962, this.textureUvBufferID);
        GL30.glVertexAttribPointer(program.getAttribTextureUv(), 2, 5126, false, 0, 0L);
        this.colorBufferID = GL30.glGenBuffers();
        GL30.glBindBuffer(34962, this.colorBufferID);
        GL30.glVertexAttribPointer(program.getAttribColor(), 4, 5126, false, 0, 0L);
        this.indexBufferID = GL30.glGenBuffers();
        GL30.glBindBuffer(34963, this.indexBufferID);
        GL30.glBindBuffer(34962, 0);
        GL30.glBindBuffer(34963, 0);
        GL30.glBindVertexArray(0);
        this.createBuffer();
    }

    private void createBuffer() {
        this.vbo = new VertexBufferObject(this.size, BufferUtils::createFloatBuffer, BufferUtils::createIntBuffer);
        GL30.glBindBuffer(34962, this.vertexBufferID);
        GL30.glBufferData(34962, this.vbo.getVertexBuffer(), 35048);
        GL30.glBindBuffer(34962, this.normalBufferID);
        GL30.glBufferData(34962, this.vbo.getNormalBuffer(), 35048);
        GL30.glBindBuffer(34962, this.texBufferID);
        GL30.glBufferData(34962, this.vbo.getTexBuffer(), 35048);
        GL30.glBindBuffer(34962, this.textureAreaBufferID);
        GL30.glBufferData(34962, this.vbo.getTextureAreaBuffer(), 35048);
        GL30.glBindBuffer(34962, this.textureUvBufferID);
        GL30.glBufferData(34962, this.vbo.getTextureUvBuffer(), 35048);
        GL30.glBindBuffer(34962, this.colorBufferID);
        GL30.glBufferData(34962, this.vbo.getColorBuffer(), 35048);
        GL30.glBindBuffer(34963, this.indexBufferID);
        GL30.glBufferData(34963, this.vbo.getIndexBuffer(), 35048);
        GL30.glBindBuffer(34962, 0);
        GL30.glBindBuffer(34963, 0);
    }

    public int getVArrayID() {
        return this.vertexArrayID;
    }

    public void delete() {
        GL30.glDeleteBuffers(this.vertexBufferID);
        GL30.glDeleteBuffers(this.normalBufferID);
        GL30.glDeleteBuffers(this.textureAreaBufferID);
        GL30.glDeleteBuffers(this.textureUvBufferID);
        GL30.glDeleteBuffers(this.colorBufferID);
        GL30.glDeleteBuffers(this.indexBufferID);
        GL30.glDeleteVertexArrays(this.vertexArrayID);
    }

    public void setBufferData(DrawData drawData) {
        if (this.size < this.offset + drawData.getSize()) {
            while (this.size < this.offset + drawData.getSize()) {
                this.size *= 2;
            }
            this.createBuffer();
        }
        drawData.putDrawData(this.vbo, this.offset);
        this.offset += drawData.getSize();
        GL30.glBindBuffer(34962, this.vertexBufferID);
        GL30.glBufferSubData(34962, (long)(this.vbo.getVertexBuffer().position() << 2), this.vbo.getVertexBuffer());
        GL30.glBindBuffer(34962, this.normalBufferID);
        GL30.glBufferSubData(34962, (long)(this.vbo.getNormalBuffer().position() << 2), this.vbo.getNormalBuffer());
        GL30.glBindBuffer(34962, this.texBufferID);
        GL30.glBufferSubData(34962, (long)(this.vbo.getTexBuffer().position() << 2), this.vbo.getTexBuffer());
        GL30.glBindBuffer(34962, this.textureAreaBufferID);
        GL30.glBufferSubData(34962, (long)(this.vbo.getTextureAreaBuffer().position() << 2), this.vbo.getTextureAreaBuffer());
        GL30.glBindBuffer(34962, this.textureUvBufferID);
        GL30.glBufferSubData(34962, (long)(this.vbo.getTextureUvBuffer().position() << 2), this.vbo.getTextureUvBuffer());
        GL30.glBindBuffer(34962, this.colorBufferID);
        GL30.glBufferSubData(34962, (long)(this.vbo.getColorBuffer().position() << 2), this.vbo.getColorBuffer());
        GL30.glBindBuffer(34962, 0);
        GL30.glBindBuffer(34963, this.indexBufferID);
        GL30.glBufferSubData(34963, (long)(this.vbo.getIndexBuffer().position() << 2), this.vbo.getIndexBuffer());
    }

    public void reset() {
        this.offset = 0;
    }
}

