/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.display_lwjgl;

import java.nio.IntBuffer;
import net.comp_lot.glui.system.utils.FileUtils;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL20;

class ShaderUtil {
    private static final String shaderVPath = "vertex_shader.vert";
    private static final String shaderFPath = "fragment_shader.frag";

    ShaderUtil() {
    }

    static int initShader() {
        return new ShaderUtil().makeProgram();
    }

    private int makeProgram() {
        int shaderV = this.createShader(shaderVPath, 35633);
        int shaderF = this.createShader(shaderFPath, 35632);
        int program = GL20.glCreateProgram();
        GL20.glAttachShader(program, shaderV);
        GL20.glAttachShader(program, shaderF);
        GL20.glDeleteShader(shaderV);
        GL20.glDeleteShader(shaderF);
        GL20.glLinkProgram(program);
        IntBuffer error = BufferUtils.createIntBuffer(1);
        GL20.glGetProgramiv(program, 35714, error);
        if (error.get(0) != 1) {
            System.out.println("ShaderProgram\u306e\u30ea\u30f3\u30af\u306b\u5931\u6557\u3057\u307e\u3057\u305f" + GL20.glGetProgramInfoLog(program));
            System.exit(1);
        }
        return program;
    }

    private int createShader(String path, int type) {
        int res = GL20.glCreateShader(type);
        String source = FileUtils.loadFromStream(this.getClass().getResourceAsStream(path));
        GL20.glShaderSource(res, (CharSequence)source);
        GL20.glCompileShader(res);
        IntBuffer error = BufferUtils.createIntBuffer(1);
        GL20.glGetShaderiv(res, 35713, error);
        if (error.get(0) != 1) {
            System.out.println(path + "\u306e\u30b3\u30f3\u30d1\u30a4\u30eb\u306b\u5931\u6557\u3057\u307e\u3057\u305f : " + GL20.glGetShaderInfoLog(res));
            System.exit(1);
        }
        return res;
    }
}

