/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.display_lwjgl;

import java.nio.FloatBuffer;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.display.DrawData;
import net.comp_lot.glui.display_lwjgl.ShaderUtil;
import net.comp_lot.glui.display_lwjgl.ShaderVertexBufferObject;
import org.joml.Matrix4f;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;

class ShaderProgram {
    private final int program;
    private final int attribVertex;
    private final int attribNormal;
    private final int attribTextureSampler;
    private final int attribTextureArea;
    private final int attribTextureUv;
    private final int attribColor;
    private final int uniformLightPosition;
    private final int uniformLighting;
    private final int uniformCameraPos;
    private final int uniformMatModelView;
    private final int uniformMatProjection;
    private final FloatBuffer matModelBuf = BufferUtils.createFloatBuffer(16);
    private final FloatBuffer matProjectionBuf = BufferUtils.createFloatBuffer(16);
    private final ShaderVertexBufferObject vbo;

    public ShaderProgram() {
        this.program = ShaderUtil.initShader();
        GL20.glUseProgram(this.program);
        this.attribVertex = GL20.glGetAttribLocation(this.program, "vertex");
        this.attribNormal = GL20.glGetAttribLocation(this.program, "normal");
        this.attribTextureSampler = GL20.glGetAttribLocation(this.program, "v_sampler");
        this.attribTextureArea = GL20.glGetAttribLocation(this.program, "v_tex_area");
        this.attribTextureUv = GL20.glGetAttribLocation(this.program, "v_tex_uv");
        this.attribColor = GL20.glGetAttribLocation(this.program, "v_color");
        this.uniformLightPosition = GL20.glGetUniformLocation(this.program, "Light.position");
        this.uniformLighting = GL20.glGetUniformLocation(this.program, "useLight");
        this.uniformCameraPos = GL20.glGetUniformLocation(this.program, "CameraPos");
        this.uniformMatModelView = GL20.glGetUniformLocation(this.program, "mat_modelview");
        this.uniformMatProjection = GL20.glGetUniformLocation(this.program, "mat_projection");
        GL20.glUniform1f(GL20.glGetUniformLocation(this.program, "texture_size"), 8192.0f);
        GL20.glUniform1i(GL20.glGetUniformLocation(this.program, "texSampler[0]"), 0);
        GL20.glUniform1i(GL20.glGetUniformLocation(this.program, "texSampler[1]"), 1);
        GL20.glUniform1i(GL20.glGetUniformLocation(this.program, "texSampler[2]"), 2);
        GL20.glUniform1f(GL20.glGetUniformLocation(this.program, "texture_unit_size[0]"), -1.0f);
        GL20.glUniform1f(GL20.glGetUniformLocation(this.program, "texture_unit_size[1]"), -1.0f);
        GL20.glUniform1f(GL20.glGetUniformLocation(this.program, "texture_unit_size[2]"), -1.0f);
        GL20.glUniform3f(GL20.glGetUniformLocation(this.program, "Light.color"), 1.0f, 1.0f, 1.0f);
        GL20.glUniform3f(GL20.glGetUniformLocation(this.program, "Light.intensity"), 5.0f, 5.0f, 5.0f);
        GL20.glUniform3f(GL20.glGetUniformLocation(this.program, "Mtl.rateAmbient"), 0.115f, 0.115f, 0.115f);
        GL20.glUniform3f(GL20.glGetUniformLocation(this.program, "Mtl.rateDiffuse"), 0.105f, 0.105f, 0.105f);
        GL20.glUniform3f(GL20.glGetUniformLocation(this.program, "Mtl.rateSpecular"), 0.05f, 0.05f, 0.05f);
        GL20.glUniform1f(GL20.glGetUniformLocation(this.program, "Mtl.Shininess"), 30.0f);
        GL20.glUseProgram(0);
        this.vbo = new ShaderVertexBufferObject(this);
    }

    public int getProgram() {
        return this.program;
    }

    public void setLightPosition(Vector pos) {
        GL20.glUniform3f(this.uniformLightPosition, (float)pos.getX(), (float)pos.getY(), (float)(-pos.getZ()));
    }

    public void setLighting(boolean lighting) {
        GL20.glUniform1i(this.uniformLighting, lighting ? 1 : 0);
    }

    public void setCameraPosition(Vector pos) {
        GL20.glUniform3f(this.uniformCameraPos, (float)pos.getX(), (float)pos.getY(), (float)(-pos.getZ()));
    }

    public void setProjection(Matrix4f model, Matrix4f projection) {
        GL20.glUniformMatrix4fv(this.uniformMatModelView, false, model.get(this.matModelBuf));
        GL20.glUniformMatrix4fv(this.uniformMatProjection, false, projection.get(this.matProjectionBuf));
    }

    public void enableVertexAttribArray() {
        GL30.glBindVertexArray(this.vbo.getVArrayID());
        GL20.glEnableVertexAttribArray(this.attribVertex);
        GL20.glEnableVertexAttribArray(this.attribNormal);
        GL20.glEnableVertexAttribArray(this.attribTextureSampler);
        GL20.glEnableVertexAttribArray(this.attribTextureArea);
        GL20.glEnableVertexAttribArray(this.attribTextureUv);
        GL20.glEnableVertexAttribArray(this.attribColor);
    }

    public void disableVertexAttribArray() {
        GL20.glDisableVertexAttribArray(this.attribVertex);
        GL20.glDisableVertexAttribArray(this.attribNormal);
        GL20.glDisableVertexAttribArray(this.attribTextureSampler);
        GL20.glDisableVertexAttribArray(this.attribTextureArea);
        GL20.glDisableVertexAttribArray(this.attribTextureUv);
        GL20.glDisableVertexAttribArray(this.attribColor);
        GL30.glBindVertexArray(0);
    }

    public void setBufferData(DrawData drawData) {
        this.vbo.setBufferData(drawData);
    }

    public void delete() {
        this.vbo.delete();
        GL20.glDeleteProgram(this.program);
    }

    public int getAttribVertex() {
        return this.attribVertex;
    }

    public int getAttribNormal() {
        return this.attribNormal;
    }

    public int getAttribTextureSampler() {
        return this.attribTextureSampler;
    }

    public int getAttribTextureArea() {
        return this.attribTextureArea;
    }

    public int getAttribTextureUv() {
        return this.attribTextureUv;
    }

    public int getAttribColor() {
        return this.attribColor;
    }

    public void setTextureUnitSize(int sampler, int size) {
        GL20.glUseProgram(this.program);
        GL20.glUniform1f(GL20.glGetUniformLocation(this.program, String.format("texture_unit_size[%d]", sampler)), size);
        GL20.glUseProgram(0);
    }

    public void reset() {
        this.vbo.reset();
    }
}

