/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.display_lwjgl;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import net.comp_lot.glui.display.DrawData;
import net.comp_lot.glui.display_lwjgl.GLGameDisplay;
import net.comp_lot.glui.display_lwjgl.ShaderProgram;
import net.comp_lot.glui.display_lwjgl.Texture;
import org.joml.Matrix4f;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL32;

class GLRenderer {
    private final GLGameDisplay display;
    private final Texture[] textures;
    private final ShaderProgram program;
    private final Matrix4f matModel2d = new Matrix4f();
    private Matrix4f matProjection2d;
    private Matrix4f matProjection3d;
    private float minDistance = 0.1f;
    private float maxDistance = 5000.0f;

    public GLRenderer(BufferedImage texture, GLGameDisplay display) {
        this.display = display;
        GL.createCapabilities();
        this.initRender();
        this.textures = new Texture[8];
        this.setTexture(0, texture, false);
        this.setTexture(1, texture, true);
        this.program = new ShaderProgram();
    }

    private void initRender() {
        GL32.glEnable(32925);
        GL32.glEnable(3042);
        GL32.glBlendFunc(770, 771);
        GL32.glEnable(2884);
        GL32.glClearColor(0.3f, 0.3f, 0.5f, 0.0f);
    }

    public void setTexture(int num, BufferedImage texture, boolean antialias) {
        if (texture == null) {
            texture = new BufferedImage(1, 1, 2);
        }
        int maxSize = GL32.glGetInteger(3379);
        if (texture.getWidth() > maxSize) {
            System.err.println("GL_MAX_TEXTURE_SIZE = " + maxSize + " < " + texture.getWidth());
            Image scaled = texture.getScaledInstance(maxSize, maxSize, 4);
            texture = new BufferedImage(maxSize, maxSize, 2);
            Graphics2D g = texture.createGraphics();
            g.drawImage(scaled, 0, 0, null);
        }
        if (this.textures[num] == null) {
            this.textures[num] = new Texture(num);
        }
        this.textures[num].setTexture(texture, antialias);
    }

    public void setClearColor(int rgba) {
        float r = (float)(rgba >> 24 & 0xFF) / 255.0f;
        float g = (float)(rgba >> 16 & 0xFF) / 255.0f;
        float b = (float)(rgba >> 8 & 0xFF) / 255.0f;
        float a = (float)(rgba & 0xFF) / 255.0f;
        GL32.glClearColor(r, g, b, a);
    }

    public void render() {
        GL32.glClear(16640);
        this.program.reset();
        GL32.glEnable(2929);
        this.display(true);
        GL32.glDisable(2929);
        this.display(false);
    }

    private void display(boolean mode3d) {
        Texture texture;
        GL32.glUseProgram(this.program.getProgram());
        Texture[] textureArray = this.textures;
        int n = this.textures.length;
        int n2 = 0;
        while (n2 < n) {
            texture = textureArray[n2];
            if (texture != null) {
                texture.bind();
            }
            ++n2;
        }
        this.program.enableVertexAttribArray();
        if (mode3d) {
            this.program.setLightPosition(this.display.getLightPos());
            this.program.setCameraPosition(this.display.getCameraPos());
            this.program.setProjection(this.display.getModelView(), this.matProjection3d);
        } else {
            this.program.setProjection(this.matModel2d, this.matProjection2d);
        }
        this.program.setLighting(mode3d);
        this.drawElements(mode3d, true);
        this.drawElements(mode3d, false);
        this.program.disableVertexAttribArray();
        textureArray = this.textures;
        n = this.textures.length;
        n2 = 0;
        while (n2 < n) {
            texture = textureArray[n2];
            if (texture != null) {
                texture.unbind();
            }
            ++n2;
        }
        GL32.glUseProgram(0);
    }

    private void drawElements(boolean mode3d, boolean opaque) {
        DrawData drawData = this.display.getDrawData(mode3d, opaque);
        this.program.setBufferData(drawData);
        GL32.glDrawElementsBaseVertex(4, drawData.getIndexNum(), 5125, drawData.getVboOffset() << 2, drawData.getVboOffset());
        GL32.glBindBuffer(34963, 0);
    }

    public void sizeChanged(int width, int height) {
        GL32.glViewport(0, 0, width, height);
        this.matProjection3d = new Matrix4f().perspective(1.16f, (float)width / (float)height, this.minDistance, this.maxDistance);
        this.matProjection2d = new Matrix4f(2.0f / (float)width, 0.0f, 0.0f, 0.0f, 0.0f, 2.0f / (float)height, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void setDrawDistance(float minDistance, float maxDistance) {
        this.minDistance = minDistance;
        this.maxDistance = maxDistance;
    }

    public void delete() {
        this.program.delete();
        Texture[] textureArray = this.textures;
        int n = this.textures.length;
        int n2 = 0;
        while (n2 < n) {
            Texture texture = textureArray[n2];
            if (texture != null) {
                texture.delete();
            }
            ++n2;
        }
    }

    public void setTextureUnitSize(int sampler, int size) {
        this.program.setTextureUnitSize(sampler, size);
    }

    byte[] getImage(int width, int height) {
        ByteBuffer buf = BufferUtils.createByteBuffer(width * height * 3);
        GL32.glReadBuffer(1028);
        GL32.glReadPixels(0, 0, width, height, 32992, 5121, buf);
        byte[] array = new byte[width * height * 3];
        buf.get(array);
        byte[] rev = new byte[width * height * 3];
        int x = 0;
        while (x < width) {
            int y = 0;
            while (y < height) {
                rev[(y * width + x) * 3] = array[((height - y - 1) * width + x) * 3];
                rev[(y * width + x) * 3 + 1] = array[((height - y - 1) * width + x) * 3 + 1];
                rev[(y * width + x) * 3 + 2] = array[((height - y - 1) * width + x) * 3 + 2];
                ++y;
            }
            ++x;
        }
        return rev;
    }
}

