/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.display_lwjgl;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.DoubleBuffer;
import java.util.function.Function;
import javax.imageio.ImageIO;
import net.comp_lot.glui.display_lwjgl.GLDataUtil;
import net.comp_lot.glui.display_lwjgl.GLGameDisplay;
import net.comp_lot.glui.display_lwjgl.GLRenderer;
import net.comp_lot.glui.sound.AudioSystem;
import net.comp_lot.glui.system.Game;
import net.comp_lot.glui.system.GameMode;
import net.comp_lot.glui.system.GluiConfig;
import org.lwjgl.BufferUtils;
import org.lwjgl.glfw.Callbacks;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.system.Configuration;

public class GLMain {
    public static boolean shouldExit = false;
    private final long window;
    private final GLRenderer renderer;
    private final GLGameDisplay display;
    private int width;
    private int height;
    private DoubleBuffer mouseX = BufferUtils.createDoubleBuffer(1);
    private DoubleBuffer mouseY = BufferUtils.createDoubleBuffer(1);
    private long[] cursor;

    public GLMain(GluiConfig config, String title, BufferedImage icon, BufferedImage texture, AudioSystem audioSystem) {
        this.window = this.initWindow(title, icon);
        this.display = new GLGameDisplay(config, this, audioSystem);
        this.renderer = new GLRenderer(texture, this.display);
        this.initCallback();
        this.setCursor(0);
        GLFW.glfwShowWindow(this.window);
    }

    public void run(Function<Game, GameMode> modeFactory) {
        this.display.setMode(modeFactory);
        while (!GLFW.glfwWindowShouldClose(this.window) && !shouldExit) {
            GLFW.glfwPollEvents();
            this.getMousePos();
            this.display.frame();
            this.renderer.render();
            GLFW.glfwSwapBuffers(this.window);
        }
        this.finish();
    }

    private long initWindow(String title, BufferedImage icon) {
        Configuration.DEBUG.set(true);
        if (!GLFW.glfwInit()) {
            throw new IllegalStateException("Not enable GLFW Init");
        }
        GLFW.glfwDefaultWindowHints();
        GLFW.glfwWindowHint(139266, 3);
        GLFW.glfwWindowHint(139267, 2);
        GLFW.glfwWindowHint(131076, 0);
        GLFW.glfwWindowHint(135181, 4);
        GLFW.glfwWindowHint(131075, 1);
        GLFW.glfwWindowHint(131080, 1);
        GLFWVidMode vidmode = GLFW.glfwGetVideoMode(GLFW.glfwGetPrimaryMonitor());
        this.width = vidmode.width() / 2;
        this.height = vidmode.height() / 2;
        long window = GLFW.glfwCreateWindow(this.width, this.height, title, 0L, 0L);
        if (window == 0L) {
            throw new RuntimeException("\u30a6\u30a3\u30f3\u30c9\u30a6\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
        }
        if (icon != null) {
            this.setWindowIcon(window, icon);
        }
        try {
            this.cursor = new long[]{GLDataUtil.makeCursor(ImageIO.read(this.getClass().getResourceAsStream("/glui/cursor.png")), 0, 0), GLDataUtil.makeCursor(ImageIO.read(this.getClass().getResourceAsStream("/glui/cursor_hand.png")), 8, 0), GLDataUtil.makeCursor(ImageIO.read(this.getClass().getResourceAsStream("/glui/cursor_scroll.png")), 8, 0), GLDataUtil.makeCursor(ImageIO.read(this.getClass().getResourceAsStream("/glui/cursor_text.png")), 2, 12)};
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        GLFW.glfwMakeContextCurrent(window);
        GLFW.glfwSwapInterval(1);
        return window;
    }

    private void setWindowIcon(long window, BufferedImage iconImage) {
        GLFWImage icon = GLFWImage.create();
        icon.set(iconImage.getWidth(), iconImage.getHeight(), GLDataUtil.imageToByte(iconImage));
        GLFWImage.Buffer imagebf = GLFWImage.malloc(1);
        imagebf.put(0, icon);
        GLFW.glfwSetWindowIcon(window, imagebf);
    }

    void setCursor(int num) {
        GLFW.glfwSetCursor(this.window, this.cursor[num]);
    }

    void showPointer(boolean enable) {
        GLFW.glfwSetInputMode(this.window, 208897, enable ? 212993 : 212995);
    }

    void setTexture(int num, BufferedImage texture, boolean antialias) {
        this.renderer.setTexture(num, texture, antialias);
    }

    void setTextureUnitSize(int sampler, int size) {
        this.renderer.setTextureUnitSize(sampler, size);
    }

    void setClearColor(int rgba) {
        this.renderer.setClearColor(rgba);
    }

    private void getMousePos() {
        GLFW.glfwGetCursorPos(this.window, this.mouseX, this.mouseY);
        this.display.mouseMove((float)this.mouseX.get(0), (float)this.mouseY.get(0));
    }

    private void initCallback() {
        GLFW.glfwGetCursorPos(this.window, this.mouseX, this.mouseY);
        int[] w = new int[1];
        int[] h = new int[1];
        GLFW.glfwGetWindowSize(this.window, w, h);
        this.sizeChanged(w[0], h[0]);
        GLFW.glfwSetWindowSizeCallback(this.window, (window, width, height) -> this.sizeChanged(width, height));
        GLFW.glfwSetKeyCallback(this.window, (window, key, scancode, action, mods) -> this.display.keyEvent(key, action));
        GLFW.glfwSetCharCallback(this.window, (window, unicode) -> this.display.charEvent(unicode));
        GLFW.glfwSetScrollCallback(this.window, (window, x, y) -> this.display.mouseScroll(y));
        GLFW.glfwSetMouseButtonCallback(this.window, (window, button, action, modifier) -> {
            GLFW.glfwGetCursorPos(window, this.mouseX, this.mouseY);
            this.display.mouseAction(button, action, (int)this.mouseX.get(0), (int)this.mouseY.get(0));
        });
    }

    private void sizeChanged(int width, int height) {
        this.width = width;
        this.height = height;
        this.renderer.sizeChanged(width, height);
        this.display.sizeChanged(width, height);
    }

    void setDrawDistance(float minDistance, float maxDistance) {
        this.renderer.setDrawDistance(minDistance, maxDistance);
        this.renderer.sizeChanged(this.width, this.height);
    }

    byte[] getImage() {
        return this.renderer.getImage(this.width, this.height);
    }

    private void finish() {
        this.renderer.delete();
        Callbacks.glfwFreeCallbacks(this.window);
        GLFW.glfwDestroyWindow(this.window);
        GLFW.glfwTerminate();
    }
}

