/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.display_lwjgl;

import java.awt.image.BufferedImage;
import java.util.function.Function;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.display.DrawData;
import net.comp_lot.glui.display.DualDrawData;
import net.comp_lot.glui.display_lwjgl.GLMain;
import net.comp_lot.glui.sound.AudioSystem;
import net.comp_lot.glui.system.Game;
import net.comp_lot.glui.system.GameMode;
import net.comp_lot.glui.system.GluiConfig;
import net.comp_lot.glui.system.OperationEvent;
import org.joml.Matrix4f;

public final class GLGameDisplay {
    private final GLMain main;
    private final Matrix4f matModelView = new Matrix4f();
    private final Game game;
    private final DualDrawData mainDrawData = new DualDrawData();
    private final DualDrawData uiDrawData = new DualDrawData();
    private final MutVector cameraPos = new MutVector();
    private final MutVector lookPos = new MutVector();
    private final Vector lightRelative = new MutVector().set(1000.0, 8000.0, -4000.0);
    private final MutVector light = new MutVector().set(this.lightRelative);

    GLGameDisplay(GluiConfig config, GLMain main, AudioSystem audioSystem) {
        this.matModelView.scale(25.0f);
        this.main = main;
        this.game = new Game(config, this, audioSystem);
    }

    void frame() {
        this.game.frame();
    }

    public byte[] getImage() {
        return this.main.getImage();
    }

    public void resetDrawData() {
        this.mainDrawData.reset();
        this.uiDrawData.reset();
    }

    public DualDrawData getMainDrawData() {
        return this.mainDrawData;
    }

    public DualDrawData getUIDrawData() {
        return this.uiDrawData;
    }

    DrawData getDrawData(boolean is3d, boolean isOpaque) {
        DualDrawData dualDrawData = is3d ? this.mainDrawData : this.uiDrawData;
        return isOpaque ? dualDrawData.getOpaqueData() : dualDrawData.getTransparentData();
    }

    public void setMainCamera(Vector pos, Vector axis, Vector up) {
        this.cameraPos.set(pos);
        this.lookPos.set(pos);
        this.lookPos.add(axis, 100.0);
        this.light.set(pos);
        this.light.add(this.lightRelative);
        this.matModelView.setLookAt((float)pos.getX(), (float)pos.getY(), (float)(-pos.getZ()), (float)this.lookPos.getX(), (float)this.lookPos.getY(), (float)(-this.lookPos.getZ()), (float)up.getX(), (float)up.getY(), (float)(-up.getZ()));
    }

    Vector getLightPos() {
        return this.light;
    }

    Matrix4f getModelView() {
        return this.matModelView;
    }

    Vector getCameraPos() {
        return this.cameraPos;
    }

    public void setDrawDistance(float minDistance, float maxDistance) {
        this.main.setDrawDistance(minDistance, maxDistance);
    }

    public void showPointer(boolean enable) {
        this.main.showPointer(enable);
    }

    public void setCursor(int num) {
        this.main.setCursor(num);
    }

    public void setTexture(int num, BufferedImage texture, boolean antialias) {
        this.main.setTexture(num, texture, antialias);
    }

    public void setTextureUnitSize(int sampler, int size) {
        this.main.setTextureUnitSize(sampler, size);
    }

    public void setClearColor(int rgba) {
        this.main.setClearColor(rgba);
    }

    void sizeChanged(int width, int height) {
        this.game.sizeChanged(width, height);
    }

    void mouseMove(float x, float y) {
        this.game.mouseMove(x, y);
    }

    void keyEvent(int key, int action) {
        if (action == 1 || action == 2) {
            this.game.keyEvent(true, key);
        } else if (action == 0) {
            this.game.keyEvent(false, key);
        }
    }

    void charEvent(int unicode) {
        this.game.charEvent(unicode);
    }

    void mouseScroll(double size) {
        this.game.mouseScroll(size);
    }

    void mouseAction(int button, int action, int mouseX, int mouseY) {
        if (action == 1) {
            this.game.mouseAction(button, OperationEvent.Action.PRESS, mouseX, mouseY);
        } else if (action == 0) {
            this.game.mouseAction(button, OperationEvent.Action.RELEASE, mouseX, mouseY);
        }
    }

    void setMode(Function<Game, GameMode> modeFactory) {
        this.game.setMode(modeFactory);
    }
}

