/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.display_lwjgl;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWImage;

public class GLDataUtil {
    public static ByteBuffer imageToByte(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        ByteBuffer img = BufferUtils.createByteBuffer(width * height * 4);
        int[] rgb = image.getType() == 2 ? ((DataBufferInt)image.getRaster().getDataBuffer()).getData() : image.getRGB(0, 0, width, height, null, 0, width);
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int argb = rgb[y * width + x];
                img.put((byte)(argb >> 16 & 0xFF));
                img.put((byte)(argb >> 8 & 0xFF));
                img.put((byte)(argb >> 0 & 0xFF));
                img.put((byte)(argb >> 24 & 0xFF));
                ++x;
            }
            ++y;
        }
        img.clear();
        return img;
    }

    public static BufferedImage byteToImage(byte[] buf, int width, int height) {
        BufferedImage img = new BufferedImage(width, height, 5);
        byte[] byteArray = ((DataBufferByte)img.getRaster().getDataBuffer()).getData();
        System.arraycopy(buf, 0, byteArray, 0, buf.length);
        int size = Math.min(img.getWidth(), img.getHeight());
        img = img.getSubimage((width - size) / 2, (height - size) / 2, size, size);
        return img;
    }

    public static long makeCursor(BufferedImage img, int xhot, int yhot) {
        GLFWImage glfwImage = GLFWImage.create();
        glfwImage.set(img.getWidth(), img.getHeight(), GLDataUtil.imageToByte(img));
        long cursor = GLFW.glfwCreateCursor(glfwImage, xhot, yhot);
        if (cursor == 0L) {
            throw new RuntimeException("Error creating cursor");
        }
        return cursor;
    }
}

