/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.display;

import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.function.Function;

public final class VertexBufferObject {
    private final FloatBuffer vertexBuffer;
    private final FloatBuffer normalBuffer;
    private final FloatBuffer texBuffer;
    private final FloatBuffer textureAreaBuffer;
    private final FloatBuffer textureUvBuffer;
    private final FloatBuffer colorBuffer;
    private final IntBuffer indexBuffer;

    public VertexBufferObject(int indexSize, Function<Integer, FloatBuffer> fbFactory, Function<Integer, IntBuffer> ibFactory) {
        this.vertexBuffer = fbFactory.apply(indexSize * 3);
        this.normalBuffer = fbFactory.apply(indexSize * 3);
        this.texBuffer = fbFactory.apply(indexSize);
        this.textureAreaBuffer = fbFactory.apply(indexSize * 4);
        this.textureUvBuffer = fbFactory.apply(indexSize * 2);
        this.colorBuffer = fbFactory.apply(indexSize * 4);
        this.indexBuffer = ibFactory.apply(indexSize);
    }

    public FloatBuffer getVertexBuffer() {
        return this.vertexBuffer;
    }

    public FloatBuffer getNormalBuffer() {
        return this.normalBuffer;
    }

    public FloatBuffer getTexBuffer() {
        return this.texBuffer;
    }

    public FloatBuffer getTextureAreaBuffer() {
        return this.textureAreaBuffer;
    }

    public FloatBuffer getTextureUvBuffer() {
        return this.textureUvBuffer;
    }

    public FloatBuffer getColorBuffer() {
        return this.colorBuffer;
    }

    public IntBuffer getIndexBuffer() {
        return this.indexBuffer;
    }
}

