/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.display;

import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import net.comp_lot.glui.amount.RGBAColor;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.display.VertexBufferObject;

public class DrawData {
    private int cnt = 0;
    private int size = 1024;
    private float[] vertex;
    private float[] normal;
    private float[] tex;
    private float[] textureArea;
    private float[] textureUv;
    private float[] color;
    private int[] index;
    private VertexBufferObject vbo;
    private int vboOffset = -1;
    private int vertexNum;
    private int indexNum;
    private int firstVertex;
    private int firstUpdatedVertex;
    private int firstUpdatedIndex;

    DrawData() {
        this.makeArrays();
    }

    private void makeArrays() {
        float[] vertex = new float[this.size * 3];
        float[] normal = new float[this.size * 3];
        float[] tex = new float[this.size];
        float[] textureArea = new float[this.size * 4];
        float[] textureUv = new float[this.size * 2];
        float[] color = new float[this.size * 4];
        int[] index = new int[this.size];
        if (this.vertexNum > 0) {
            System.arraycopy(this.vertex, 0, vertex, 0, this.vertexNum * 3);
            System.arraycopy(this.normal, 0, normal, 0, this.vertexNum * 3);
            System.arraycopy(this.tex, 0, tex, 0, this.vertexNum);
            System.arraycopy(this.textureArea, 0, textureArea, 0, this.vertexNum * 4);
            System.arraycopy(this.textureUv, 0, textureUv, 0, this.vertexNum * 2);
            System.arraycopy(this.color, 0, color, 0, this.vertexNum * 4);
        }
        if (this.indexNum > 0) {
            System.arraycopy(this.index, 0, index, 0, this.indexNum);
        }
        this.vertex = vertex;
        this.normal = normal;
        this.tex = tex;
        this.textureArea = textureArea;
        this.textureUv = textureUv;
        this.color = color;
        this.index = index;
    }

    public int getSize() {
        return this.size;
    }

    void reset() {
        this.vertexNum = 0;
        this.indexNum = 0;
        this.firstVertex = 0;
        this.firstUpdatedVertex = -1;
        this.firstUpdatedIndex = -1;
        ++this.cnt;
    }

    public int getCnt() {
        return this.cnt;
    }

    public int getVboOffset() {
        return this.vboOffset;
    }

    public void setVertexFirst() {
        this.firstVertex = this.vertexNum;
        if (this.firstUpdatedVertex < 0) {
            this.firstUpdatedVertex = this.vertexNum;
            this.firstUpdatedIndex = this.indexNum;
        }
    }

    public void addTriangle(int i1, int i2, int i3, Vector n1, Vector n2, Vector n3) {
        if (this.indexNum + 3 > this.size) {
            this.size *= 2;
            this.makeArrays();
        }
        this.setNormal(i1 += this.firstVertex, n1);
        this.setNormal(i2 += this.firstVertex, n2);
        this.setNormal(i3 += this.firstVertex, n3);
        this.index[this.indexNum] = i1;
        this.index[this.indexNum + 1] = i2;
        this.index[this.indexNum + 2] = i3;
        this.indexNum += 3;
    }

    public void setTriangleMaterial(int i1, int i2, int i3, int tex, float texX, float texY, float texW, float texH, boolean first, RGBAColor color) {
        this.setTexture(i1 += this.firstVertex, tex, texX, texY, texW, texH, !first ? 1 : 0, !first ? 1 : 0);
        this.setTexture(i2 += this.firstVertex, tex, texX, texY, texW, texH, !first ? 1 : 0, first ? 1 : 0);
        this.setTexture(i3 += this.firstVertex, tex, texX, texY, texW, texH, first ? 1 : 0, first ? 1 : 0);
        this.setColor(i1, color);
        this.setColor(i2, color);
        this.setColor(i3, color);
    }

    private void setNormal(int base, Vector vNormal) {
        this.normal[base * 3] = (float)vNormal.getX();
        this.normal[base * 3 + 1] = (float)vNormal.getY();
        this.normal[base * 3 + 2] = (float)(-vNormal.getZ());
    }

    private void setTexture(int base, int tex, float texX, float texY, float texW, float texH, float u, float v) {
        this.tex[base] = tex;
        this.textureArea[base * 4] = texX;
        this.textureArea[base * 4 + 1] = texY;
        this.textureArea[base * 4 + 2] = texW;
        this.textureArea[base * 4 + 3] = texH;
        this.textureUv[base * 2] = u;
        this.textureUv[base * 2 + 1] = v;
    }

    private void setColor(int base, RGBAColor c) {
        this.color[base * 4] = c.getRed();
        this.color[base * 4 + 1] = c.getGreen();
        this.color[base * 4 + 2] = c.getBlue();
        this.color[base * 4 + 3] = c.getAlpha();
    }

    public void skipIndex(int num) {
        this.indexNum += num;
    }

    public void addVertex(Vector vertex) {
        if (this.vertexNum + 1 > this.size) {
            this.size *= 2;
            this.makeArrays();
        }
        this.vertex[this.vertexNum * 3] = (float)vertex.getX();
        this.vertex[this.vertexNum * 3 + 1] = (float)vertex.getY();
        this.vertex[this.vertexNum * 3 + 2] = (float)(-vertex.getZ());
        ++this.vertexNum;
    }

    public void skipVertex(int num) {
        this.vertexNum += num;
    }

    public int getIndexNum() {
        return this.indexNum;
    }

    public int getVertexNum() {
        return this.vertexNum;
    }

    public void putDrawData(VertexBufferObject buffer, int offset) {
        if (this.vbo != buffer || this.vboOffset != offset) {
            this.vbo = buffer;
            this.vboOffset = offset;
            this.firstUpdatedVertex = 0;
            this.firstUpdatedIndex = 0;
        }
        this.setFloatBuffer(buffer.getVertexBuffer(), this.vertex, this.vertexNum, 3, this.firstUpdatedVertex);
        this.setFloatBuffer(buffer.getNormalBuffer(), this.normal, this.vertexNum, 3, this.firstUpdatedVertex);
        this.setFloatBuffer(buffer.getTexBuffer(), this.tex, this.vertexNum, 1, this.firstUpdatedVertex);
        this.setFloatBuffer(buffer.getTextureAreaBuffer(), this.textureArea, this.vertexNum, 4, this.firstUpdatedVertex);
        this.setFloatBuffer(buffer.getTextureUvBuffer(), this.textureUv, this.vertexNum, 2, this.firstUpdatedVertex);
        this.setFloatBuffer(buffer.getColorBuffer(), this.color, this.vertexNum, 4, this.firstUpdatedVertex);
        this.setIntBuffer(buffer.getIndexBuffer(), this.index, this.indexNum, 1, this.firstUpdatedIndex);
    }

    private void setFloatBuffer(FloatBuffer buffer, float[] data, int dataNum, int dataSize, int firstIndex) {
        buffer.clear();
        if (firstIndex >= 0) {
            buffer.position((this.vboOffset + firstIndex) * dataSize);
            buffer.put(data, firstIndex * dataSize, (dataNum - firstIndex) * dataSize);
            buffer.flip();
            buffer.position((this.vboOffset + firstIndex) * dataSize);
        } else {
            buffer.position((this.vboOffset + dataNum) * dataSize);
            buffer.flip();
            buffer.position((this.vboOffset + dataNum) * dataSize);
        }
    }

    private void setIntBuffer(IntBuffer buffer, int[] data, int dataNum, int dataSize, int firstIndex) {
        buffer.clear();
        if (firstIndex >= 0) {
            buffer.position((this.vboOffset + firstIndex) * dataSize);
            buffer.put(data, firstIndex * dataSize, (dataNum - firstIndex) * dataSize);
            buffer.flip();
            buffer.position((this.vboOffset + firstIndex) * dataSize);
        } else {
            buffer.position((this.vboOffset + dataNum) * dataSize);
            buffer.flip();
            buffer.position((this.vboOffset + dataNum) * dataSize);
        }
    }
}

