/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.camera;

import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.camera.Camera;
import net.comp_lot.glui.system.GameMode;
import net.comp_lot.glui.system.OperationEvent;

public class FlyingCamera
extends Camera {
    private final GameMode mode;
    private final float speed;
    private final MutVector camera = new MutVector().set(0.0, 10.0, -15.0);
    private final MutVector moveAxisFront = new MutVector().set(0.0, 0.0, 1.0);
    private final MutVector moveAxisSide = new MutVector().set(1.0, 0.0, 0.0);
    private OperationEvent.KeyCode keyForward = OperationEvent.KeyCode.KEY_W;
    private OperationEvent.KeyCode keyBackward = OperationEvent.KeyCode.KEY_S;
    private OperationEvent.KeyCode keyLeft = OperationEvent.KeyCode.KEY_A;
    private OperationEvent.KeyCode keyRight = OperationEvent.KeyCode.KEY_D;
    private OperationEvent.KeyCode keyUp = OperationEvent.KeyCode.KEY_SPACE;
    private OperationEvent.KeyCode keyDown = OperationEvent.KeyCode.KEY_LEFT_SHIFT;

    public FlyingCamera(GameMode mode, float speed) {
        this.mode = mode;
        this.speed = speed;
    }

    public void setKey(OperationEvent.KeyCode keyForward, OperationEvent.KeyCode keyBackward, OperationEvent.KeyCode keyLeft, OperationEvent.KeyCode keyRight, OperationEvent.KeyCode keyUp, OperationEvent.KeyCode keyDown) {
        this.keyForward = keyForward;
        this.keyBackward = keyBackward;
        this.keyLeft = keyLeft;
        this.keyRight = keyRight;
        this.keyUp = keyUp;
        this.keyDown = keyDown;
    }

    public MutVector getCamera() {
        return this.camera;
    }

    public void onFrame() {
        if (this.mode.getKeyState(this.keyForward)) {
            this.camera.add(this.moveAxisFront, this.speed);
        }
        if (this.mode.getKeyState(this.keyBackward)) {
            this.camera.add(this.moveAxisFront, -this.speed);
        }
        if (this.mode.getKeyState(this.keyLeft)) {
            this.camera.add(this.moveAxisSide, -this.speed);
        }
        if (this.mode.getKeyState(this.keyRight)) {
            this.camera.add(this.moveAxisSide, this.speed);
        }
        if (this.mode.getKeyState(this.keyUp)) {
            this.camera.add(Vector.Y_AXIS, this.speed);
        }
        if (this.mode.getKeyState(this.keyDown)) {
            this.camera.add(Vector.Y_AXIS, -this.speed);
        }
    }

    @Override
    public void onMouseMove(float x, float y) {
        super.onMouseMove(x, y);
        this.moveAxisFront.set(this.getCameraAxis().getX(), 0.0, this.getCameraAxis().getZ());
        this.moveAxisFront.resize(1.0);
        this.moveAxisSide.set(this.moveAxisFront);
        this.moveAxisSide.rotate(Vector.Y_AXIS, 1.5707963267948966);
    }

    public void setPlace(Vector place) {
        this.camera.set(place);
    }
}

