/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.camera;

import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.Model;
import net.comp_lot.glui.model.utils.RayCast;

public class Camera {
    private final MutVector cameraAxis = new MutVector().set(0.0, 0.0, 1.0);
    private final MutVector cameraSideAxis = new MutVector().set(1.0, 0.0, 0.0);
    private float sensitivity = 1.0f;

    public void onMouseMove(float x, float y) {
        if (x != 0.0f) {
            this.cameraAxis.rotate(Vector.Y_AXIS, x / 500.0f * this.sensitivity);
            this.cameraSideAxis.set(this.cameraAxis.getX(), 0.0, this.cameraAxis.getZ()).resize(1.0).rotate(Vector.Y_AXIS, 1.5707963267948966);
        }
        if (y != 0.0f) {
            if (this.cameraAxis.getY() < -0.99 && y > 0.0f || this.cameraAxis.getY() > 0.99 && y < 0.0f) {
                return;
            }
            this.cameraAxis.rotate(this.cameraSideAxis, y / 500.0f * this.sensitivity);
        }
    }

    public void setSensitivity(float sensitivity) {
        this.sensitivity = sensitivity;
    }

    public void setCameraAxis(Vector axis) {
        this.cameraAxis.set(axis).resize(1.0);
        this.cameraSideAxis.set(this.cameraAxis.getX(), 0.0, this.cameraAxis.getZ()).resize(1.0).rotate(Vector.Y_AXIS, 1.5707963267948966);
    }

    public Vector getCameraAxis() {
        return this.cameraAxis;
    }

    public MutVector getCameraSideAxis() {
        return this.cameraSideAxis;
    }

    public static void getCameraOffset(MutVector offset, Vector center, double margin, Model ... models) {
        MutVector p = new MutVector();
        int i = 0;
        while (i < 4) {
            p.set(center);
            if (i == 1) {
                p.add(Vector.Y_AXIS, 0.1);
            }
            if (i == 2) {
                p.add(Vector.X_AXIS, 0.1);
            }
            if (i == 3) {
                p.add(Vector.Z_AXIS, 0.1);
            }
            RayCast cast = new RayCast(p, offset, offset.getSize() + margin);
            Model[] modelArray = models;
            int n = models.length;
            int n2 = 0;
            while (n2 < n) {
                Model model = modelArray[n2];
                RayCast.CastResult castResult = cast.cast(model);
                if (castResult != null) {
                    offset.resize(castResult.dist).add(castResult.getNormal(), margin);
                    return;
                }
                ++n2;
            }
            ++i;
        }
    }

    public static void setCameraOffset(MutVector cameraPos, Vector center, Vector offset, double margin, Model ... models) {
        Camera.getCameraOffset(cameraPos.set(offset), center, margin, models);
        cameraPos.add(center);
    }
}

