/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.animation;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.animation.Animator;
import net.comp_lot.glui.animation.BlendAnimator;
import net.comp_lot.glui.model.Model;
import net.comp_lot.glui.model.ModelGroup;
import net.comp_lot.glui.model.ModelOwner;
import net.comp_lot.glui.system.utils.ObjParser;

public class Humanoid {
    private static final String MOVE = "move";
    private final ModelGroup model = new ModelGroup();
    private final Map<String, Part> models = new HashMap<String, Part>();
    private Animator anim = null;

    public Humanoid(String recipe, ObjParser obj) {
        recipe.lines().filter(s -> s.startsWith("p")).map(s -> s.substring(2).split(" ")).forEach(s -> {
            String[] v = s[1].substring(1, s[1].length() - 1).split(",");
            this.addPart(obj, s[0], new MutVector().set(Double.parseDouble(v[0]), Double.parseDouble(v[1]), Double.parseDouble(v[2])));
        });
        recipe.lines().filter(s -> s.startsWith("r")).map(s -> s.substring(2).split(" ")).forEach(s -> this.setParent(s[0], s[1]));
        this.model.addModels(this.models.get((Object)"body").model);
    }

    public Model getModel() {
        return this.model;
    }

    public void rotate(String name, Vector rotate) {
        if (name.equals(MOVE)) {
            this.model.moveToP(rotate);
        } else if (this.models.containsKey(name)) {
            this.models.get(name).rotate(rotate);
        }
    }

    private void setParent(String parent, String child) {
        this.models.get((Object)parent).model.addModels(this.models.get((Object)child).model);
    }

    private void addPart(ObjParser obj, String name, Vector joint) {
        this.models.put(name, new Part(name, joint, obj.getModel(name)));
    }

    public void animFrame() {
        this.anim.frame().entrySet().stream().forEach(e -> this.rotate((String)e.getKey(), (Vector)e.getValue()));
    }

    public void setAnimation(Animator anim, double length) {
        this.anim = this.anim == null ? anim : new BlendAnimator(length, this.anim, anim);
    }

    public Collection<Part> getParts() {
        return this.models.values();
    }

    public static class Part
    implements ModelOwner {
        private final String name;
        private final Vector joint;
        private final ModelGroup model;

        private Part(String name, Vector joint, ModelGroup model) {
            this.name = name;
            this.joint = joint;
            this.model = model;
            model.setOwner(this);
        }

        public String getName() {
            return this.name;
        }

        private void rotate(Vector rotate) {
            this.model.rotateToP(Vector.ZERO, Vector.X_AXIS, 0.0);
            this.model.moveToP(Vector.ZERO);
            this.model.rotateToP(this.joint, rotate, rotate.getSize());
        }

        public void addModel(Model model) {
            model.moveP(this.joint);
            this.model.addModels(model);
        }

        public Model getModel() {
            return this.model;
        }
    }
}

