/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.animation;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.animation.Animator;
import net.comp_lot.glui.system.utils.FileUtils;

public class FrameAnimator
extends Animator {
    private final List<Map<String, Vector>> frames = new ArrayList<Map<String, Vector>>();
    private final double length;
    private final boolean loop;
    private double anim = 0.0;

    public FrameAnimator(double length, boolean loop) {
        this.length = length;
        this.loop = loop;
    }

    @Override
    public void reset() {
        this.anim = 0.0;
    }

    public void addFrame(Map<String, MutVector> pose) {
        HashMap frame = new HashMap();
        pose.entrySet().stream().forEach(e -> {
            MutVector mutVector = frame.put((String)e.getKey(), new MutVector().set((Vector)e.getValue()));
        });
        this.frames.add(frame);
    }

    public void addFrame(String file) {
        this.addFrame(FrameAnimator.loadPose(file));
    }

    public void loadFrames(String dirName) {
        File dir = new File(FileUtils.APP_DIR + dirName);
        Arrays.stream(dir.listFiles()).filter(f -> f.isFile() && f.getName().matches("[0-9]+\\.txt")).sorted((a, b) -> Integer.compare(Integer.parseInt(a.getName().replaceAll("([0-9]+)\\.txt", "$1")), Integer.parseInt(b.getName().replaceAll("([0-9]+)\\.txt", "$1")))).forEach(f -> this.addFrame(dirName + File.separatorChar + f.getName()));
    }

    @Override
    public Map<String, Vector> frame() {
        this.anim += (double)this.frames.size() / this.length;
        if (this.loop) {
            if (this.anim >= (double)this.frames.size()) {
                this.anim = 0.0;
            }
            Map<String, Vector> poseA = this.frames.get((int)this.anim);
            Map<String, Vector> poseB = this.frames.get(((int)this.anim + 1) % this.frames.size());
            return FrameAnimator.blend(this.anim - (double)((int)this.anim), poseA, poseB);
        }
        if (this.anim >= (double)(this.frames.size() - 1)) {
            this.anim = this.frames.size() - 1;
        }
        Map<String, Vector> poseA = this.frames.get((int)this.anim);
        Map<String, Vector> poseB = this.frames.get(Math.min((int)this.anim + 1, this.frames.size() - 1));
        return FrameAnimator.blend(this.anim - (double)((int)this.anim), poseA, poseB);
    }

    private static Map<String, MutVector> loadPose(String file) {
        HashMap<String, MutVector> pose = new HashMap<String, MutVector>();
        try {
            String str = FileUtils.loadFile(file);
            str.lines().forEach(line -> {
                String name = line.substring(0, line.indexOf(" "));
                String[] vec = line.substring(line.indexOf("(") + 1, line.indexOf(")")).split(",");
                pose.put(name, new MutVector());
                ((MutVector)pose.get(name)).set(Double.parseDouble(vec[0].trim()), Double.parseDouble(vec[1].trim()), Double.parseDouble(vec[2].trim()));
            });
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return pose;
    }
}

