/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.amount;

import net.comp_lot.glui.amount.FastSerializable;
import net.comp_lot.glui.amount.Matrix;
import net.comp_lot.glui.amount.MutVector;

public abstract class Vector
implements Comparable<Vector>,
FastSerializable {
    private static final double E_RANGE = 1.0E-4;
    public static final Vector X_AXIS = new MutVector().set(1.0, 0.0, 0.0);
    public static final Vector Y_AXIS = new MutVector().set(0.0, 1.0, 0.0);
    public static final Vector Z_AXIS = new MutVector().set(0.0, 0.0, 1.0);
    public static final Vector ZERO = new MutVector().set(0.0, 0.0, 0.0);

    public abstract double getX();

    public abstract double getY();

    public abstract double getZ();

    public abstract double getSize();

    public abstract boolean serializedAsEquals(Vector var1);

    public final double getDistS(Vector v) {
        return Vector.pow(this.getX() - v.getX()) + Vector.pow(this.getY() - v.getY()) + Vector.pow(this.getZ() - v.getZ());
    }

    private static final double pow(double d) {
        return d * d;
    }

    private static final double min(double a, double b) {
        return a < b ? a : b;
    }

    private static final double max(double a, double b) {
        return a > b ? a : b;
    }

    public static double Dot(Vector a, Vector b) {
        return a.getX() * b.getX() + a.getY() * b.getY() + a.getZ() * b.getZ();
    }

    public static double angle(Vector a, Vector b) {
        double size = a.getSize() * b.getSize();
        if (size == 0.0) {
            return 0.0;
        }
        double dot = Vector.Dot(a, b) / size;
        return Math.acos(Vector.min(Vector.max(dot, -1.0), 1.0));
    }

    public static double angle(Vector a, Vector b, Vector v) {
        double angle = Vector.angle(a, b);
        return Vector.Dot(MutVector.Cross(a, b), v) < 0.0 ? -angle : angle;
    }

    public static boolean sameDirection(Vector a, Vector b) {
        if (a == b) {
            return true;
        }
        double f = Vector.Dot(a, b) - a.getSize() * b.getSize();
        return Vector.isZero(f);
    }

    protected static boolean isZero(double d) {
        return -1.0E-4 < d && d < 1.0E-4;
    }

    public Matrix toRotMat() {
        if (this.getSize() == 0.0) {
            return new Matrix(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
        }
        double nx = this.getX() / this.getSize();
        double ny = this.getY() / this.getSize();
        double nz = this.getZ() / this.getSize();
        double cos = Math.cos(this.getSize());
        double sin = Math.sin(this.getSize());
        return new Matrix(nx * nx * (1.0 - cos) + cos, nx * ny * (1.0 - cos) - nz * sin, nx * nz * (1.0 - cos) + ny * sin, ny * nx * (1.0 - cos) + nz * sin, ny * ny * (1.0 - cos) + cos, ny * nz * (1.0 - cos) - nx * sin, nz * nx * (1.0 - cos) - ny * sin, nz * ny * (1.0 - cos) + nx * sin, nz * nz * (1.0 - cos) + cos);
    }

    public final boolean equals(Object o) {
        if (o != null && o instanceof Vector) {
            Vector v = (Vector)o;
            return Math.round(this.getX() * 1000.0) == Math.round(v.getX() * 1000.0) && Math.round(this.getY() * 1000.0) == Math.round(v.getY() * 1000.0) && Math.round(this.getZ() * 1000.0) == Math.round(v.getZ() * 1000.0);
        }
        return false;
    }

    public final int hashCode() {
        int result = 1;
        long bits = Double.doubleToLongBits(Math.round(this.getX() * 1000.0));
        result = 31 * result + (int)(bits ^ bits >>> 32);
        bits = Double.doubleToLongBits(Math.round(this.getY() * 1000.0));
        result = 31 * result + (int)(bits ^ bits >>> 32);
        bits = Double.doubleToLongBits(Math.round(this.getZ() * 1000.0));
        result = 31 * result + (int)(bits ^ bits >>> 32);
        return result;
    }

    @Override
    public final int compareTo(Vector v) {
        return Double.compare(this.getSize(), v.getSize());
    }

    public final String toString() {
        return String.format("(%.2f, %.2f, %.2f)", this.getX(), this.getY(), this.getZ());
    }
}

