/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.amount;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import net.comp_lot.glui.amount.Vector;

public final class MutVector
extends Vector
implements Serializable {
    private static final long serialVersionUID = 2L;
    private transient double x;
    private transient double y;
    private transient double z;
    private transient double size;

    public MutVector set(double x, double y, double z) {
        this.setOnly(x, y, z);
        this.size = -1.0;
        return this;
    }

    private void setOnly(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    private void setSize() {
        this.size = Math.sqrt(this.getX() * this.getX() + this.getY() * this.getY() + this.getZ() * this.getZ());
    }

    public MutVector set(Vector original) {
        this.setOnly(original.getX(), original.getY(), original.getZ());
        this.size = original.getSize();
        return this;
    }

    public MutVector set(Vector start, Vector end) {
        return this.set(end.getX() - start.getX(), end.getY() - start.getY(), end.getZ() - start.getZ());
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    @Override
    public double getSize() {
        if (this.size == -1.0) {
            this.setSize();
        }
        return this.size;
    }

    @Override
    public boolean serializedAsEquals(Vector v) {
        if (v instanceof MutVector) {
            return this.serializeToLong() == ((MutVector)v).serializeToLong();
        }
        return this.equals(v);
    }

    public boolean equalsAt(MutVector v, double scale) {
        return this.serializeToLong(scale) == v.serializeToLong(scale);
    }

    public MutVector add(Vector v) {
        return this.set(this.getX() + v.getX(), this.getY() + v.getY(), this.getZ() + v.getZ());
    }

    public MutVector add(Vector v, double rate) {
        return this.set(this.getX() + v.getX() * rate, this.getY() + v.getY() * rate, this.getZ() + v.getZ() * rate);
    }

    public MutVector resize(double size) {
        if (this.getSize() == 0.0) {
            return this;
        }
        double scale = size / this.getSize();
        this.setOnly(this.getX() * scale, this.getY() * scale, this.getZ() * scale);
        this.size = size > 0.0 ? size : -size;
        return this;
    }

    public MutVector scale(double scale) {
        this.setOnly(this.getX() * scale, this.getY() * scale, this.getZ() * scale);
        if (this.size != -1.0) {
            this.size = scale > 0.0 ? this.size * scale : -this.size * scale;
        }
        return this;
    }

    public MutVector reverse() {
        this.setOnly(-this.getX(), -this.getY(), -this.getZ());
        return this;
    }

    public MutVector round() {
        return this.set(Math.round(this.getX()), Math.round(this.getY()), Math.round(this.getZ()));
    }

    public MutVector toParallel(Vector v) {
        double size = MutVector.Dot(this, v) / v.getSize();
        return this.set(v).resize(size);
    }

    public MutVector toOrthogonal(Vector v) {
        if (v.getSize() == 0.0) {
            return this;
        }
        return this.add(v, -MutVector.Dot(this, v) / (v.getSize() * v.getSize()));
    }

    public MutVector rotate(Vector axis, double angle) {
        if (axis.getSize() != 1.0) {
            axis = new MutVector().set(axis).resize(1.0);
        }
        double c = Math.cos(angle);
        double s = Math.sin(angle);
        double x = (c + axis.getX() * axis.getX() * (1.0 - c)) * this.getX() + (axis.getX() * axis.getY() * (1.0 - c) - axis.getZ() * s) * this.getY() + (axis.getX() * axis.getZ() * (1.0 - c) + axis.getY() * s) * this.getZ();
        double y = (axis.getY() * axis.getX() * (1.0 - c) + axis.getZ() * s) * this.getX() + (c + axis.getY() * axis.getY() * (1.0 - c)) * this.getY() + (axis.getY() * axis.getZ() * (1.0 - c) - axis.getX() * s) * this.getZ();
        double z = (axis.getZ() * axis.getX() * (1.0 - c) - axis.getY() * s) * this.getX() + (axis.getZ() * axis.getY() * (1.0 - c) + axis.getX() * s) * this.getY() + (c + axis.getZ() * axis.getZ() * (1.0 - c)) * this.getZ();
        this.setOnly(x, y, z);
        return this;
    }

    public MutVector rotate(Vector center, Vector axis, double angle) {
        this.setOnly(this.getX() - center.getX(), this.getY() - center.getY(), this.getZ() - center.getZ());
        this.rotate(axis, angle);
        this.setOnly(this.getX() + center.getX(), this.getY() + center.getY(), this.getZ() + center.getZ());
        return this;
    }

    public MutVector mainDirection() {
        if (this.getX() * this.getX() > this.getY() * this.getY()) {
            if (this.getX() * this.getX() > this.getZ() * this.getZ()) {
                this.set(this.getX(), 0.0, 0.0);
            } else {
                this.set(0.0, 0.0, this.getZ());
            }
        } else if (this.getY() * this.getY() > this.getZ() * this.getZ()) {
            this.set(0.0, this.getY(), 0.0);
        } else {
            this.set(0.0, 0.0, this.getZ());
        }
        return this;
    }

    public static MutVector Cross(Vector a, Vector b) {
        return new MutVector().set(a.getY() * b.getZ() - a.getZ() * b.getY(), a.getZ() * b.getX() - a.getX() * b.getZ(), a.getX() * b.getY() - a.getY() * b.getX());
    }

    public static MutVector iDivision(Vector a, Vector b, double rateA, double rateB) {
        double x = (a.getX() * rateB + b.getX() * rateA) / (rateA + rateB);
        double y = (a.getY() * rateB + b.getY() * rateA) / (rateA + rateB);
        double z = (a.getZ() * rateB + b.getZ() * rateA) / (rateA + rateB);
        return new MutVector().set(x, y, z);
    }

    public static MutVector random() {
        return new MutVector().set(Math.random() - 0.5, Math.random() - 0.5, Math.random() - 0.5);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        this.write(s);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.read(s);
    }

    @Override
    public void read(ObjectInputStream s) throws IOException {
        int scale;
        long data = s.readLong();
        switch ((int)(data >> 60 & 0xFL)) {
            case 1: {
                scale = 32768;
                break;
            }
            case 2: {
                scale = 2048;
                break;
            }
            case 3: {
                scale = 128;
                break;
            }
            case 4: {
                scale = 32;
                break;
            }
            case 5: {
                scale = 8;
                break;
            }
            default: {
                scale = 1;
            }
        }
        this.set(MutVector.dec(data >> 40) / (double)scale, MutVector.dec(data >> 20) / (double)scale, MutVector.dec(data) / (double)scale);
    }

    @Override
    public void write(ObjectOutputStream s) throws IOException {
        s.writeLong(this.serializeToLong());
    }

    private long serializeToLong() {
        double scale;
        long header = 0L;
        double size = this.getL1Max();
        if (size < 16.0) {
            scale = 32768.0;
            header = 1L;
        } else if (size < 256.0) {
            scale = 2048.0;
            header = 2L;
        } else if (size < 4096.0) {
            scale = 128.0;
            header = 3L;
        } else if (size < 16384.0) {
            scale = 32.0;
            header = 4L;
        } else if (size < 65536.0) {
            scale = 8.0;
            header = 5L;
        } else {
            scale = 1.0;
        }
        return header << 60 | this.serializeToLong(scale);
    }

    private long serializeToLong(double scale) {
        return MutVector.enc((int)(this.x * scale)) << 40 | MutVector.enc((int)(this.y * scale)) << 20 | MutVector.enc((int)(this.z * scale));
    }

    private double getL1Max() {
        return Math.max(Math.max(Math.abs(this.getX()), Math.abs(this.getY())), Math.abs(this.getZ()));
    }

    private static long enc(int i) {
        int rtn = 0;
        if (i < 0) {
            rtn = 524288;
            i = -i;
        }
        if (i >= 524287) {
            return rtn | 0x7FFFF;
        }
        return rtn | 0x7FFFF & i;
    }

    private static double dec(long i) {
        if ((i & 0x7FFFFL) == 524287L) {
            if ((i >> 19 & 1L) == 1L) {
                return Double.NEGATIVE_INFINITY;
            }
            return Double.POSITIVE_INFINITY;
        }
        if ((i >> 19 & 1L) == 1L) {
            return -(i & 0x7FFFFL);
        }
        return i & 0x7FFFFL;
    }
}

