/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.amount;

import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;

public final class Matrix {
    private final double[][] a = new double[3][3];

    public Matrix(double a00, double a01, double a02, double a10, double a11, double a12, double a20, double a21, double a22) {
        this.a[0][0] = a00;
        this.a[0][1] = a01;
        this.a[0][2] = a02;
        this.a[1][0] = a10;
        this.a[1][1] = a11;
        this.a[1][2] = a12;
        this.a[2][0] = a20;
        this.a[2][1] = a21;
        this.a[2][2] = a22;
    }

    public Matrix() {
        this(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public MutVector fromRight(Vector v) {
        return new MutVector().set(this.a[0][0] * v.getX() + this.a[0][1] * v.getY() + this.a[0][2] * v.getZ(), this.a[1][0] * v.getX() + this.a[1][1] * v.getY() + this.a[1][2] * v.getZ(), this.a[2][0] * v.getX() + this.a[2][1] * v.getY() + this.a[2][2] * v.getZ());
    }

    public MutVector fromLeft(Vector v) {
        return new MutVector().set(this.a[0][0] * v.getX() + this.a[1][0] * v.getY() + this.a[2][0] * v.getZ(), this.a[0][1] * v.getX() + this.a[1][1] * v.getY() + this.a[2][1] * v.getZ(), this.a[0][2] * v.getX() + this.a[1][2] * v.getY() + this.a[2][2] * v.getZ());
    }

    public Matrix getTranspose() {
        return new Matrix(this.a[0][0], this.a[1][0], this.a[2][0], this.a[0][1], this.a[1][1], this.a[2][1], this.a[0][2], this.a[1][2], this.a[2][2]);
    }

    public Matrix add(Matrix b) {
        int i = 0;
        while (i < this.a.length) {
            int j = 0;
            while (j < this.a.length) {
                double[] dArray = this.a[i];
                int n = j;
                dArray[n] = dArray[n] + b.a[i][j];
                ++j;
            }
            ++i;
        }
        return this;
    }

    public MutVector toRotVec() {
        MutVector v = new MutVector().set(this.a[2][1] - this.a[1][2], this.a[0][2] - this.a[2][0], this.a[1][0] - this.a[0][1]);
        if (v.getSize() == 0.0) {
            return v;
        }
        v.resize(1.0);
        double cos = (this.a[0][0] + this.a[1][1] + this.a[2][2] - 1.0) * 0.5;
        double nx = v.getX();
        double ny = v.getY();
        double nz = v.getZ();
        double sin = Matrix.abs(nx) > Matrix.abs(ny) && Matrix.abs(nx) > Matrix.abs(nz) ? (this.a[2][1] + nz * ny * (cos - 1.0)) / nx : (Matrix.abs(ny) > Matrix.abs(nz) ? (this.a[0][2] + nx * nz * (cos - 1.0)) / ny : (this.a[1][0] + ny * nx * (cos - 1.0)) / nz);
        return v.scale(Math.atan2(sin, cos));
    }

    public static Matrix product(Matrix a, Matrix b) {
        return new Matrix(a.a[0][0] * b.a[0][0] + a.a[0][1] * b.a[1][0] + a.a[0][2] * b.a[2][0], a.a[0][0] * b.a[0][1] + a.a[0][1] * b.a[1][1] + a.a[0][2] * b.a[2][1], a.a[0][0] * b.a[0][2] + a.a[0][1] * b.a[1][2] + a.a[0][2] * b.a[2][2], a.a[1][0] * b.a[0][0] + a.a[1][1] * b.a[1][0] + a.a[1][2] * b.a[2][0], a.a[1][0] * b.a[0][1] + a.a[1][1] * b.a[1][1] + a.a[1][2] * b.a[2][1], a.a[1][0] * b.a[0][2] + a.a[1][1] * b.a[1][2] + a.a[1][2] * b.a[2][2], a.a[2][0] * b.a[0][0] + a.a[2][1] * b.a[1][0] + a.a[2][2] * b.a[2][0], a.a[2][0] * b.a[0][1] + a.a[2][1] * b.a[1][1] + a.a[2][2] * b.a[2][1], a.a[2][0] * b.a[0][2] + a.a[2][1] * b.a[1][2] + a.a[2][2] * b.a[2][2]);
    }

    public String toString() {
        return String.format("%.2f %.2f %.2f\n%.2f %.2f %.2f\n%.2f %.2f %.2f", this.a[0][0], this.a[0][1], this.a[0][2], this.a[1][0], this.a[1][1], this.a[1][2], this.a[2][0], this.a[2][1], this.a[2][2]);
    }

    private static double abs(double a) {
        return a >= 0.0 ? a : -a;
    }
}

