/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.system.title;

import java.util.function.Function;
import net.comp_lot.craftalos.Main;
import net.comp_lot.craftalos.game.TextureEnum;
import net.comp_lot.craftalos.lang.StringManager;
import net.comp_lot.craftalos.mission.MissionData;
import net.comp_lot.craftalos.system.title.FreePlayView;
import net.comp_lot.craftalos.system.title.GarageView;
import net.comp_lot.craftalos.system.title.MissionView;
import net.comp_lot.craftalos.system.title.SettingView;
import net.comp_lot.craftalos.system.title.TitleModeView;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.ModelGroup;
import net.comp_lot.glui.system.DialogBuilder;
import net.comp_lot.glui.system.Game;
import net.comp_lot.glui.system.GameMode;
import net.comp_lot.glui.system.HintBuilder;
import net.comp_lot.glui.system.utils.GluiXMLLayoutParser;
import net.comp_lot.glui.ui.Background;
import net.comp_lot.glui.ui.ButtonLayout;
import net.comp_lot.glui.ui.Image;
import net.comp_lot.glui.ui.Label;
import net.comp_lot.glui.ui.UIColor;
import net.comp_lot.ui.core.Component;
import net.comp_lot.ui.core.DisplayInfo;
import net.comp_lot.ui.core.Layout;

public class TitleMode
extends GameMode {
    private static boolean firstDescription = MissionData.getMission("KTABPGRX").map(m -> m.isClear()).orElse(true) == false;
    private static boolean showTutorial = true;
    private static boolean remainTutorial = MissionData.isTutorialRemains();
    private static ViewMode lastMode = remainTutorial ? ViewMode.MISSION : ViewMode.GARAGE;
    private final Component rootLayout;
    private final Label titleLabel;
    private final Layout contentFrame;
    private final ButtonLayout garageButton;
    private final ButtonLayout missionButton;
    private final ButtonLayout freeButton;
    private final ButtonLayout settingButton;
    private Component garageHint;
    private Component missionHint;
    private Component freeHint;
    private Component settingHint;
    private TitleModeView view;

    public TitleMode(Game game) {
        super(game, 60);
        DialogBuilder dialog;
        this.showPointer(true);
        this.setCamera(Vector.ZERO, Vector.Z_AXIS, Vector.Y_AXIS);
        this.rootLayout = new GluiXMLLayoutParser().parseOrElse((DisplayInfo)this.uiDisplay, this.getClass().getResourceAsStream("title_mode_layout.xml"), () -> null);
        this.addUI(this.rootLayout);
        this.titleLabel = (Label)this.rootLayout.getComponentByName("title-label");
        this.contentFrame = (Layout)this.rootLayout.getComponentByName("content-frame");
        Label garageLabel = (Label)this.rootLayout.getComponentByName("garage-label");
        garageLabel.setText(StringManager.lang.modeGarage());
        this.garageButton = (ButtonLayout)this.rootLayout.getComponentByName("garage-button");
        this.garageButton.setClickListener(() -> this.setView(ViewMode.GARAGE));
        this.garageHint = HintBuilder.build(this.uiDisplay, StringManager.lang.hintGarage());
        this.garageButton.setHint(() -> this.garageHint);
        Label missionLabel = (Label)this.rootLayout.getComponentByName("mission-label");
        missionLabel.setText(StringManager.lang.modeMission());
        this.missionButton = (ButtonLayout)this.rootLayout.getComponentByName("mission-button");
        this.missionButton.setClickListener(() -> this.setView(ViewMode.MISSION));
        this.missionHint = HintBuilder.build(this.uiDisplay, StringManager.lang.hintMission());
        this.missionButton.setHint(() -> this.missionHint);
        Label freeLabel = (Label)this.rootLayout.getComponentByName("free-label");
        freeLabel.setText(StringManager.lang.modeFree());
        this.freeButton = (ButtonLayout)this.rootLayout.getComponentByName("free-button");
        this.freeButton.setClickListener(() -> this.setView(ViewMode.FREE));
        this.freeHint = HintBuilder.build(this.uiDisplay, StringManager.lang.hintFree());
        this.freeButton.setHint(() -> this.freeHint);
        Label settingLabel = (Label)this.rootLayout.getComponentByName("setting-label");
        settingLabel.setText(StringManager.lang.modeSetting());
        this.settingButton = (ButtonLayout)this.rootLayout.getComponentByName("setting-button");
        this.settingButton.setClickListener(() -> this.setView(ViewMode.SETTING));
        this.settingHint = HintBuilder.build(this.uiDisplay, StringManager.lang.hintSetting());
        this.settingButton.setHint(() -> this.settingHint);
        Label quitLabel = (Label)this.rootLayout.getComponentByName("quit-label");
        quitLabel.setText(StringManager.lang.titleQuit());
        ButtonLayout quitButton = (ButtonLayout)this.rootLayout.getComponentByName("quit-button");
        quitButton.setClickListener(() -> {
            DialogBuilder dialog = DialogBuilder.newYesNoDialog(this, StringManager.lang.titleQuitMessage(), StringManager.lang.generalYes(), StringManager.lang.generalCancel(), () -> Main.exit(), () -> {});
            this.showDialog(dialog);
        });
        this.setView(lastMode);
        if (Main.missionResult != null) {
            Component result = new GluiXMLLayoutParser().parseOrElse((DisplayInfo)this.uiDisplay, this.getClass().getResourceAsStream("mission_result.xml"), () -> null);
            DialogBuilder dialog2 = DialogBuilder.newFreeDialog((GameMode)this, result);
            ((ButtonLayout)result.getComponentByName("close")).setClickListener(() -> dialog2.close());
            ((Label)result.getComponentByName("name")).setText(Main.missionResult.getMission().getTitle());
            ((Label)result.getComponentByName("time")).setText(String.format("Time : %.2fs", Main.missionResult.getTime()));
            ((Label)result.getComponentByName("rank")).setText(String.format("Rank : %s", Main.missionResult.getRank()));
            if (Main.missionResult.getReward() != null) {
                ((Label)result.getComponentByName("reward")).setText(Main.missionResult.getReward());
            }
            this.showDialog(dialog2);
            Main.missionResult = null;
        }
        if (Main.returnMessage != null) {
            dialog = DialogBuilder.newMessageDialog(this, Main.returnMessage);
            this.showDialog(dialog);
        }
        Main.reset();
        this.getGame().getRenderOptions().setClearColor(1280081920);
        if (firstDescription) {
            firstDescription = false;
            dialog = DialogBuilder.newMessageDialog(this, StringManager.lang.titleFirstDescription());
            this.showDialog(dialog);
        }
        if (showTutorial && lastMode != ViewMode.MISSION && MissionData.isTutorialRemains()) {
            dialog = DialogBuilder.newYesNoDialog(this, StringManager.lang.titleTutorialRemains(), StringManager.lang.titleTutorialShow(), StringManager.lang.titleTutorialSkip(), () -> this.setView(ViewMode.MISSION), () -> {
                showTutorial = false;
            });
            this.showDialog(dialog);
        }
        if (remainTutorial && !MissionData.isTutorialRemains()) {
            remainTutorial = false;
            dialog = DialogBuilder.newMessageDialog(this, StringManager.lang.titleTutorialComplete());
            this.showDialog(dialog);
        }
    }

    private void setView(ViewMode mode) {
        this.garageButton.setEnable(mode != ViewMode.GARAGE);
        this.missionButton.setEnable(mode != ViewMode.MISSION);
        this.freeButton.setEnable(mode != ViewMode.FREE);
        this.settingButton.setEnable(mode != ViewMode.SETTING);
        switch (mode) {
            case GARAGE: {
                this.titleLabel.setText(StringManager.lang.modeGarage());
                this.setView(new GarageView(this, this.uiDisplay));
                break;
            }
            case MISSION: {
                this.titleLabel.setText(String.format("%s (%d%%)", StringManager.lang.modeMission(), MissionData.getCompletePercent()));
                this.setView(new MissionView(this, this.uiDisplay));
                break;
            }
            case FREE: {
                this.titleLabel.setText(StringManager.lang.modeFree());
                this.setView(new FreePlayView(this, this.uiDisplay));
                break;
            }
            case SETTING: {
                this.titleLabel.setText(StringManager.lang.modeSetting());
                this.setView(new SettingView(this, this.uiDisplay));
                break;
            }
        }
        lastMode = mode;
    }

    private void setView(TitleModeView view) {
        if (this.view != null) {
            this.view.onClose();
        }
        this.view = view;
        this.contentFrame.clear();
        this.mainModel.clearChildren();
        if (((ModelGroup)view.getModel()).getAllChildren().size() == 0) {
            Image bg = new Image(this.uiDisplay, TextureEnum.UI_BACKGROUND.getAsInfo());
            bg.setColor(1616937215);
            bg.setRepeatUnit(256, 256);
            this.contentFrame.add(bg);
        }
        this.contentFrame.add(view.getComponent());
        this.mainModel.addModels(view.getModel());
        view.onSizeChanged();
    }

    @Override
    protected void onFrame() {
        this.view.onFrame();
        this.mainModel.callConfirmCoordinate();
    }

    @Override
    public void showDialog(DialogBuilder dialog) {
        dialog.setContainerBackground(new Background((DisplayInfo)this.uiDisplay, UIColor.TRANSPARENT_BLACK, UIColor.NONE, 0));
        super.showDialog(dialog);
    }

    @Override
    protected void setMode(Function<Game, GameMode> modeFactory) {
        super.setMode(modeFactory);
    }

    @Override
    protected void addUI(Component c) {
        super.addUI(c);
    }

    @Override
    protected void removeUI(Component c) {
        super.removeUI(c);
    }

    @Override
    public void onSizeChanged(int width, int height) {
        super.onSizeChanged(width, height);
        this.view.onSizeChanged();
    }

    @Override
    public void onClose() {
        this.view.onClose();
    }

    private static enum ViewMode {
        GARAGE,
        MISSION,
        FREE,
        SETTING;

    }
}

