/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.system.title;

import net.comp_lot.craftalos.CraftalosConfig;
import net.comp_lot.craftalos.EditModeKeyConfig;
import net.comp_lot.craftalos.lang.StringManager;
import net.comp_lot.craftalos.system.title.TitleMode;
import net.comp_lot.craftalos.system.title.TitleModeView;
import net.comp_lot.glui.system.DialogBuilder;
import net.comp_lot.glui.system.Game;
import net.comp_lot.glui.system.OperationEvent;
import net.comp_lot.glui.system.utils.MenuManager;
import net.comp_lot.glui.ui.GetKeyComponent;
import net.comp_lot.glui.ui.Slider;
import net.comp_lot.glui.ui.TextInput;
import net.comp_lot.ui.core.DisplayInfo;
import net.comp_lot.ui.core.Layout;

class SettingView
extends TitleModeView {
    private final CraftalosConfig config;
    private final MenuManager menu;

    public SettingView(TitleMode context, DisplayInfo display) {
        super(context, display, "setting_view_layout.xml");
        this.config = (CraftalosConfig)context.getGame().getConfig();
        Layout frame = (Layout)this.component.getComponentByName("setting-frame");
        this.menu = new MenuManager(display);
        frame.add(this.menu.getComponent());
        this.menu.set(StringManager.lang.titleMenuPath() + "settings.md");
        this.menu.set(StringManager.lang.titleMenuPath() + "settings.md");
        this.setSoundSettings();
        this.setDisplaySettings();
        this.setLanguageSettings();
        this.setKeyEditSettings();
    }

    private void setDisplaySettings() {
        this.menu.setGetter("$ui_scale", args -> String.format("%.1f", this.config.getUiScale()));
        this.menu.setListener("$ui_scale", args -> this.context.setActiveComponent(new TextInput(this.menu.getForm("$ui_scale"), () -> {
            double scale;
            try {
                scale = Math.min(Math.max(Double.parseDouble(this.menu.getForm("$ui_scale").getText()), 0.25), 4.0);
            }
            catch (NumberFormatException e) {
                scale = 1.0;
            }
            this.menu.getForm("$ui_scale").setText(String.format("%.1f", scale));
            double uiScale = scale;
            DialogBuilder dialog = DialogBuilder.newMessageDialog(this.context, StringManager.lang.settingRestartToLoad(), "OK", () -> {
                this.config.setUiScale(uiScale);
                this.config.save();
                this.context.setMode(game -> new TitleMode((Game)game));
            });
            this.context.showDialog(dialog);
        })));
    }

    private void setSoundSettings() {
        this.menu.setGetter("$volume_bgm", args -> String.valueOf(this.config.getVolumeBgm()));
        this.menu.setListener("$volume_bgm", args -> {
            Slider slider = this.menu.getSlider("$volume_bgm");
            slider.setCloseFunc(() -> {
                this.config.setVolumeBgm((float)slider.getPos());
                this.config.save();
            });
            this.context.setActiveComponent(slider);
        });
        this.menu.setGetter("$volume_se", args -> String.valueOf(this.config.getVolumeSe()));
        this.menu.setListener("$volume_se", args -> {
            Slider slider = this.menu.getSlider("$volume_se");
            slider.setCloseFunc(() -> {
                this.config.setVolumeSe((float)slider.getPos());
                this.config.save();
            });
            this.context.setActiveComponent(slider);
        });
        this.menu.setGetter("$volume_ui", args -> String.valueOf(this.config.getVolumeUi()));
        this.menu.setListener("$volume_ui", args -> {
            Slider slider = this.menu.getSlider("$volume_ui");
            slider.setCloseFunc(() -> {
                this.config.setVolumeUi((float)slider.getPos());
                this.config.save();
            });
            this.context.setActiveComponent(slider);
        });
        this.menu.setGetter("$volume_voice", args -> String.valueOf(this.config.getVolumeVoice()));
        this.menu.setListener("$volume_voice", args -> {
            Slider slider = this.menu.getSlider("$volume_voice");
            slider.setCloseFunc(() -> {
                this.config.setVolumeVoice((float)slider.getPos());
                this.config.save();
            });
            this.context.setActiveComponent(slider);
        });
    }

    private void setLanguageSettings() {
        this.menu.setListener("language", args -> {
            String language = (String)args.get("lang");
            if (!this.config.getLanguage().equals(language)) {
                this.config.setLanguage(language);
                this.config.save();
                StringManager.loadLang(this.config);
                this.context.setMode(game -> new TitleMode((Game)game));
            }
        });
    }

    private void setKeyEditSettings() {
        this.menu.setGetter("$mouse_sensitivity", args -> String.valueOf(this.config.getMouseSensitivity() / 2.0f));
        this.menu.setListener("$mouse_sensitivity", args -> {
            Slider slider = this.menu.getSlider("$mouse_sensitivity");
            slider.setCloseFunc(() -> {
                this.config.setMouseSensitivity((float)slider.getPos() * 2.0f);
                this.config.save();
            });
            this.context.setActiveComponent(slider);
        });
        EditModeKeyConfig keyConfig = this.config.getEditModeKeyConfig();
        keyConfig.getKeySet().stream().forEach(name -> {
            this.menu.setGetter("$" + name, args -> keyConfig.getKey((String)name).toString());
            this.menu.setListener("$" + name, args -> {
                DialogBuilder dialog = DialogBuilder.newMessageOnlyDialog(this.context, StringManager.lang.settingPressKey());
                this.context.showDialog(dialog);
                this.context.setActiveComponent(new GetKeyComponent(this.context, key -> {
                    dialog.close();
                    if (key != null) {
                        this.context.showDialog(DialogBuilder.newYesNoDialog(this.context, key.toString(), StringManager.lang.generalOK(), StringManager.lang.generalCancel(), () -> {
                            this.menu.getForm("$" + name).setText(key.toString());
                            keyConfig.setKey((String)name, (OperationEvent.KeyCode)((Object)((Object)((Object)key))));
                            this.config.save();
                        }, () -> {}));
                    }
                }));
            });
        });
    }
}

