/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.system.title;

import java.util.function.BiConsumer;
import net.comp_lot.craftalos.lang.StringManager;
import net.comp_lot.craftalos.system.client.PlayMode;
import net.comp_lot.craftalos.system.title.RoomConfig;
import net.comp_lot.craftalos.system.title.TitleMode;
import net.comp_lot.glui.system.DialogBuilder;
import net.comp_lot.glui.system.GameMode;
import net.comp_lot.glui.system.utils.MenuManager;

class RoomCreateMenu {
    private final RoomConfig roomConfig = new RoomConfig();
    private final String fileName;
    private final MenuManager menu;
    private final TitleMode context;

    RoomCreateMenu(String fileName, MenuManager menu, TitleMode context) {
        this.fileName = fileName;
        this.menu = menu;
        this.context = context;
    }

    void init() {
        this.setRoomCreate();
    }

    private void setRoomCreate() {
        this.setCandidates("$mode", (s1, s2) -> {
            if (!this.roomConfig.getMode().equals(s2)) {
                if (s2.equals("stroll")) {
                    this.menu.getForm("$map").setText("TutorialMap");
                    this.roomConfig.setMap("TutorialMap", "TutorialMap");
                    this.setRoomCreateStroll();
                } else if (s2.equals("battle")) {
                    this.menu.getForm("$player_num").setText("4");
                    this.roomConfig.setPlayerNum("4");
                    this.menu.getForm("$map").setText("Canyon");
                    this.roomConfig.setMap("res/map/canyon.obj:res/map/canyon_2v2.bcp", "Canyon");
                    this.menu.getForm("$damage").setText(StringManager.lang.roomDamageEnable());
                    this.roomConfig.setDamage("enable");
                    this.setRoomCreateBattle();
                } else {
                    this.menu.getForm("$player_num").setText("2");
                    this.roomConfig.setPlayerNum("2");
                    this.menu.getForm("$map").setText("Mountain");
                    this.roomConfig.setMap("res/map/mt_road.obj:res/map/mt_catch.bcp", "Mountain");
                    this.menu.getForm("$damage").setText(StringManager.lang.roomDamageEnable());
                    this.roomConfig.setDamage("enable");
                    this.setRoomCreateCatch();
                }
            }
            this.roomConfig.setMode((String)s2);
        }, 0, StringManager.lang.roomModeStroll(), "stroll", StringManager.lang.roomModeBattle(), "battle", StringManager.lang.roomModeCatch(), "catch");
        this.setRoomCreateStroll();
        this.setCandidates("$aircraft", (s1, s2) -> this.roomConfig.setAircraft((String)s2), 1, StringManager.lang.roomAircraftRecommended(), "recommended", StringManager.lang.roomAircraftNeutral(), "neutral", StringManager.lang.roomAircraftNotRecommended(), "not_recommended");
        this.setCandidates("$is_public", (s1, s2) -> this.roomConfig.setIsPublic((String)s2), 0, StringManager.lang.roomPublic(), "public", StringManager.lang.roomPrivate(), "private");
        this.menu.setListener("room_create", args -> this.context.setMode(game -> PlayMode.HostPlay(game, this.fileName, this.roomConfig, "craftalos.comp-lot.net", 51525, true)));
    }

    private void setRoomCreateStroll() {
        this.setCandidates("$player_num", (s1, s2) -> this.roomConfig.setPlayerNum((String)s2), 2, "2", "2", "3", "3", "4", "4", "5", "5", "6", "6", "7", "7", "8", "8");
        this.setCandidates("$map", (s1, s2) -> this.roomConfig.setMap((String)s2, (String)s1), 0, "TutorialMap", "TutorialMap", "RobotContestA", "res/map/rc2025.obj:res/map/rc2025.bcp", "Canyon", "res/map/canyon.obj", "Tunnel", "res/map/tunnel.obj", "Island", "res/map/island.obj:res/map/air_test.bcp", "Hill", "res/map/hill.obj", "Fuji", "res/map/map.obj", "AirRace", "res/map/air_race.obj", "RaceMap", "RaceMap");
        this.setCandidates("$damage", (s1, s2) -> this.roomConfig.setDamage((String)s2), 0, StringManager.lang.roomDamageEnable(), "enable", StringManager.lang.roomDamageDisable(), "disable");
    }

    private void setRoomCreateBattle() {
        this.setCandidates("$player_num", (s1, s2) -> this.roomConfig.setPlayerNum((String)s2), 0, "4", "4");
        this.setCandidates("$map", (s1, s2) -> this.roomConfig.setMap((String)s2, (String)s1), 0, "Canyon", "res/map/canyon.obj:res/map/canyon_2v2.bcp", "Tunnel", "res/map/tunnel.obj:res/map/tunnel_2v2.bcp");
        this.setCandidates("$damage", (s1, s2) -> this.roomConfig.setDamage((String)s2), 0, StringManager.lang.roomDamageEnable(), "enable");
    }

    private void setRoomCreateCatch() {
        this.setCandidates("$player_num", (s1, s2) -> this.roomConfig.setPlayerNum((String)s2), 0, "2", "2");
        this.setCandidates("$map", (s1, s2) -> this.roomConfig.setMap((String)s2, (String)s1), 0, "Mountain", "res/map/mt_road.obj:res/map/mt_catch.bcp");
        this.setCandidates("$damage", (s1, s2) -> this.roomConfig.setDamage((String)s2), 0, StringManager.lang.roomDamageEnable(), "enable");
    }

    private void setCandidates(String name, BiConsumer<String, String> listener, int initial, String ... candidates) {
        this.menu.setGetter(name, args -> candidates[initial * 2]);
        this.menu.setListener(name, args -> this.showCandidatesDialog((s1, s2) -> {
            listener.accept((String)s1, (String)s2);
            this.menu.getForm(name).setText((String)s1);
        }, candidates));
    }

    private void showCandidatesDialog(BiConsumer<String, String> onSelect, String ... candidates) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < candidates.length) {
            sb.append(String.format("## [%s](%s)\n\n", candidates[i], candidates[i + 1]));
            i += 2;
        }
        MenuManager content = new MenuManager(this.context.getUIDisplay());
        content.setContents(sb.toString());
        DialogBuilder dialog = DialogBuilder.newFreeDialog((GameMode)this.context, content);
        int i2 = 0;
        while (i2 < candidates.length) {
            int index = i2;
            content.setListener(candidates[i2 + 1], args -> {
                onSelect.accept(candidates[index], candidates[index + 1]);
                dialog.close();
            });
            i2 += 2;
        }
        this.context.showDialog(dialog);
    }
}

