/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.system.title;

import net.comp_lot.craftalos.CraftalosConfig;
import net.comp_lot.craftalos.Main;
import net.comp_lot.craftalos.game.TextureEnum;
import net.comp_lot.craftalos.mission.Mission;
import net.comp_lot.craftalos.mission.MissionData;
import net.comp_lot.craftalos.system.client.PlayMode;
import net.comp_lot.craftalos.system.title.RoomConfig;
import net.comp_lot.craftalos.system.title.TitleMode;
import net.comp_lot.craftalos.system.title.TitleModeView;
import net.comp_lot.glui.system.utils.GluiXMLLayoutParser;
import net.comp_lot.glui.ui.ButtonLayout;
import net.comp_lot.glui.ui.Image;
import net.comp_lot.glui.ui.Label;
import net.comp_lot.ui.core.Component;
import net.comp_lot.ui.core.DisplayInfo;
import net.comp_lot.ui.core.Layout;
import net.comp_lot.ui.layout.AlignmentLayout;
import net.comp_lot.ui.layout.TileLayout;

class MissionView
extends TitleModeView {
    private final String fileName;
    private final TileLayout tiles;
    private final Layout detailFrame;

    public MissionView(TitleMode context, DisplayInfo display) {
        super(context, display, "mission_view_layout.xml");
        this.fileName = ((CraftalosConfig)context.getGame().getConfig()).getFileName();
        Label machineNameLabel = (Label)this.component.getComponentByName("machine-name-label");
        machineNameLabel.setText(this.fileName != null ? this.fileName : "not selected");
        this.detailFrame = (Layout)this.component.getComponentByName("mission-detail-frame");
        this.tiles = (TileLayout)this.component.getComponentByName("mission-map-tiles");
        this.tiles.add(machineNameLabel);
        Image bg = new Image(display, TextureEnum.MISSION_MAP.getAsInfo());
        this.tiles.add(bg);
        this.tiles.setPlace(bg, -0.5, -0.5);
        this.tiles.setScale(bg, 16.0);
        MissionData.getMissions().forEach(m -> this.addMission((Mission)m));
    }

    private void addMission(Mission mission) {
        ButtonLayout button = new ButtonLayout(this.display, TextureEnum.UI_BUTTON.getAsInfo(), 24);
        button.setClickListener(() -> this.startMission(mission));
        button.setHoverEnterListener(() -> this.showMissionDetail(mission));
        button.setMargin(1);
        if (mission.isClear()) {
            AlignmentLayout align = new AlignmentLayout(this.display);
            Label rank = new Label(this.display, 24, mission.getState().name().substring(6, 7));
            rank.setColor(255);
            rank.setBackground(mission.getState() == Mission.MissionState.CLEAR_S ? -2075137 : -286331137);
            rank.setMarginRight(4);
            rank.setMarginBottom(2);
            align.add(rank);
            align.setHorizontalAlign(rank, AlignmentLayout.HORIZONTAL_RIGHT);
            align.setVerticalAlign(rank, AlignmentLayout.VERTICAL_BOTTOM);
            button.add(align);
        }
        if (mission.isClear()) {
            button.setBaseColor(0x4848FFFF);
            button.setHoverColor(0x6666FFFF);
            button.setPressedColor(-1431646977);
        } else {
            button.setBaseColor(-13028609);
            button.setHoverColor(-10460929);
            button.setPressedColor(-1433892609);
        }
        this.tiles.add(button);
        this.tiles.setPlace(button, mission.getX(), mission.getY());
    }

    private void showMissionDetail(Mission mission) {
        Component detailLayout = new GluiXMLLayoutParser().parseOrElse(this.display, this.getClass().getResourceAsStream("mission_detail_layout.xml"), () -> null);
        Label titleLabel = (Label)detailLayout.getComponentByName("title-label");
        titleLabel.setText(mission.getTitle());
        Label mapLabel = (Label)detailLayout.getComponentByName("map-label");
        mapLabel.setText(mission.getMapName());
        Label descriptionLabel = (Label)detailLayout.getComponentByName("description-label");
        descriptionLabel.setText(mission.getDescription());
        if (mission.isClear()) {
            Layout imageFrame = (Layout)detailLayout.getComponentByName("clear-image-frame");
            Image image = new Image(this.display, TextureEnum.UI_CLEAR.getAsInfo());
            image.setColor(-10074932);
            imageFrame.add(image);
        }
        this.detailFrame.clear();
        this.detailFrame.add(detailLayout);
    }

    private void startMission(Mission mission) {
        Main.reset();
        Main.missionID = mission.getMissionID();
        RoomConfig roomConfig = new RoomConfig();
        roomConfig.setMap(mission.getMapID(), mission.getMapName());
        if (mission.getMachine() != null) {
            this.context.setMode(game -> PlayMode.LocalPlay(game, mission.getMachine(), Main.Mode.PLAY, roomConfig, 0));
        } else {
            this.context.setMode(game -> PlayMode.LocalPlay(game, this.fileName, Main.Mode.PLAY, roomConfig, 0));
        }
    }
}

