/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.system.title;

import java.io.FileNotFoundException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import net.comp_lot.craftalos.CraftalosConfig;
import net.comp_lot.craftalos.game.Machine;
import net.comp_lot.craftalos.game.TextureEnum;
import net.comp_lot.craftalos.program.compiler.CompileException;
import net.comp_lot.craftalos.program.compiler.MachineCompiler;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.Model;
import net.comp_lot.glui.model.ModelGroup;
import net.comp_lot.glui.model.model.BoxShape;
import net.comp_lot.glui.system.utils.FileUtils;
import net.comp_lot.glui.ui.FrameBackground;
import net.comp_lot.glui.ui.Label;
import net.comp_lot.glui.ui.UIColor;
import net.comp_lot.ui.core.Component;
import net.comp_lot.ui.core.DisplayInfo;
import net.comp_lot.ui.layout.AlignmentLayout;

public class MachinePreview
extends Component {
    private static final double MACHINE_GRID = 102.0;
    private static final double ANGLE = -0.17453292519943295;
    private final CraftalosConfig config;
    private final ExecutorService threads;
    private String name;
    private final boolean sample;
    private final int size;
    private boolean read = false;
    private Model readBuf;
    private final List<Model> prevContainer;
    private final ModelGroup model = new ModelGroup();
    private Model machineModel;
    private final AlignmentLayout layout;
    private final Label label;
    private boolean selected;
    private double rotate;

    public MachinePreview(DisplayInfo display, List<Model> prevContainer, String name, int size, String sampleType, CraftalosConfig config, ExecutorService threads) {
        super(display);
        this.config = config;
        this.threads = threads;
        this.prevContainer = prevContainer;
        this.name = name;
        this.sample = sampleType != null;
        this.size = size;
        this.makeFloor();
        this.layout = new AlignmentLayout(display);
        this.label = new Label(display, size / 8, name.substring(name.lastIndexOf("/") + 1));
        this.label.setBackground(UIColor.DARK_GRAY.code());
        this.label.setAlign(Label.Align.CENTER);
        this.label.setMarginLeft(5);
        this.label.setMarginRight(5);
        this.label.setMarginBottom(5);
        this.layout.add(this.label);
        this.layout.setHorizontalAlign(this.label, AlignmentLayout.HORIZONTAL_FILL);
        this.layout.setVerticalAlign(this.label, AlignmentLayout.VERTICAL_BOTTOM);
        if (this.sample) {
            Label sampleLabel = new Label(display, size / 8, sampleType);
            sampleLabel.setMargin(8);
            this.layout.add(sampleLabel);
            this.layout.setHorizontalAlign(sampleLabel, AlignmentLayout.HORIZONTAL_LEFT);
            this.layout.setVerticalAlign(sampleLabel, AlignmentLayout.VERTICAL_TOP);
        }
    }

    private void makeFloor() {
        BoxShape floor = new BoxShape(102.0f, 2.0f, 102.0f, TextureEnum.WHITE.getAsInfo());
        floor.setColor(-1145324545);
        floor.moveL(Vector.Y_AXIS, -1.1);
        floor.rotateL(new MutVector().set(0.0, 0.0, -51.0), Vector.X_AXIS, -0.17453292519943295);
        BoxShape floor2 = new BoxShape(100.0f, 2.0f, 102.0f, TextureEnum.WHITE.getAsInfo());
        floor2.setColor(-2004317953);
        floor2.moveL(Vector.Y_AXIS, -1.0);
        floor2.rotateL(new MutVector().set(0.0, 0.0, -51.0), Vector.X_AXIS, -0.17453292519943295);
        this.model.addModels(floor, floor2);
    }

    @Override
    public Component getComponentByPosition(int x, int y, Function<Component, Boolean> filter) {
        if (this.label.getComponentByPosition(x, y, filter) != null) {
            return this.label;
        }
        return super.getComponentByPosition(x, y, filter);
    }

    public boolean isSample() {
        return this.sample;
    }

    public boolean nameEquals(String name) {
        return this.getMachineName().equals(name);
    }

    public void setMachineName(String name) {
        this.name = name;
        this.label.setText(name.substring(name.lastIndexOf("/") + 1));
    }

    public String getMachineName() {
        return this.name;
    }

    public Label getLabel() {
        return this.label;
    }

    public void setSlected(boolean selected) {
        this.selected = selected;
        this.setBackground(selected ? new FrameBackground(this.getDisplay(), 5, UIColor.DARK_BLUE.code()) : null);
    }

    public boolean isSelected() {
        return this.selected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadModel() {
        try {
            String bcm = FileUtils.loadFile(this.getMachineName() + ".bcm");
            try {
                Machine machine = MachineCompiler.compile(bcm);
                Model readBuf = machine.getModel();
                MachinePreview machinePreview = this;
                synchronized (machinePreview) {
                    this.readBuf = readBuf;
                }
            }
            catch (CompileException e) {
                System.err.println(e.getDetailMessage(bcm));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public Model get3DModel() {
        return this.model;
    }

    @Override
    protected int preferredWidth() {
        return (int)((double)this.size * this.getDisplay().getScale());
    }

    @Override
    protected int preferredHeight() {
        return (int)((double)this.size * this.getDisplay().getScale());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void draw(int x, int y, int width, int height) {
        if (this.machineModel == null) {
            if (!this.read) {
                this.read = true;
                this.threads.execute(this::loadModel);
            }
            MachinePreview machinePreview = this;
            synchronized (machinePreview) {
                if (this.readBuf != null) {
                    this.machineModel = this.readBuf;
                    this.model.addModels(this.machineModel);
                    this.machineModel.rotateL(new MutVector().set(0.0, 0.0, -51.0), Vector.X_AXIS, -0.17453292519943295);
                    this.machineModel.rotateL(Vector.ZERO, Vector.Y_AXIS, Math.PI);
                    this.readBuf = null;
                }
            }
        } else if (this.selected) {
            this.machineModel.rotateL(Vector.ZERO, Vector.Y_AXIS, 0.01);
            this.rotate += 0.01;
        } else if (this.rotate != 0.0) {
            this.machineModel.rotateL(Vector.ZERO, Vector.Y_AXIS, -this.rotate);
            this.rotate = 0.0;
        }
        int size = Math.min(width, height);
        double r = (double)this.getDisplay().getHeight() / (2.0 * Math.sin(this.config.getFovy() / 2.0f));
        double z = r * Math.cos(this.config.getFovy() / 2.0f);
        double mx = (double)(x - this.getDisplay().getWidth() / 2) * 102.0 / (double)size + 51.0;
        double my = (double)(-(y + height - this.label.getPreferredHeight()) + this.getDisplay().getHeight() / 2) * 102.0 / (double)size;
        double mz = z * 102.0 / (double)size + 51.0;
        this.model.setPosition(new MutVector().set(mx, my, mz));
        this.prevContainer.add(this.model);
        this.layout.setRect(x, y, width, height);
        this.layout.callDraw();
    }
}

