/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.system.title;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import net.comp_lot.glui.system.utils.FileUtils;

class MachineDataUtils {
    MachineDataUtils() {
    }

    static void add(String name) {
        if (!new File(FileUtils.APP_DIR + name + ".bcm").exists()) {
            FileUtils.writeFile(name + ".bcm", "{}");
        }
    }

    static void rename(String name, String newName) {
        String pathname = FileUtils.APP_DIR + name;
        File srcBcm = new File(pathname + ".bcm");
        File srcBcp = new File(pathname + ".bcp");
        File srcPng = new File(pathname + ".png");
        String newPathname = FileUtils.APP_DIR + newName;
        File dstBcm = new File(newPathname + ".bcm");
        File dstBcp = new File(newPathname + ".bcp");
        File dstPng = new File(newPathname + ".png");
        try {
            if (srcBcm.exists()) {
                Files.move(Paths.get(srcBcm.getAbsolutePath(), new String[0]), Paths.get(dstBcm.getAbsolutePath(), new String[0]), new CopyOption[0]);
            }
            if (srcBcp.exists()) {
                Files.move(Paths.get(srcBcp.getAbsolutePath(), new String[0]), Paths.get(dstBcp.getAbsolutePath(), new String[0]), new CopyOption[0]);
            }
            if (srcPng.exists()) {
                Files.move(Paths.get(srcPng.getAbsolutePath(), new String[0]), Paths.get(dstPng.getAbsolutePath(), new String[0]), new CopyOption[0]);
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    static void copy(String name, String newName) {
        String pathname = FileUtils.APP_DIR + name;
        File srcBcm = new File(pathname + ".bcm");
        File srcBcp = new File(pathname + ".bcp");
        File srcPng = new File(pathname + ".png");
        String newPathname = FileUtils.APP_DIR + newName;
        File dstBcm = new File(newPathname + ".bcm");
        File dstBcp = new File(newPathname + ".bcp");
        File dstPng = new File(newPathname + ".png");
        try {
            if (srcBcm.exists()) {
                Files.copy(Paths.get(srcBcm.getAbsolutePath(), new String[0]), Paths.get(dstBcm.getAbsolutePath(), new String[0]), new CopyOption[0]);
            }
            if (srcBcp.exists()) {
                Files.copy(Paths.get(srcBcp.getAbsolutePath(), new String[0]), Paths.get(dstBcp.getAbsolutePath(), new String[0]), new CopyOption[0]);
            }
            if (srcPng.exists()) {
                Files.copy(Paths.get(srcPng.getAbsolutePath(), new String[0]), Paths.get(dstPng.getAbsolutePath(), new String[0]), new CopyOption[0]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static void delete(String name) {
        String pathname = FileUtils.APP_DIR + name;
        File bcm = new File(pathname + ".bcm");
        File bcp = new File(pathname + ".bcp");
        File png = new File(pathname + ".png");
        try {
            Files.deleteIfExists(Paths.get(bcm.getAbsolutePath(), new String[0]));
            Files.deleteIfExists(Paths.get(bcp.getAbsolutePath(), new String[0]));
            Files.deleteIfExists(Paths.get(png.getAbsolutePath(), new String[0]));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static List<String> load(String dirName) {
        ArrayList<String> machineList = new ArrayList<String>();
        File dir = new File(FileUtils.APP_DIR + dirName);
        if (!dir.exists() || !dir.isDirectory()) {
            System.err.println("directory " + dirName + " not found.");
            return machineList;
        }
        File[] fileArray = dir.listFiles(f -> f.getName().endsWith(".bcm"));
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f2 = fileArray[n2];
            machineList.add(dirName + "/" + f2.getName().substring(0, f2.getName().length() - 4));
            ++n2;
        }
        return machineList;
    }
}

