/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.system.title;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.comp_lot.craftalos.CraftalosConfig;
import net.comp_lot.craftalos.game.TextureEnum;
import net.comp_lot.craftalos.lang.StringManager;
import net.comp_lot.craftalos.mission.MissionData;
import net.comp_lot.craftalos.system.client.PlayMode;
import net.comp_lot.craftalos.system.edit.EditMode;
import net.comp_lot.craftalos.system.program.ProgramMode;
import net.comp_lot.craftalos.system.title.MachineDataUtils;
import net.comp_lot.craftalos.system.title.MachinePreview;
import net.comp_lot.craftalos.system.title.TitleMode;
import net.comp_lot.craftalos.system.title.TitleModeView;
import net.comp_lot.glui.model.Model;
import net.comp_lot.glui.model.ModelGroup;
import net.comp_lot.glui.system.DialogBuilder;
import net.comp_lot.glui.system.Game;
import net.comp_lot.glui.ui.Background;
import net.comp_lot.glui.ui.ButtonLayout;
import net.comp_lot.glui.ui.Image;
import net.comp_lot.glui.ui.Label;
import net.comp_lot.glui.ui.TextInput;
import net.comp_lot.glui.ui.UIColor;
import net.comp_lot.glui.ui.UIDisplay;
import net.comp_lot.ui.core.ClickListener;
import net.comp_lot.ui.core.Component;
import net.comp_lot.ui.core.DisplayInfo;
import net.comp_lot.ui.core.Layout;
import net.comp_lot.ui.layout.AbsoluteLayout;
import net.comp_lot.ui.layout.GravityBottomLayout;
import net.comp_lot.ui.layout.GridLayout;
import net.comp_lot.ui.layout.ScrollLayout;
import net.comp_lot.ui.layout.VerticalLinearLayout;

class GarageView
extends TitleModeView {
    private final CraftalosConfig config;
    private final ExecutorService threads;
    private final ScrollLayout scroll;
    private final GridLayout grid;
    private final Component addButton;
    private final List<Model> prevModels = new ArrayList<Model>();
    private final ModelGroup prevHost = new ModelGroup();

    public GarageView(TitleMode context, DisplayInfo display) {
        super(context, display, "garage_view_layout.xml");
        this.config = (CraftalosConfig)context.getGame().getConfig();
        this.threads = Executors.newFixedThreadPool(Math.max(Runtime.getRuntime().availableProcessors() - 1, 1));
        this.scroll = (ScrollLayout)this.component.getComponentByName("machine-scroll");
        this.grid = (GridLayout)this.component.getComponentByName("machine-grid");
        this.mainModel.addModels(this.prevHost);
        this.setEditListeners();
        this.loadMachineList();
        this.addButton = this.makeAddButton();
        this.grid.add(this.addButton);
    }

    @Override
    public void onFrame() {
        this.prevHost.clearChildren();
        this.prevHost.addModels(this.prevModels.toArray(new Model[0]));
        this.prevModels.clear();
    }

    @Override
    public void onSizeChanged() {
        this.scroll.resetScroll();
        ((UIDisplay)this.display).draw();
        this.grid.getChildren().stream().filter(m -> m instanceof MachinePreview).map(m -> (MachinePreview)m).filter(mp -> mp.nameEquals(this.config.getFileName())).findAny().ifPresent(mp -> this.scroll.scroll(0, -mp.getRect().getY() + mp.getRect().getHeight()));
    }

    private void setEditListeners() {
        Label editLabel = (Label)this.component.getComponentByName("edit-label");
        editLabel.setText(StringManager.lang.modeEdit());
        ButtonLayout editButton = (ButtonLayout)this.component.getComponentByName("edit-button");
        editButton.setClickListener(() -> {
            if (this.config.getFileName() != null) {
                this.context.setMode(game -> new EditMode((Game)game, this.config.getFileName()));
            }
        });
        Label programLabel = (Label)this.component.getComponentByName("program-label");
        programLabel.setText(StringManager.lang.modeProgram());
        ButtonLayout programButton = (ButtonLayout)this.component.getComponentByName("program-button");
        programButton.setClickListener(() -> {
            if (this.config.getFileName() != null) {
                this.context.setMode(game -> new ProgramMode((Game)game, this.config.getFileName()));
            }
        });
        Label testLabel = (Label)this.component.getComponentByName("test-label");
        testLabel.setText(StringManager.lang.modeTest());
        ButtonLayout testButton = (ButtonLayout)this.component.getComponentByName("test-button");
        testButton.setClickListener(() -> {
            if (this.config.getFileName() != null) {
                this.context.setMode(game -> PlayMode.TestPlay(game, this.config.getFileName()));
            }
        });
    }

    private Layout makeAddButton() {
        GravityBottomLayout addLayout = new GravityBottomLayout(this.display);
        addLayout.setMinWidth((int)(256.0 * this.display.getScale()));
        addLayout.setMinHeight((int)(256.0 * this.display.getScale()));
        Label addLabel = new Label(this.display, 32, StringManager.lang.titleNewMachine());
        addLabel.setAlign(Label.Align.CENTER);
        addLabel.setMargin(5);
        addLabel.setBackground(UIColor.DARK_GRAY.code());
        addLayout.add(addLabel);
        Image addIcon = new Image(this.display, TextureEnum.UI_GARAGE_ADD.getAsInfo());
        addIcon.setPadding(30);
        addLayout.setBackground(addIcon);
        addLayout.setClickListener(new ClickListener().setOnButton1Pressed((x, y) -> this.onAddButtonClicked()));
        return addLayout;
    }

    private void onAddButtonClicked() {
        String name = this.checkName("machine/new");
        MachineDataUtils.add(name);
        this.onMachineClicked(this.addMachine(this.grid.size() - 1, name));
    }

    private void loadMachineList() {
        List<String> machineList = MachineDataUtils.load("machine");
        List<String> sampleList = MachineDataUtils.load("res/sample");
        machineList.addAll(sampleList);
        List<String> libList = MachineDataUtils.load("res/stdlib");
        machineList.addAll(libList);
        List<String> distroList = MachineDataUtils.load("res/distro");
        distroList.retainAll(MissionData.getRewards());
        machineList.addAll(distroList);
        machineList.stream().sorted((a, b) -> a.toLowerCase().compareTo(b.toLowerCase())).forEach(n -> this.addMachine((String)n));
        Optional<MachinePreview> selected = this.grid.getChildren().stream().map(m -> (MachinePreview)m).filter(mp -> mp.nameEquals(this.config.getFileName())).findAny();
        if (selected.isEmpty()) {
            this.config.setFileName(machineList.stream().sorted((a, b) -> a.toLowerCase().compareTo(b.toLowerCase())).findFirst().orElse(null));
            this.config.save();
            selected = this.grid.getChildren().stream().map(m -> (MachinePreview)m).filter(mp -> mp.nameEquals(this.config.getFileName())).findAny();
        }
        selected.ifPresent(p -> p.setSlected(true));
    }

    private MachinePreview addMachine(String name) {
        return this.addMachine(this.grid.size(), name);
    }

    private MachinePreview addMachine(int index, String name) {
        MachinePreview prev = new MachinePreview(this.display, this.prevModels, name, 256, name.startsWith("res/") ? (name.startsWith("res/stdlib/") ? "library" : "sample") : null, this.config, this.threads);
        ClickListener listener = new ClickListener();
        listener.setOnButton1Pressed((x, y) -> this.onMachineClicked(prev));
        listener.setOnButton2Pressed((x, y) -> this.onMachineRightClicked(prev, x, y));
        prev.setClickListener(listener);
        if (!prev.isSample()) {
            ClickListener labelListener = new ClickListener();
            labelListener.setOnButton1Pressed((x, y) -> this.changeMachineName(prev));
            prev.getLabel().setClickListener(labelListener);
        }
        this.grid.add(index, prev);
        return prev;
    }

    private void onMachineClicked(MachinePreview prev) {
        this.grid.getChildren().stream().filter(m -> m instanceof MachinePreview).forEach(m -> {
            MachinePreview mp = (MachinePreview)m;
            if (mp.nameEquals(this.config.getFileName())) {
                mp.setSlected(false);
            }
        });
        prev.setSlected(true);
        this.config.setFileName(prev.getMachineName());
        this.config.save();
    }

    private void onMachineRightClicked(MachinePreview prev, int mx, int my) {
        this.onMachineClicked(prev);
        AbsoluteLayout layout = new AbsoluteLayout(this.display);
        layout.setClickListener(new ClickListener().setOnButton1Pressed((x, y) -> this.context.removeUI(layout)));
        VerticalLinearLayout list = new VerticalLinearLayout(this.display, 1);
        list.setPadding(1);
        list.setBackground(new Background(this.display, UIColor.WHITE, UIColor.NONE, 0));
        ButtonLayout copy = new ButtonLayout(this.display, new Label(this.display, 30, StringManager.lang.titleDuplicate()));
        copy.setClickListener(() -> {
            this.copy(prev);
            this.context.removeUI(layout);
        });
        list.add(copy);
        ButtonLayout delete = new ButtonLayout(this.display, new Label(this.display, 30, StringManager.lang.titleDelete()));
        delete.setClickListener(() -> {
            DialogBuilder dialog = DialogBuilder.newYesNoDialog(this.context, StringManager.lang.titleDeleteConfirm(), StringManager.lang.titleDelete(), StringManager.lang.generalCancel(), () -> this.delete(prev), () -> {});
            this.context.showDialog(dialog);
            this.context.removeUI(layout);
        });
        list.add(delete);
        ButtonLayout rename = new ButtonLayout(this.display, new Label(this.display, 30, StringManager.lang.titleRename()));
        rename.setClickListener(() -> {
            this.changeMachineName(prev);
            this.context.removeUI(layout);
        });
        list.add(rename);
        if (prev.isSample()) {
            delete.setEnable(false);
            rename.setEnable(false);
        }
        layout.add(list);
        layout.setPlace(list, mx, my);
        this.context.addUI(layout);
    }

    private void copy(MachinePreview prev) {
        String name = prev.getMachineName();
        String newName = this.checkName("machine/" + name.substring(name.lastIndexOf("/") + 1));
        MachineDataUtils.copy(name, newName);
        this.onMachineClicked(this.addMachine(this.grid.indexOf(prev) + 1, newName));
    }

    private void delete(MachinePreview prev) {
        MachineDataUtils.delete(prev.getMachineName());
        this.grid.remove(prev);
        this.config.setFileName(null);
        this.config.save();
    }

    private void changeMachineName(MachinePreview prev) {
        String path = prev.getMachineName().substring(0, prev.getMachineName().lastIndexOf("/") + 1);
        String oldName = prev.getMachineName().substring(prev.getMachineName().lastIndexOf("/") + 1);
        this.context.setActiveComponent(new TextInput(prev.getLabel(), () -> {
            if (!oldName.equals(prev.getLabel().getText())) {
                String name = this.checkName(path + prev.getLabel().getText());
                if (name != null) {
                    prev.setMachineName(name);
                    MachineDataUtils.rename(path + oldName, name);
                } else {
                    prev.getLabel().setText(oldName);
                }
            }
            this.onMachineClicked(prev);
        }));
        this.onMachineClicked(prev);
    }

    private String checkName(String name) {
        if (name.length() == 0) {
            return null;
        }
        String replacedName = name.replaceAll(" ", "_");
        if (MachineDataUtils.load("machine").contains(replacedName)) {
            return this.checkName(replacedName + "_copy");
        }
        return replacedName;
    }

    @Override
    public void onClose() {
        this.threads.shutdown();
    }
}

