/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.system.title;

import java.io.IOException;
import java.util.ArrayList;
import net.comp_lot.craftalos.CraftalosConfig;
import net.comp_lot.craftalos.Main;
import net.comp_lot.craftalos.lang.StringManager;
import net.comp_lot.craftalos.system.client.PlayMode;
import net.comp_lot.craftalos.system.network.SocketConnection;
import net.comp_lot.craftalos.system.network.data.RoomInformation;
import net.comp_lot.craftalos.system.title.RoomConfig;
import net.comp_lot.craftalos.system.title.RoomCreateMenu;
import net.comp_lot.craftalos.system.title.TitleMode;
import net.comp_lot.craftalos.system.title.TitleModeView;
import net.comp_lot.glui.system.DialogBuilder;
import net.comp_lot.glui.system.GameMode;
import net.comp_lot.glui.system.utils.MenuManager;
import net.comp_lot.glui.ui.ButtonLayout;
import net.comp_lot.glui.ui.Label;
import net.comp_lot.glui.ui.TextInput;
import net.comp_lot.ui.core.Component;
import net.comp_lot.ui.core.DisplayInfo;
import net.comp_lot.ui.core.Layout;
import net.comp_lot.ui.layout.ReplaceableFrame;
import net.comp_lot.ui.layout.VerticalLinearLayout;

class FreePlayView
extends TitleModeView {
    private final String fileName;
    private final MenuManager menu;
    private final RoomCreateMenu createMenu;
    private final CraftalosConfig config;

    public FreePlayView(TitleMode context, DisplayInfo display) {
        super(context, display, "free_play_view_layout.xml");
        this.config = (CraftalosConfig)context.getGame().getConfig();
        this.fileName = this.config.getFileName();
        Layout frame = (Layout)this.component.getComponentByName("free-play-frame");
        Label machineNameLabel = (Label)this.component.getComponentByName("machine-name-label");
        machineNameLabel.setText(this.fileName != null ? this.fileName : "not selected");
        this.menu = new MenuManager(display);
        frame.add(this.menu.getComponent());
        this.menu.set(StringManager.lang.titleMenuPath() + "play.md");
        this.menu.set(StringManager.lang.titleMenuPath() + "play.md");
        this.createMenu = new RoomCreateMenu(this.fileName, this.menu, context);
        this.createMenu.init();
        this.setConnectionSettings();
        this.setPlayListeners();
        this.setRoomListListeners();
    }

    private void setConnectionSettings() {
        this.menu.setGetter("$addr", args -> this.config.getLocalAddress());
        this.menu.setListener("$addr", args -> this.context.setActiveComponent(new TextInput(this.menu.getForm("$addr"), () -> this.config.setLocalAddress(this.menu.getForm("$addr").getText()))));
        this.menu.setGetter("$port", args -> String.valueOf(this.config.getLocalPort()));
        this.menu.setListener("$port", args -> this.context.setActiveComponent(new TextInput(this.menu.getForm("$port"), () -> {
            try {
                this.config.setLocalPort(Integer.parseInt(this.menu.getForm("$port").getText()));
            }
            catch (NumberFormatException e) {
                this.menu.getForm("$port").setText(String.valueOf(this.config.getLocalPort()));
            }
        })));
        this.menu.setListener("$room", args -> this.context.setActiveComponent(new TextInput(this.menu.getForm("$room"), () -> {
            Main.room = this.menu.getForm("$room").getText();
        })));
    }

    private void setPlayListeners() {
        this.menu.setListener("single_play", args -> {
            RoomConfig roomConfig = new RoomConfig();
            roomConfig.setMap((String)args.get("map"), (String)args.get("map"));
            roomConfig.setIsPublic("private");
            this.context.setMode(game -> PlayMode.LocalPlay(game, this.fileName, Main.Mode.PLAY, roomConfig, 0));
        });
        this.menu.setListener("local_play", args -> {
            RoomConfig roomConfig = new RoomConfig();
            roomConfig.setMap((String)args.get("map"), (String)args.get("map"));
            roomConfig.setIsPublic("public");
            roomConfig.setPlayerNum("64");
            this.config.save();
            this.context.setMode(game -> PlayMode.LocalPlay(game, this.fileName, Main.Mode.PLAY, roomConfig, this.config.getLocalPort()));
        });
        this.menu.setListener("local_join", args -> {
            Main.room = "auto";
            this.config.save();
            this.context.setMode(game -> PlayMode.ClientPlay(game, this.fileName, this.config.getLocalAddress(), this.config.getLocalPort(), false));
        });
    }

    private void setRoomListListeners() {
        this.menu.setComponentGetter("$room_list_frame", args -> {
            ReplaceableFrame rFrame = new ReplaceableFrame(this.display, new Label(this.display, 32, "Loading..."));
            new Thread(() -> rFrame.replace(this.getRoomList())).start();
            return rFrame;
        });
        this.menu.setListener("room_id_join", args -> {
            MenuManager menu = new MenuManager(this.display);
            DialogBuilder dialog = DialogBuilder.newFreeDialog((GameMode)this.context, menu);
            menu.setListener("$room_id", args2 -> this.context.setActiveComponent(new TextInput(menu.getForm("$room_id"))));
            menu.setListener("ok", args2 -> {
                Main.room = menu.getForm("$room_id").getText();
                this.context.setMode(game -> PlayMode.ClientPlay(game, this.fileName, "craftalos.comp-lot.net", 51525, true));
            });
            menu.setListener("cancel", args2 -> dialog.close());
            menu.set(StringManager.lang.titleMenuPath() + "play_room_id_join.md");
            dialog.show(this.context);
        });
    }

    private Component getRoomList() {
        try {
            SocketConnection connection = SocketConnection.open("craftalos.comp-lot.net", 51525, true);
            connection.oos.writeUTF("lobby \u03b21.5.0");
            connection.oos.flush();
            ArrayList<RoomInformation> rooms = new ArrayList<RoomInformation>();
            while (!connection.ois.readUTF().equals("end")) {
                RoomInformation info = new RoomInformation();
                info.read(connection.ois);
                rooms.add(info);
            }
            if (rooms.size() == 0) {
                return new Label(this.display, 32, StringManager.lang.titleRoomNotFound());
            }
            VerticalLinearLayout layout = new VerticalLinearLayout(this.display);
            rooms.stream().filter(r -> !r.isFull()).forEach(r -> layout.add(this.makeJoinButton((RoomInformation)r)));
            rooms.stream().filter(r -> r.isFull()).forEach(r -> layout.add(this.makeJoinButton((RoomInformation)r)));
            return layout;
        }
        catch (IOException e) {
            e.printStackTrace();
            return new Label(this.display, 32, StringManager.lang.titleRoomListFailed());
        }
    }

    private ButtonLayout makeJoinButton(RoomInformation r) {
        ButtonLayout button = MenuManager.getButton(this.display);
        button.setPaddingLeft(32);
        button.setPaddingRight(32);
        button.add(new Label(this.display, 32, r.toString()));
        button.setClickListener(() -> {
            Main.room = r.getId();
            this.context.setMode(game -> PlayMode.ClientPlay(game, this.fileName, "craftalos.comp-lot.net", 51525, true));
        });
        return button;
    }
}

