/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.system.start;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Queue;
import javax.imageio.ImageIO;
import net.comp_lot.craftalos.system.start.AnimationBlock;
import net.comp_lot.craftalos.system.title.TitleMode;
import net.comp_lot.glui.model.TextureInfo;
import net.comp_lot.glui.sound.SoundEnum;
import net.comp_lot.glui.system.Game;
import net.comp_lot.glui.system.GameMode;
import net.comp_lot.glui.system.OperationEvent;
import net.comp_lot.glui.system.utils.FileUtils;
import net.comp_lot.glui.system.utils.GluiXMLLayoutParser;
import net.comp_lot.glui.system.utils.TexturePacker;
import net.comp_lot.glui.ui.Image;
import net.comp_lot.glui.ui.Label;
import net.comp_lot.ui.core.Component;
import net.comp_lot.ui.core.DisplayInfo;
import net.comp_lot.ui.core.Layout;

public class StartMode
extends GameMode {
    private volatile boolean imageLoaded = false;
    private Runnable setTexture;
    private TexturePacker.TexturePlace current;
    private TexturePacker.TexturePlace myLogo;
    private TexturePacker.TexturePlace gameLogo;
    private TexturePacker.TexturePlace background;
    private final Queue<AnimationBlock> animQueue = new LinkedList<AnimationBlock>();
    private AnimationBlock currentAnim;
    private final Layout logoFrame;
    private final Layout backgroundFrame;
    private Image image;
    private Image backgroundImage;
    private Label label;

    public StartMode(Game game) {
        super(game, 60);
        game.getRenderOptions().setClearColor(0);
        Component layout = new GluiXMLLayoutParser().parseOrElse((DisplayInfo)this.uiDisplay, this.getClass().getResourceAsStream("start_mode_layout.xml"), () -> null);
        this.addUI(layout);
        this.logoFrame = (Layout)layout.getComponentByName("logo-frame");
        this.backgroundFrame = (Layout)layout.getComponentByName("background-frame");
        this.label = (Label)layout.getComponentByName("press-key-label");
        new Thread(() -> this.loadTexture()).run();
        this.setAnim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTexture() {
        try {
            TexturePacker tp = new TexturePacker(8192);
            this.myLogo = tp.add(ImageIO.read(new File(FileUtils.APP_DIR + "res/img/complot.png")));
            this.gameLogo = tp.add(ImageIO.read(new File(FileUtils.APP_DIR + "res/img/craftalos.png")));
            this.background = tp.add(ImageIO.read(new File(FileUtils.APP_DIR + "res/img/background.png")));
            BufferedImage tex = tp.pack();
            StartMode startMode = this;
            synchronized (startMode) {
                this.setTexture = () -> this.getGame().getRenderOptions().setTexture(2, tex, true);
            }
            this.imageLoaded = true;
        }
        catch (IOException e) {
            System.err.println(e.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onFrame() {
        boolean end;
        if (this.imageLoaded) {
            StartMode startMode = this;
            synchronized (startMode) {
                this.setTexture.run();
            }
            this.imageLoaded = false;
            this.backgroundImage = new Image(this.uiDisplay, new TextureInfo(2, this.background.getLeftTopX(), this.background.getLeftTopY(), this.background.getWidth(), this.background.getHeight()));
            this.backgroundFrame.add(this.backgroundImage);
            this.currentAnim = this.animQueue.poll();
        }
        if (this.currentAnim != null && (end = this.currentAnim.frame())) {
            this.currentAnim = !this.animQueue.isEmpty() ? this.animQueue.poll() : null;
        }
        if (this.image != null) {
            double scale = Math.min((double)this.getWidth() * 0.5 / (double)this.current.getWidth(), (double)this.getHeight() * 0.5 / (double)this.current.getHeight());
            this.image.setWidth((int)((double)this.current.getWidth() * scale));
            this.image.setHeight((int)((double)this.current.getHeight() * scale));
            this.label.setMarginTop((int)((double)this.current.getHeight() * scale));
            this.label.setFontSize((int)((double)this.current.getHeight() * scale / 8.0));
        }
        if (this.getKeyDown(OperationEvent.KeyCode.KEY_SPACE) || this.getKeyDown(OperationEvent.KeyCode.MOUSE_LEFT)) {
            this.getGame().getAudioSystem().playSound(SoundEnum.CLICK.getId(), this.getGame().getConfig().getVolumeUi(), false);
            this.setMode(game -> new TitleMode((Game)game));
        }
        this.mainModel.callConfirmCoordinate();
    }

    private void setAnim() {
        this.animQueue.add(new AnimationBlock(90, () -> {
            this.current = this.myLogo;
            this.image = new Image(this.uiDisplay, new TextureInfo(2, this.current.getLeftTopX(), this.current.getLeftTopY(), this.current.getWidth(), this.current.getHeight()));
            this.logoFrame.add(this.image);
        }, t -> this.setImageAlpha((double)t, 0.25)));
        this.animQueue.add(new AnimationBlock(30, () -> this.logoFrame.clear(), t -> {}));
        this.animQueue.add(new AnimationBlock(90, () -> {
            this.current = this.gameLogo;
            this.image = new Image(this.uiDisplay, new TextureInfo(2, this.current.getLeftTopX(), this.current.getLeftTopY(), this.current.getWidth(), this.current.getHeight()));
            this.logoFrame.add(this.image);
        }, t -> this.setImageAlpha((double)t, 0.25)));
        this.animQueue.add(new AnimationBlock(30, () -> this.logoFrame.clear(), t -> {}));
        this.animQueue.add(new AnimationBlock(0, () -> {
            this.image.setColor(-256);
            this.logoFrame.add(this.image);
            this.logoFrame.setMarginBottom((int)((float)this.image.getRect().getHeight() * 0.75f));
            this.label.setVisible(true);
            this.label.setColor(-256);
            this.backgroundFrame.setVisible(true);
            this.backgroundImage.setColor(-256);
        }, t -> {}));
        this.animQueue.add(new AnimationBlock(15, () -> {
            this.image.setColor(-1);
            this.logoFrame.setMarginBottom((int)((float)this.image.getRect().getHeight() * 0.75f));
            this.backgroundImage.setColor(-1);
            this.addButtonAnim();
        }, t -> this.backgroundImage.setColor(0xEEEEEE00 | (int)(255.0 * t))));
    }

    private void addButtonAnim() {
        this.animQueue.add(new AnimationBlock(60, () -> this.addButtonAnim(), t -> {
            this.logoFrame.setMarginBottom((int)((float)this.image.getRect().getHeight() * 0.75f));
            this.label.setColor(0xFFFFFF00 | (int)(255.0 * this.getScale((double)t, 0.25)));
        }));
    }

    private void setImageAlpha(double t, double width) {
        this.image.setColor(0xFFFFFF00 | (int)(255.0 * this.getScale(t, width)));
    }

    private double getScale(double t, double width) {
        if (t < width) {
            return t / width;
        }
        if (1.0 - t < width) {
            return (1.0 - t) / width;
        }
        return 1.0;
    }
}

