/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.system.program.block;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.comp_lot.craftalos.lang.StringManager;
import net.comp_lot.craftalos.system.program.ProgramBlock;
import net.comp_lot.craftalos.system.program.ProgramMode;
import net.comp_lot.ui.core.DisplayInfo;

public class VarBlock
extends ProgramBlock {
    private final ProgramMode editor;

    public VarBlock(DisplayInfo display, ProgramMode editor) {
        super(display, COLOR_VAR, StringManager.lang.programBlockVar(), true, true);
        this.editor = editor;
        this.setValueChecker();
    }

    private void setValueChecker() {
        this.setValueChecker(0, s -> {
            if (this.editor != null && CHECK_IDENT.apply(s) == ProgramBlock.InputState.OK) {
                return this.editor.isVariableDefined(this, (String)s) ? ProgramBlock.InputState.OK : ProgramBlock.InputState.F_ERROR;
            }
            return (ProgramBlock.InputState)((Object)((Object)CHECK_IDENT.apply(s)));
        });
    }

    @Override
    public Function<String, List<String>> getCandidatesFunction(int slot) {
        if (slot != 0 || this.editor == null) {
            return super.getCandidatesFunction(slot);
        }
        Collection<String> idents = this.editor.getDefinedVariables(this);
        return s -> {
            String su = s.toUpperCase(Locale.ENGLISH);
            return idents.stream().filter(i -> i.toUpperCase(Locale.ENGLISH).startsWith(su)).sorted().collect(Collectors.toList());
        };
    }

    @Override
    public String getCode() {
        return this.getOptionValue(0);
    }

    @Override
    protected boolean requireParentheses() {
        return false;
    }
}

