/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.system.program.block;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import net.comp_lot.craftalos.lang.StringManager;
import net.comp_lot.craftalos.program.compiler.CompileException;
import net.comp_lot.craftalos.program.compiler.ProgramCompiler;
import net.comp_lot.craftalos.program.node.TopNode;
import net.comp_lot.craftalos.system.program.FunctionInfo;
import net.comp_lot.craftalos.system.program.ProgramBlock;
import net.comp_lot.craftalos.system.program.ProgramMode;
import net.comp_lot.glui.system.utils.FileUtils;
import net.comp_lot.ui.core.DisplayInfo;

public class IncludeBlock
extends ProgramBlock {
    private final ProgramMode editer;
    private final Set<String> variables = new HashSet<String>();
    private final Set<String> arrays = new HashSet<String>();
    private String name = "";
    private TopNode program = null;

    public IncludeBlock(DisplayInfo display, ProgramMode editor) {
        super(display, COLOR_OTHER, StringManager.lang.programBlockInclude(), false, false);
        this.editer = editor;
        this.setValueChecker(0, s -> {
            boolean exists;
            this.program = null;
            boolean bl = exists = s.matches("[a-zA-Z0-9_/\\.]+\\.bcp") && new File((String)s).exists();
            if (editor != null && !this.name.equals(s)) {
                this.onRemoved();
                this.name = s;
                if (exists) {
                    this.loadProgram();
                    this.putInclude();
                }
                this.loadVariables();
            }
            return exists ? ProgramBlock.InputState.OK : (s.matches("[a-zA-Z0-9_/\\.]+") ? ProgramBlock.InputState.F_ERROR : ProgramBlock.InputState.L_ERROR);
        });
    }

    private void loadProgram() {
        try {
            String source = FileUtils.loadFile(this.name);
            this.program = ProgramCompiler.compile(source).getTopNode();
        }
        catch (FileNotFoundException | CompileException exception) {
            // empty catch block
        }
    }

    private void loadVariables() {
        this.variables.clear();
        this.arrays.clear();
        if (this.program != null) {
            this.program.getVariables().forEach(v -> {
                boolean bl = this.variables.add(v.getIdent());
            });
            this.program.getArrays().forEach(v -> {
                boolean bl = this.arrays.add(v.getIdent());
            });
        }
    }

    private void putInclude() {
        this.editer.getFunctions().addInclude(this.name);
        this.getFunctions().forEach(f -> this.editer.getFunctions().putFunction((FunctionInfo.Function)f));
    }

    @Override
    public void onRemoved() {
        this.editer.getFunctions().removeInclude(this.name);
        if (!this.editer.getFunctions().isIncluded(this.name)) {
            this.getFunctions().forEach(f -> this.editer.getFunctions().removeFunction(f.getIdent()));
        }
        this.name = "";
    }

    private Stream<FunctionInfo.Function> getFunctions() {
        if (this.program != null) {
            return this.program.getFunctions().stream().map(f -> {
                String[] args = f.getArgumentsNames();
                return new FunctionInfo.Function(f.getIdent(), args);
            });
        }
        return Stream.empty();
    }

    @Override
    public void addDefinedVariables(Set<String> set) {
        set.addAll(this.variables);
    }

    @Override
    public void addDefinedArrays(Set<String> set) {
        set.addAll(this.arrays);
    }

    @Override
    public String getCode() {
        return "#include \"" + this.getOptionValue(0) + "\"";
    }

    @Override
    public boolean isTopLevel() {
        return true;
    }

    @Override
    public boolean isInFunction() {
        return false;
    }
}

