/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.system.program.block;

import java.util.Set;
import net.comp_lot.craftalos.lang.StringManager;
import net.comp_lot.craftalos.system.program.FunctionInfo;
import net.comp_lot.craftalos.system.program.ProgramBlock;
import net.comp_lot.craftalos.system.program.ProgramMode;
import net.comp_lot.craftalos.system.program.block.BlockOpenBlock;
import net.comp_lot.ui.core.DisplayInfo;

public class FunDecBlock
extends BlockOpenBlock {
    private final ProgramMode editer;
    private int argNum = 0;
    private String ident = "";

    public FunDecBlock(DisplayInfo display, ProgramMode editer) {
        super(display, COLOR_FUN, StringManager.lang.programBlockFunDec(""));
        this.editer = editer;
        this.setValueChecker();
    }

    private void setValueChecker() {
        this.setValueChecker(0, s -> {
            if (this.editer != null) {
                this.editer.getFunctions().removeFunction(this.ident);
            }
            this.ident = s;
            this.putFunctionInfo();
            return (ProgramBlock.InputState)((Object)((Object)CHECK_IDENT.apply(s)));
        });
        this.setValueChecker(1, s -> {
            try {
                int num = Integer.parseInt(s);
                if (num != this.argNum) {
                    this.argNum = num;
                    StringBuilder args = new StringBuilder();
                    if (num > 0) {
                        args.append(' ');
                        int i = 0;
                        while (i < num) {
                            args.append("$8s ");
                            ++i;
                        }
                    }
                    this.setLabel(StringManager.lang.programBlockFunDec(args.toString()));
                    this.setValueChecker();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return (ProgramBlock.InputState)((Object)((Object)CHECK_INTEGER.apply(s)));
        });
        int i = 0;
        while (i < this.argNum) {
            this.setValueChecker(2 + i, s -> {
                this.putFunctionInfo();
                return (ProgramBlock.InputState)((Object)((Object)CHECK_IDENT.apply(s)));
            });
            ++i;
        }
    }

    private void putFunctionInfo() {
        if (this.editer != null) {
            String[] args = new String[this.argNum];
            int i = 0;
            while (i < this.argNum) {
                args[i] = this.getValue(2 + i);
                ++i;
            }
            this.editer.getFunctions().putFunction(new FunctionInfo.Function(this.ident, args));
        }
    }

    @Override
    public void onRemoved() {
        this.editer.getFunctions().removeFunction(this.getValue(0));
    }

    @Override
    public void setVerticalMargin(boolean zero) {
        super.setVerticalMargin(zero);
        if (!zero) {
            this.getComponent().setMarginTop(24);
        }
    }

    @Override
    public String getCode() {
        Object argStr = "";
        try {
            if (this.argNum > 0) {
                argStr = "float " + this.getOptionValue(2);
                int i = 1;
                while (i < this.argNum) {
                    argStr = (String)argStr + ", float " + this.getOptionValue(2 + i);
                    ++i;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return "\nfloat " + this.getOptionValue(0) + "(" + (String)argStr + ") {";
    }

    @Override
    public boolean isTopLevel() {
        return true;
    }

    @Override
    public boolean isInFunction() {
        return false;
    }

    @Override
    public void addDefinedVariables(Set<String> set) {
        int i = 0;
        while (i < this.argNum) {
            set.add(this.getOptionValue(2 + i));
            ++i;
        }
    }
}

