/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.system.program.block;

import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.comp_lot.craftalos.lang.StringManager;
import net.comp_lot.craftalos.system.program.FunctionInfo;
import net.comp_lot.craftalos.system.program.ProgramBlock;
import net.comp_lot.craftalos.system.program.ProgramMode;
import net.comp_lot.ui.core.DisplayInfo;

public class FunBlock
extends ProgramBlock {
    private final ProgramMode editor;
    private FunctionInfo.Function function;
    private int argNum = 0;

    public FunBlock(DisplayInfo display, ProgramMode editor) {
        super(display, COLOR_FUN, StringManager.lang.programBlockFun("$4f "), true, true);
        this.editor = editor;
        this.function = editor != null ? editor.getFunctions().getFunctionInfo("") : null;
        this.setValueChecker();
    }

    private void setValueChecker() {
        this.setValueChecker(0, s -> {
            if (this.editor != null) {
                FunctionInfo.Function f = this.editor.getFunctions().getFunctionInfo((String)s);
                if (!f.equals(this.function)) {
                    this.function = f;
                    this.setArgs(f.getArgs());
                }
                if (!f.equals(this.editor.getFunctions().getFunctionInfo(""))) {
                    return f.getArgs().length != this.argNum ? ProgramBlock.InputState.F_ERROR : ProgramBlock.InputState.OK;
                }
                return CHECK_IDENT.apply(s) == ProgramBlock.InputState.L_ERROR ? ProgramBlock.InputState.L_ERROR : ProgramBlock.InputState.F_ERROR;
            }
            return (ProgramBlock.InputState)((Object)((Object)CHECK_IDENT.apply(s)));
        });
    }

    @Override
    public Function<String, List<String>> getCandidatesFunction(int slot) {
        if (slot != 0 || this.editor == null) {
            return super.getCandidatesFunction(slot);
        }
        return s -> {
            String su = s.toUpperCase(Locale.ENGLISH);
            return this.editor.getFunctions().getFunctions().stream().map(f -> f.getIdent()).filter(i -> !i.startsWith("_")).filter(i -> i.toUpperCase(Locale.ENGLISH).startsWith(su)).sorted().collect(Collectors.toList());
        };
    }

    private void setArgs(String[] args) {
        this.argNum = args.length;
        if (args.length == 0) {
            this.setLabel(StringManager.lang.programBlockFun());
        } else {
            StringBuilder label = new StringBuilder();
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                label.append(arg);
                label.append(": $4f ");
                ++n2;
            }
            this.setLabel(StringManager.lang.programBlockFun(label.toString()));
        }
        this.setValueChecker();
    }

    public void setArgsNum(int num) {
        if (this.argNum == num) {
            return;
        }
        String[] args = new String[num];
        int i = 0;
        while (i < num) {
            args[i] = "";
            ++i;
        }
        this.setArgs(args);
        if (this.editor != null) {
            this.setCheckState(0, ProgramBlock.InputState.F_ERROR);
        }
    }

    @Override
    public String getCode() {
        Object argStr = "";
        if (this.argNum > 0) {
            argStr = this.getOptionValue(1);
            int i = 1;
            while (i < this.argNum) {
                argStr = (String)argStr + ", " + this.getOptionValue(1 + i);
                ++i;
            }
        }
        return this.getOptionValue(0) + "(" + (String)argStr + ")";
    }

    @Override
    protected boolean requireParentheses() {
        return false;
    }
}

