/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.system.program;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import net.comp_lot.craftalos.system.program.ProgramBlock;

public class VariableResolver {
    private final List<ProgramBlock> code;

    public VariableResolver(List<ProgramBlock> code) {
        this.code = code;
    }

    public Collection<String> getDefinedVariables(int line) {
        return this.getDefinedIdents(line, (b, s) -> b.addDefinedVariables((Set<String>)s));
    }

    public Collection<String> getDefinedArrays(int line) {
        return this.getDefinedIdents(line, (b, s) -> b.addDefinedArrays((Set<String>)s));
    }

    private Collection<String> getDefinedIdents(int line, BiConsumer<ProgramBlock, Set<String>> f) {
        HashSet<String> idents = new HashSet<String>();
        int i = line - 1;
        while (i >= 0) {
            ProgramBlock block = this.code.get(i);
            if (block.getLink() != null) {
                ProgramBlock link = block;
                while ((link = link.getLink()) != block) {
                    int index = this.code.indexOf(link);
                    if (index < 0) continue;
                    i = Math.min(i, index);
                }
                block = this.code.get(i);
            }
            f.accept(block, idents);
            --i;
        }
        return idents;
    }
}

