/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.system.program;

import java.util.ArrayList;
import java.util.List;
import net.comp_lot.craftalos.system.program.BlockTextInput;
import net.comp_lot.craftalos.system.program.ProgramBlock;
import net.comp_lot.craftalos.system.program.VariableResolver;
import net.comp_lot.glui.ui.Label;
import net.comp_lot.ui.core.Component;
import net.comp_lot.ui.core.DisplayInfo;
import net.comp_lot.ui.layout.VerticalLinearLayout;

class ProgramView {
    private final VerticalLinearLayout view;
    private final List<ProgramBlock> list = new ArrayList<ProgramBlock>();
    private final boolean checkLevel;
    private final Label dropPlace;
    private ProgramBlock dropBlock = null;
    private int dropIndex = -1;

    ProgramView(DisplayInfo display, boolean checkLevel) {
        this.view = new VerticalLinearLayout(display, 0);
        this.view.setAlign(VerticalLinearLayout.LEFT);
        this.view.setPadding(8);
        this.view.setPaddingBottom(48);
        this.dropPlace = new Label(display, 32, "");
        this.dropPlace.setBackground(ProgramBlock.COLOR_INPUT_ACTIVE.code());
        this.checkLevel = checkLevel;
    }

    Component getComponent() {
        return this.view;
    }

    VariableResolver getVariables() {
        return new VariableResolver(this.list);
    }

    public ProgramBlock[] pickBlock(Component c, boolean pick) {
        int index = this.findIndexByComponent(c);
        if (index >= 0) {
            int start = index;
            int end = index;
            if (this.list.get(index).getLink() != null) {
                int j = index;
                do {
                    start = Math.min(start, j);
                    end = Math.max(end, j);
                } while ((j = this.list.indexOf(this.list.get(j).getLink())) != index);
            }
            return this.pickBlock(start, ++end, pick);
        }
        for (ProgramBlock block : this.list) {
            ProgramBlock rtn = block.pickBlock(c, pick);
            if (rtn == null) continue;
            return new ProgramBlock[]{rtn};
        }
        return null;
    }

    private int findIndexByComponent(Component c) {
        int i = 0;
        while (i < this.list.size()) {
            if (this.list.get(i).getComponent() == c) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public ProgramBlock[] pickBlock(int start, int end, boolean pick) {
        ProgramBlock[] rtn = this.list.subList(start, end).toArray(new ProgramBlock[end - start]);
        if (pick) {
            this.list.removeAll(this.list.subList(start, end));
            ProgramBlock[] programBlockArray = rtn;
            int n = rtn.length;
            int n2 = 0;
            while (n2 < n) {
                ProgramBlock b = programBlockArray[n2];
                b.setVerticalMargin(true);
                this.view.remove(b.getComponent());
                ++n2;
            }
            this.dropIndex = start;
            this.view.add(this.dropIndex, this.dropPlace);
        }
        return rtn;
    }

    public void dropBlock(ProgramBlock[] blocks, int x, int y, boolean drop, boolean inView) {
        if (this.dropBlock != null) {
            this.dropBlock.check();
            this.dropBlock = null;
        }
        this.resetDropPlace();
        if (inView) {
            if (blocks.length == 1 && blocks[0].hasValue()) {
                for (ProgramBlock block : this.list) {
                    if (!block.dropBlock(blocks[0], x, y, drop)) continue;
                    if (!drop) {
                        this.dropBlock = block;
                        Label dropLabel = (Label)this.view.getClickedComponent(x, y);
                        dropLabel.setBackground(ProgramBlock.COLOR_INPUT_ACTIVE.code());
                    }
                    return;
                }
            }
            int i = 0;
            while (i < this.list.size() && this.list.get(i).getComponent().getRect().getY() + this.list.get(i).getComponent().getRect().getHeight() / 2 < y) {
                ++i;
            }
            if (drop) {
                this.addBlocks(i, true, blocks);
            } else if (this.addBlocks(i, false, blocks)) {
                this.dropIndex = i;
                this.view.add(this.dropIndex, this.dropPlace);
            }
        }
    }

    public void resetDropPlace() {
        if (this.dropIndex >= 0) {
            this.view.remove(this.dropIndex);
            this.dropIndex = -1;
        }
    }

    public ProgramBlock findBlockByLabel(Component c) {
        for (ProgramBlock block : this.list) {
            ProgramBlock rtn = block.pickBlock(c, false);
            if (rtn == null) continue;
            return rtn;
        }
        return null;
    }

    public void clear() {
        this.view.clear();
        this.list.clear();
    }

    public void addBlock(ProgramBlock block) {
        this.addBlock(this.list.size(), block);
    }

    private void addBlock(int index, ProgramBlock block) {
        if (index > 0) {
            block.setIndent(this.list.get(index - 1).getNextIndent());
        }
        block.setVerticalMargin(false);
        this.list.add(index, block);
        this.view.add(index, block.getComponent());
        block.check();
    }

    public boolean addBlocks(int start, boolean add, ProgramBlock ... blocks) {
        int indent;
        int n = indent = start > 0 ? this.list.get(start - 1).getNextIndent() : 0;
        if (this.checkLevel && indent == 0 && !blocks[0].isTopLevel()) {
            return false;
        }
        if (indent > 0 && !blocks[0].isInFunction()) {
            return false;
        }
        if (add) {
            int i = 0;
            while (i < blocks.length) {
                this.addBlock(start + i, blocks[i]);
                ++i;
            }
        }
        return true;
    }

    public int findLine(ProgramBlock block) {
        int i = 0;
        while (i < this.list.size()) {
            if (this.list.get(i).isDescendant(block)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String makeCode() {
        StringBuilder sb = new StringBuilder();
        for (ProgramBlock b : this.list) {
            int i = 0;
            while (i < b.getIndent()) {
                sb.append('\t');
                ++i;
            }
            sb.append(b.getCodeAsSentence());
            sb.append('\n');
        }
        return sb.toString();
    }

    public int getSize() {
        return this.list.size();
    }

    public BlockTextInput getNextInput(Label c) {
        int i = 0;
        while (i < this.list.size()) {
            ProgramBlock pb = this.list.get(i).pickBlock(c, false);
            if (pb != null) {
                BlockTextInput rtn = this.list.get(i).nextSlot(c);
                if (rtn != null) {
                    return rtn;
                }
                int j = i + 1;
                while (true) {
                    if ((rtn = this.list.get(j %= this.list.size()).firstSlot(0)) != null) {
                        return rtn;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    public BlockTextInput getPrevInput(Label c) {
        int i = 0;
        while (i < this.list.size()) {
            ProgramBlock pb = this.list.get(i).pickBlock(c, false);
            if (pb != null) {
                BlockTextInput rtn = this.list.get(i).prevSlot(c);
                if (rtn != null) {
                    return rtn;
                }
                int j = i - 1;
                while (true) {
                    if ((rtn = this.list.get(j = (j + this.list.size()) % this.list.size()).lastSlot(this.list.get(j).getSlotNumber() - 1)) != null) {
                        return rtn;
                    }
                    --j;
                }
            }
            ++i;
        }
        return null;
    }
}

