/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.system.program;

import java.util.HashMap;
import java.util.Map;
import net.comp_lot.craftalos.lang.StringManager;
import net.comp_lot.craftalos.system.program.ProgramBlock;
import net.comp_lot.craftalos.system.program.ProgramMode;
import net.comp_lot.craftalos.system.program.block.AddBlock;
import net.comp_lot.craftalos.system.program.block.AndBlock;
import net.comp_lot.craftalos.system.program.block.AryBlock;
import net.comp_lot.craftalos.system.program.block.AryDecBlock;
import net.comp_lot.craftalos.system.program.block.ArySetBlock;
import net.comp_lot.craftalos.system.program.block.BlockCloseBlock;
import net.comp_lot.craftalos.system.program.block.DivBlock;
import net.comp_lot.craftalos.system.program.block.ElseBlock;
import net.comp_lot.craftalos.system.program.block.EqBlock;
import net.comp_lot.craftalos.system.program.block.FAxisBlock;
import net.comp_lot.craftalos.system.program.block.FGetBlock;
import net.comp_lot.craftalos.system.program.block.FKeyBlock;
import net.comp_lot.craftalos.system.program.block.FKeyDownBlock;
import net.comp_lot.craftalos.system.program.block.FSetBlock;
import net.comp_lot.craftalos.system.program.block.FunBlock;
import net.comp_lot.craftalos.system.program.block.FunDecBlock;
import net.comp_lot.craftalos.system.program.block.FunReturnBlock;
import net.comp_lot.craftalos.system.program.block.IfBlock;
import net.comp_lot.craftalos.system.program.block.IncludeBlock;
import net.comp_lot.craftalos.system.program.block.LsBlock;
import net.comp_lot.craftalos.system.program.block.LseBlock;
import net.comp_lot.craftalos.system.program.block.MulBlock;
import net.comp_lot.craftalos.system.program.block.NeqBlock;
import net.comp_lot.craftalos.system.program.block.NotBlock;
import net.comp_lot.craftalos.system.program.block.OrBlock;
import net.comp_lot.craftalos.system.program.block.SubBlock;
import net.comp_lot.craftalos.system.program.block.VarBlock;
import net.comp_lot.craftalos.system.program.block.VarDecSetBlock;
import net.comp_lot.craftalos.system.program.block.VarSetBlock;
import net.comp_lot.craftalos.system.program.block.WhileBlock;
import net.comp_lot.glui.ui.Background;
import net.comp_lot.glui.ui.Label;
import net.comp_lot.glui.ui.UIColor;
import net.comp_lot.ui.core.Component;
import net.comp_lot.ui.core.DisplayInfo;
import net.comp_lot.ui.layout.GravityLeftLayout;
import net.comp_lot.ui.layout.HorizontalLinearLayout;
import net.comp_lot.ui.layout.VerticalLinearLayout;

class ProgramPalette {
    private final Map<Component, BlockMaker> makers = new HashMap<Component, BlockMaker>();
    private final ProgramMode editor;

    ProgramPalette(ProgramMode editer) {
        this.editor = editer;
    }

    BlockMaker getMaker(Component c) {
        return this.makers.get(c);
    }

    Component makePalette(DisplayInfo display) {
        VerticalLinearLayout layout = new VerticalLinearLayout(display, 10);
        layout.setPadding(8);
        layout.setAlign(VerticalLinearLayout.LEFT);
        layout.add(ProgramPalette.makeLabel(display, StringManager.lang.programCategoryOutput(), UIColor.BLUE));
        VerticalLinearLayout setLayout = new VerticalLinearLayout(display, 15);
        setLayout.setAlign(VerticalLinearLayout.LEFT);
        setLayout.setMarginLeft(10);
        layout.add(setLayout);
        FSetBlock fSetBlock = new FSetBlock(display, null);
        setLayout.add(fSetBlock.getComponent());
        this.makers.put(fSetBlock.getComponent(), () -> new ProgramBlock[]{new FSetBlock(display, this.editor)});
        layout.add(ProgramPalette.makeLabel(display, StringManager.lang.programCategoryInput(), UIColor.GREEN_BLUE));
        VerticalLinearLayout getLayout = new VerticalLinearLayout(display, 15);
        getLayout.setAlign(VerticalLinearLayout.LEFT);
        getLayout.setMarginLeft(10);
        layout.add(getLayout);
        FGetBlock fGetBlock = new FGetBlock(display, null);
        getLayout.add(fGetBlock.getComponent());
        this.makers.put(fGetBlock.getComponent(), () -> new ProgramBlock[]{new FGetBlock(display, this.editor)});
        FKeyBlock fKeyBlock = new FKeyBlock(display, null);
        getLayout.add(fKeyBlock.getComponent());
        this.makers.put(fKeyBlock.getComponent(), () -> new ProgramBlock[]{new FKeyBlock(display, this.editor)});
        FKeyDownBlock fKeyDownBlock = new FKeyDownBlock(display, null);
        getLayout.add(fKeyDownBlock.getComponent());
        this.makers.put(fKeyDownBlock.getComponent(), () -> new ProgramBlock[]{new FKeyDownBlock(display, this.editor)});
        FAxisBlock fAxisBlock = new FAxisBlock(display, null);
        getLayout.add(fAxisBlock.getComponent());
        this.makers.put(fAxisBlock.getComponent(), () -> new ProgramBlock[]{new FAxisBlock(display, this.editor)});
        layout.add(ProgramPalette.makeLabel(display, StringManager.lang.programCategoryControl(), UIColor.BRIGHT_YELLOW));
        VerticalLinearLayout ctrlLayout = new VerticalLinearLayout(display, 15);
        ctrlLayout.setAlign(VerticalLinearLayout.LEFT);
        ctrlLayout.setMarginLeft(10);
        layout.add(ctrlLayout);
        IfBlock ifBlock = new IfBlock(display);
        ctrlLayout.add(ifBlock.getComponent());
        this.makers.put(ifBlock.getComponent(), () -> new ProgramBlock[]{new IfBlock(display), new BlockCloseBlock(display)});
        VerticalLinearLayout ifElseLayout = new VerticalLinearLayout(display, 0);
        ctrlLayout.add(ifElseLayout);
        IfBlock ifBlock2 = new IfBlock(display);
        ifElseLayout.add(new GravityLeftLayout(display, ifBlock2.getComponent()));
        this.makers.put(ifBlock2.getComponent(), () -> new ProgramBlock[]{new IfBlock(display), new ElseBlock(display), new BlockCloseBlock(display)});
        ElseBlock elseBlock = new ElseBlock(display);
        ifElseLayout.add(elseBlock.getComponent());
        this.makers.put(elseBlock.getComponent(), () -> new ProgramBlock[]{new IfBlock(display), new ElseBlock(display), new BlockCloseBlock(display)});
        WhileBlock whileBlock = new WhileBlock(display);
        ctrlLayout.add(whileBlock.getComponent());
        this.makers.put(whileBlock.getComponent(), () -> new ProgramBlock[]{new WhileBlock(display), new BlockCloseBlock(display)});
        layout.add(ProgramPalette.makeLabel(display, StringManager.lang.programCategoryCalculation(), UIColor.GREEN));
        VerticalLinearLayout calcLayout = new VerticalLinearLayout(display, 15);
        calcLayout.setAlign(VerticalLinearLayout.LEFT);
        calcLayout.setMarginLeft(10);
        layout.add(calcLayout);
        AddBlock addBlock = new AddBlock(display);
        calcLayout.add(addBlock.getComponent());
        this.makers.put(addBlock.getComponent(), () -> new ProgramBlock[]{new AddBlock(display)});
        SubBlock subBlock = new SubBlock(display);
        calcLayout.add(subBlock.getComponent());
        this.makers.put(subBlock.getComponent(), () -> new ProgramBlock[]{new SubBlock(display)});
        MulBlock mulBlock = new MulBlock(display);
        calcLayout.add(mulBlock.getComponent());
        this.makers.put(mulBlock.getComponent(), () -> new ProgramBlock[]{new MulBlock(display)});
        DivBlock divBlock = new DivBlock(display);
        calcLayout.add(divBlock.getComponent());
        this.makers.put(divBlock.getComponent(), () -> new ProgramBlock[]{new DivBlock(display)});
        LsBlock lsBlock = new LsBlock(display);
        calcLayout.add(lsBlock.getComponent());
        this.makers.put(lsBlock.getComponent(), () -> new ProgramBlock[]{new LsBlock(display)});
        LseBlock lseBlock = new LseBlock(display);
        calcLayout.add(lseBlock.getComponent());
        this.makers.put(lseBlock.getComponent(), () -> new ProgramBlock[]{new LseBlock(display)});
        EqBlock eqBlock = new EqBlock(display);
        calcLayout.add(eqBlock.getComponent());
        this.makers.put(eqBlock.getComponent(), () -> new ProgramBlock[]{new EqBlock(display)});
        NeqBlock neqBlock = new NeqBlock(display);
        calcLayout.add(neqBlock.getComponent());
        this.makers.put(neqBlock.getComponent(), () -> new ProgramBlock[]{new NeqBlock(display)});
        AndBlock andBlock = new AndBlock(display);
        calcLayout.add(andBlock.getComponent());
        this.makers.put(andBlock.getComponent(), () -> new ProgramBlock[]{new AndBlock(display)});
        OrBlock orBlock = new OrBlock(display);
        calcLayout.add(orBlock.getComponent());
        this.makers.put(orBlock.getComponent(), () -> new ProgramBlock[]{new OrBlock(display)});
        NotBlock notBlock = new NotBlock(display);
        calcLayout.add(notBlock.getComponent());
        this.makers.put(notBlock.getComponent(), () -> new ProgramBlock[]{new NotBlock(display)});
        layout.add(ProgramPalette.makeLabel(display, StringManager.lang.programCategoryVariable(), UIColor.ORANGE));
        VerticalLinearLayout varLayout = new VerticalLinearLayout(display, 15);
        varLayout.setAlign(VerticalLinearLayout.LEFT);
        varLayout.setMarginLeft(10);
        layout.add(varLayout);
        VarDecSetBlock varDecSetBlock = new VarDecSetBlock(display);
        varLayout.add(varDecSetBlock.getComponent());
        this.makers.put(varDecSetBlock.getComponent(), () -> new ProgramBlock[]{new VarDecSetBlock(display)});
        VarSetBlock varSetBlock = new VarSetBlock(display, null);
        varLayout.add(varSetBlock.getComponent());
        this.makers.put(varSetBlock.getComponent(), () -> new ProgramBlock[]{new VarSetBlock(display, this.editor)});
        VarBlock varBlock = new VarBlock(display, null);
        varLayout.add(varBlock.getComponent());
        this.makers.put(varBlock.getComponent(), () -> new ProgramBlock[]{new VarBlock(display, this.editor)});
        AryDecBlock aryDecBlock = new AryDecBlock(display);
        varLayout.add(aryDecBlock.getComponent());
        this.makers.put(aryDecBlock.getComponent(), () -> new ProgramBlock[]{new AryDecBlock(display)});
        ArySetBlock arySetBlock = new ArySetBlock(display, null);
        varLayout.add(arySetBlock.getComponent());
        this.makers.put(arySetBlock.getComponent(), () -> new ProgramBlock[]{new ArySetBlock(display, this.editor)});
        AryBlock aryBlock = new AryBlock(display, null);
        varLayout.add(aryBlock.getComponent());
        this.makers.put(aryBlock.getComponent(), () -> new ProgramBlock[]{new AryBlock(display, this.editor)});
        layout.add(ProgramPalette.makeLabel(display, StringManager.lang.programCategoryFunction(), UIColor.PINK));
        VerticalLinearLayout funcLayout = new VerticalLinearLayout(display, 15);
        funcLayout.setAlign(VerticalLinearLayout.LEFT);
        funcLayout.setMarginLeft(10);
        layout.add(funcLayout);
        FunDecBlock funDecBlock = new FunDecBlock(display, null);
        funcLayout.add(funDecBlock.getComponent());
        this.makers.put(funDecBlock.getComponent(), () -> new ProgramBlock[]{new FunDecBlock(display, this.editor), new BlockCloseBlock(display, ProgramBlock.COLOR_FUN, "}")});
        funDecBlock.getComponent().setMargin(0);
        FunBlock funBlock = new FunBlock(display, null);
        funcLayout.add(funBlock.getComponent());
        this.makers.put(funBlock.getComponent(), () -> new ProgramBlock[]{new FunBlock(display, this.editor)});
        FunReturnBlock funReturnBlock = new FunReturnBlock(display);
        funcLayout.add(funReturnBlock.getComponent());
        this.makers.put(funReturnBlock.getComponent(), () -> new ProgramBlock[]{new FunReturnBlock(display)});
        layout.add(ProgramPalette.makeLabel(display, StringManager.lang.programCategoryOther(), UIColor.GRAY));
        VerticalLinearLayout otherLayout = new VerticalLinearLayout(display, 15);
        otherLayout.setAlign(VerticalLinearLayout.LEFT);
        otherLayout.setMarginLeft(10);
        layout.add(otherLayout);
        IncludeBlock includeBlock = new IncludeBlock(display, null);
        otherLayout.add(includeBlock.getComponent());
        this.makers.put(includeBlock.getComponent(), () -> new ProgramBlock[]{new IncludeBlock(display, this.editor)});
        return layout;
    }

    private static Component makeLabel(DisplayInfo display, String text, UIColor color) {
        HorizontalLinearLayout layout = new HorizontalLinearLayout(display, 0);
        layout.setMarginTop(10);
        Label label = new Label(display, 20, text);
        label.setBackground(UIColor.DARK_GRAY.code());
        label.setPaddingLeft(30);
        label.setPaddingRight(30);
        Background c = new Background(display, color, UIColor.NONE, 0);
        c.setMinWidth(10);
        layout.add(c);
        layout.add(label);
        return layout;
    }

    static interface BlockMaker {
        public ProgramBlock[] make();
    }
}

