/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.system.program;

import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.comp_lot.craftalos.Main;
import net.comp_lot.craftalos.game.Machine;
import net.comp_lot.craftalos.game.TextureEnum;
import net.comp_lot.craftalos.lang.StringManager;
import net.comp_lot.craftalos.program.compiler.CompileException;
import net.comp_lot.craftalos.program.compiler.MachineCompiler;
import net.comp_lot.craftalos.program.compiler.ProgramCompiler;
import net.comp_lot.craftalos.program.node.TopNode;
import net.comp_lot.craftalos.system.EditHistory;
import net.comp_lot.craftalos.system.EditableMode;
import net.comp_lot.craftalos.system.program.BlockTextInput;
import net.comp_lot.craftalos.system.program.FunctionInfo;
import net.comp_lot.craftalos.system.program.ProgramBlock;
import net.comp_lot.craftalos.system.program.ProgramPalette;
import net.comp_lot.craftalos.system.program.ProgramView;
import net.comp_lot.craftalos.system.program.VariableResolver;
import net.comp_lot.glui.system.DialogBuilder;
import net.comp_lot.glui.system.Game;
import net.comp_lot.glui.system.OperationEvent;
import net.comp_lot.glui.system.utils.FileUtils;
import net.comp_lot.glui.system.utils.GluiXMLLayoutParser;
import net.comp_lot.glui.system.utils.MenuManager;
import net.comp_lot.glui.ui.Background;
import net.comp_lot.glui.ui.ButtonLayout;
import net.comp_lot.glui.ui.GetKeyComponent;
import net.comp_lot.glui.ui.Image;
import net.comp_lot.glui.ui.Label;
import net.comp_lot.glui.ui.UIColor;
import net.comp_lot.ui.core.ClickListener;
import net.comp_lot.ui.core.Component;
import net.comp_lot.ui.core.DisplayInfo;
import net.comp_lot.ui.core.Layout;
import net.comp_lot.ui.layout.AbsoluteLayout;
import net.comp_lot.ui.layout.ScrollLayout;
import net.comp_lot.ui.layout.VerticalLinearLayout;

public class ProgramMode
extends EditableMode {
    private final ProgramPalette palette = new ProgramPalette(this);
    private final ProgramView programView = new ProgramView(this.uiDisplay, true);
    private final FunctionInfo functions = new FunctionInfo();
    private final VariableResolver variables = this.programView.getVariables();
    private final Set<String> blockIdents = new HashSet<String>();
    private final Layout layout;
    private final ScrollLayout paletteScroll;
    private final ScrollLayout programScroll;
    private final EditHistory<String> hist;
    private String savedState;
    private BlockTextInput textInput;
    private final AbsoluteLayout overlay;
    private final VerticalLinearLayout draggingBlockComponents;
    private ProgramBlock[] draggingBlocks;
    private ScrollLayout draggingScroll;
    private final ButtonLayout bagButton;
    private final Layout bagFrame;
    private final ScrollLayout bagScroll;
    private final ProgramView bagView = new ProgramView(this.uiDisplay, false);
    private boolean bagOpen = false;
    private final Layout bagImageFrame;
    private final Component bagImageClose;
    private final Component bagImageOpen;
    private final Layout gabageView;
    private final Layout gabageImageFrame;
    private final Component gabageImageClose;
    private final Component gabageImageOpen;

    public ProgramMode(Game game, String fileName) {
        super(game, true, Main.Mode.PROGRAM, fileName);
        this.showPointer(true);
        this.layout = (Layout)new GluiXMLLayoutParser().parseOrElse((DisplayInfo)this.uiDisplay, this.getClass().getResourceAsStream("program_mode_layout.xml"), () -> null);
        this.addUI(0, this.layout);
        this.overlay = this.uiDisplay.getOverlayLayout();
        this.draggingBlockComponents = new VerticalLinearLayout(this.uiDisplay);
        this.draggingBlockComponents.setAlign(VerticalLinearLayout.LEFT);
        this.overlay.add(this.draggingBlockComponents);
        this.paletteScroll = (ScrollLayout)this.layout.getComponentByName("palette-scroll");
        this.programScroll = (ScrollLayout)this.layout.getComponentByName("program-scroll");
        this.bagButton = (ButtonLayout)this.layout.getComponentByName("bag-button");
        this.bagFrame = (Layout)this.layout.getComponentByName("bag-frame");
        this.bagScroll = (ScrollLayout)this.layout.getComponentByName("bag-scroll");
        this.bagImageFrame = (Layout)this.layout.getComponentByName("bag-image");
        this.gabageView = (Layout)this.layout.getComponentByName("gabage-frame");
        this.gabageImageFrame = (Layout)this.layout.getComponentByName("gabage-image");
        this.paletteScroll.add(this.palette.makePalette(this.uiDisplay));
        this.paletteScroll.setClickListener(new ClickListener());
        this.paletteScroll.setBackground(new Background((DisplayInfo)this.uiDisplay, UIColor.ASH.code()));
        this.programScroll.add(this.programView.getComponent());
        this.programScroll.setClickListener(new ClickListener());
        this.programScroll.setBackground(new Background((DisplayInfo)this.uiDisplay, UIColor.ASH.code()));
        this.bagFrame.setBackground(new Background((DisplayInfo)this.uiDisplay, UIColor.DARK_GRAY.code()));
        this.bagScroll.add(this.bagView.getComponent());
        this.bagScroll.setClickListener(new ClickListener());
        this.bagScroll.setBackground(new Background((DisplayInfo)this.uiDisplay, UIColor.GRAY.code()));
        this.bagImageOpen = new Image(this.uiDisplay, TextureEnum.UI_BAG_OPEN.getAsInfo());
        this.bagImageClose = new Image(this.uiDisplay, TextureEnum.UI_BAG_CLOSE.getAsInfo());
        this.bagImageFrame.add(this.bagImageClose);
        this.bagButton.setClickListener(() -> {
            this.bagOpen = !this.bagOpen;
            this.bagFrame.setVisible(this.bagOpen);
            this.bagImageFrame.clear();
            if (this.bagOpen) {
                this.bagImageFrame.add(this.bagImageOpen);
            } else {
                this.bagImageFrame.add(this.bagImageClose);
            }
        });
        this.gabageView.setBackground(new Background((DisplayInfo)this.uiDisplay, 68));
        this.gabageImageOpen = new Image(this.uiDisplay, TextureEnum.UI_GABAGE_OPEN.getAsInfo());
        this.gabageImageClose = new Image(this.uiDisplay, TextureEnum.UI_GABAGE_CLOSE.getAsInfo());
        this.gabageImageFrame.add(this.bagImageClose);
        try {
            this.loadMachine(FileUtils.loadFile(fileName + ".bcm"));
        }
        catch (FileNotFoundException | CompileException exception) {
            // empty catch block
        }
        try {
            this.loadProgram(FileUtils.loadFile(fileName + ".bcp"));
        }
        catch (FileNotFoundException e) {
            this.loadProgram("#include \"res/stdlib/io.bcp\"\n#include \"res/stdlib/math.bcp\"\n#include \"res/stdlib/pid.bcp\"\nfloat main(){}");
        }
        this.savedState = this.programView.makeCode();
        this.hist = new EditHistory<String>(this.savedState);
        try {
            String bagStr = FileUtils.loadFile("my_bag.bcp");
            this.bagView.addBlocks(0, true, (ProgramBlock[])ProgramCompiler.parseCopy(bagStr).stream().flatMap(pn -> pn.convertToBlocks(this.uiDisplay, null).stream()).toArray(ProgramBlock[]::new));
        }
        catch (FileNotFoundException bagStr) {
        }
        catch (CompileException e) {
            System.err.println("failed to load my bag");
            e.printStackTrace();
        }
        if (fileName.startsWith("res/")) {
            MenuManager menu = new MenuManager(this.uiDisplay);
            menu.set(StringManager.lang.gameMenuPath() + "cannot_write.md");
            menu.setListener("ok", args -> this.showMenu(null));
            this.showMenu(menu.getComponent());
        }
    }

    @Override
    protected boolean save() {
        String s = this.programView.makeCode();
        try {
            ProgramCompiler.compile(s);
            FileUtils.writeFile(this.getFileName() + ".bcp", s);
            this.savedState = s;
            this.showMessage(StringManager.lang.programProgramSaved());
            return true;
        }
        catch (CompileException e) {
            MenuManager menu = new MenuManager(this.uiDisplay);
            menu.setGetter("$message", args -> StringManager.lang.programCannotSave(e.getDetailMessage(s)));
            menu.set(StringManager.lang.gameMenuPath() + "save_failed.md");
            menu.setListener("ok", args -> this.showMenu(null));
            this.showMenu(menu.getComponent());
            return false;
        }
    }

    private void loadProgram(String source) {
        if (source != null) {
            this.programView.clear();
            try {
                TopNode program = ProgramCompiler.compile(source).getTopNode();
                this.functions.loadFunctions(program);
                program.convertToBlocks(this.uiDisplay, this).stream().forEach(this.programView::addBlock);
            }
            catch (CompileException e) {
                System.err.println(StringManager.lang.programLoadError(e.getDetailMessage(source)));
            }
        }
    }

    private void loadMachine(String src) throws CompileException {
        Machine machine = MachineCompiler.compile(src);
        machine.getFunctionalBlocks().stream().filter(fb -> fb != null).forEach(fb -> {
            boolean bl = this.blockIdents.add(fb.getIdent());
        });
    }

    public FunctionInfo getFunctions() {
        return this.functions;
    }

    public Collection<String> getDefinedVariables(ProgramBlock block) {
        Collection<String> rtn = this.variables.getDefinedVariables(this.programView.findLine(block));
        rtn.addAll(this.blockIdents);
        return rtn;
    }

    public Collection<String> getDefinedArrays(ProgramBlock block) {
        return this.variables.getDefinedArrays(this.programView.findLine(block));
    }

    public boolean isVariableDefined(ProgramBlock block, String name) {
        return this.getDefinedVariables(block).contains(name);
    }

    public boolean isArrayDefined(ProgramBlock block, String name) {
        return this.getDefinedArrays(block).contains(name);
    }

    public void keyInputDialog(Consumer<OperationEvent.KeyCode> closeFunc) {
        this.setInMenu(true);
        DialogBuilder dialog = DialogBuilder.newMessageOnlyDialog(this, StringManager.lang.settingPressKey());
        this.showDialog(dialog);
        this.setActiveComponent(new GetKeyComponent(this, key -> {
            this.setInMenu(false);
            dialog.close();
            closeFunc.accept((OperationEvent.KeyCode)((Object)key));
        }));
    }

    @Override
    protected void onFrame() {
        super.onFrame();
        this.overlay.setPlace(this.draggingBlockComponents, this.getMouseX() - 15, this.getMouseY() - 10);
        this.dragging(this.getMouseX(), this.getMouseY());
        if (this.getKeyDown(OperationEvent.KeyCode.KEY_F1)) {
            this.callSave();
        }
        if (this.textInput != null && this.getKeyDown(OperationEvent.KeyCode.KEY_TAB)) {
            BlockTextInput nextInput = this.getKeyState(OperationEvent.KeyCode.KEY_LEFT_SHIFT) || this.getKeyState(OperationEvent.KeyCode.KEY_RIGHT_SHIFT) ? this.programView.getPrevInput(this.textInput.getLabel()) : this.programView.getNextInput(this.textInput.getLabel());
            this.setActiveComponent(nextInput);
            if (nextInput != null) {
                this.textInput = nextInput;
                nextInput.setCloseFunc(() -> {
                    BlockTextInput blockTextInput = this.textInput = null;
                });
            }
        }
        if (this.getKeyState(OperationEvent.KeyCode.KEY_LEFT_CONTROL) || this.getKeyState(OperationEvent.KeyCode.KEY_RIGHT_CONTROL)) {
            if (this.textInput != null) {
                if (this.getKeyDown(OperationEvent.KeyCode.KEY_Z)) {
                    this.textInput.undo();
                }
                if (this.getKeyDown(OperationEvent.KeyCode.KEY_Y)) {
                    this.textInput.redo();
                }
            } else {
                if (this.getKeyDown(OperationEvent.KeyCode.KEY_Z)) {
                    this.loadProgram(this.hist.undo());
                }
                if (this.getKeyDown(OperationEvent.KeyCode.KEY_Y)) {
                    this.loadProgram(this.hist.redo());
                }
            }
        }
    }

    private void dragStart(int x, int y, boolean copy) {
        Component c;
        String state = this.programView.makeCode();
        if (!this.hist.getState().equals(state)) {
            this.hist.addHistory(state);
        }
        if ((c = this.layout.getClickedComponent(x, y)) != this.getUIDisplay().getRootLayout().getClickedComponent(x, y)) {
            return;
        }
        if (this.textInput != null && this.textInput.getLabel() == c) {
            return;
        }
        if (c == this.paletteScroll || c == this.programScroll || c == this.bagScroll) {
            if (!copy) {
                this.draggingScroll = (ScrollLayout)c;
            }
        } else if (c instanceof Label) {
            ProgramBlock inputBlock = this.programView.findBlockByLabel(c);
            if (inputBlock != null) {
                this.textInput = new BlockTextInput(inputBlock, (Label)c);
                this.textInput.setCloseFunc(() -> {
                    this.textInput = null;
                    String s = this.programView.makeCode();
                    if (!this.hist.getState().equals(s)) {
                        this.hist.addHistory(s);
                    }
                });
                this.setActiveComponent(this.textInput);
            }
        } else {
            if (this.palette.getMaker(c) != null) {
                this.draggingBlocks = this.palette.getMaker(c).make();
                if (this.draggingBlocks.length > 1) {
                    ProgramBlock.setLink(this.draggingBlocks);
                }
            } else if (this.bagFrame.isInDrawingRect(x, y)) {
                this.draggingBlocks = this.bagView.pickBlock(c, !copy);
                if (this.draggingBlocks != null) {
                    if (!copy) {
                        FileUtils.writeFile("my_bag.bcp", this.bagView.makeCode());
                    }
                    this.copyBlocks(null);
                }
            } else {
                this.draggingBlocks = this.programView.pickBlock(c, !copy);
                if (this.draggingBlocks != null) {
                    if (!copy) {
                        this.draggingBlocks[0].onRemoved();
                    }
                    this.copyBlocks(null);
                    this.programView.makeCode();
                }
            }
            if (this.draggingBlocks != null) {
                this.draggingBlocks[0].setIndent(0);
                this.draggingBlockComponents.add(this.draggingBlocks[0].getComponent());
                int i = 1;
                while (i < this.draggingBlocks.length) {
                    this.draggingBlocks[i].setIndent(this.draggingBlocks[i - 1].getNextIndent());
                    this.draggingBlockComponents.add(this.draggingBlocks[i].getComponent());
                    ++i;
                }
                this.gabageView.setVisible(true);
            }
        }
    }

    private void copyBlocks(ProgramMode editor) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.draggingBlocks[0].getCode());
        int i = 1;
        while (i < this.draggingBlocks.length) {
            sb.append("\n");
            sb.append(this.draggingBlocks[i].getCodeAsSentence());
            ++i;
        }
        try {
            this.draggingBlocks = ProgramCompiler.parseCopy(sb.toString()).get(0).convertToBlocks(this.uiDisplay, editor).toArray(new ProgramBlock[0]);
        }
        catch (CompileException e) {
            e.printStackTrace();
        }
    }

    private void dragging(int x, int y) {
        if (this.draggingBlocks != null) {
            this.bagImageFrame.clear();
            if (this.bagButton.isInDrawingRect(x, y)) {
                this.bagImageFrame.add(this.bagImageOpen);
                this.bagView.resetDropPlace();
                this.programView.resetDropPlace();
            } else {
                if (this.bagOpen) {
                    this.bagImageFrame.add(this.bagImageOpen);
                } else {
                    this.bagImageFrame.add(this.bagImageClose);
                }
                if (this.bagFrame.getClickedComponent(x, y) != null) {
                    this.bagView.dropBlock(this.draggingBlocks, x, y, false, this.programScroll.getClickedComponent(x, y) != null);
                    this.programView.resetDropPlace();
                } else {
                    this.bagView.resetDropPlace();
                    this.programView.dropBlock(this.draggingBlocks, x, y, false, this.programScroll.getClickedComponent(x, y) != null);
                }
            }
            this.gabageImageFrame.clear();
            if (this.gabageView.isInDrawingRect(x, y)) {
                this.gabageImageFrame.add(this.gabageImageOpen);
            } else {
                this.gabageImageFrame.add(this.gabageImageClose);
            }
        }
    }

    private void dragEnd(int x, int y) {
        if (this.draggingScroll != null) {
            this.draggingScroll = null;
        }
        if (this.draggingBlocks != null) {
            if (this.bagButton.isInDrawingRect(x, y)) {
                this.bagView.addBlocks(0, true, this.draggingBlocks);
                FileUtils.writeFile("my_bag.bcp", this.bagView.makeCode());
            } else if (this.bagFrame.getClickedComponent(x, y) != null) {
                this.bagView.dropBlock(this.draggingBlocks, x, y, true, true);
                FileUtils.writeFile("my_bag.bcp", this.bagView.makeCode());
            } else if (this.programScroll.getClickedComponent(x, y) != null) {
                this.copyBlocks(this);
                this.programView.dropBlock(this.draggingBlocks, x, y, true, true);
                ProgramBlock[] programBlockArray = this.draggingBlocks;
                int n = this.draggingBlocks.length;
                int n2 = 0;
                while (n2 < n) {
                    ProgramBlock pb = programBlockArray[n2];
                    pb.check();
                    ++n2;
                }
            }
            this.draggingBlocks = null;
            this.draggingBlockComponents.clear();
            this.programView.resetDropPlace();
            this.bagView.resetDropPlace();
            this.bagImageFrame.clear();
            if (this.bagOpen) {
                this.bagImageFrame.add(this.bagImageOpen);
            } else {
                this.bagImageFrame.add(this.bagImageClose);
            }
            this.gabageView.setVisible(false);
        }
        this.programView.makeCode();
        String state = this.programView.makeCode();
        if (!this.hist.getState().equals(state)) {
            this.hist.addHistory(state);
        }
    }

    @Override
    protected void onMouseMove(float x, float y) {
        if (this.draggingScroll != null) {
            this.draggingScroll.scroll((int)x, (int)y);
        }
    }

    @Override
    protected void onMouseAction(int button, OperationEvent.Action action, int mouseX, int mouseY) {
        if (!(this.draggingBlocks != null || action != OperationEvent.Action.PRESS || button != 0 && button != 1 || this.isInMenu())) {
            this.dragStart(mouseX, mouseY, button == 1);
            this.dragging(mouseX, mouseY);
        }
        if (action == OperationEvent.Action.RELEASE && button == 0) {
            this.dragEnd(mouseX, mouseY);
        }
    }

    @Override
    protected boolean isUpdated() {
        return !this.savedState.equals(this.programView.makeCode());
    }
}

