/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.system.program;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.comp_lot.craftalos.system.program.BlockTextInput;
import net.comp_lot.craftalos.system.program.block.NumBlock;
import net.comp_lot.glui.ui.Background;
import net.comp_lot.glui.ui.Label;
import net.comp_lot.glui.ui.TriangleBackground;
import net.comp_lot.glui.ui.UIColor;
import net.comp_lot.ui.core.ClickListener;
import net.comp_lot.ui.core.Component;
import net.comp_lot.ui.core.DisplayInfo;
import net.comp_lot.ui.core.Layout;
import net.comp_lot.ui.layout.CenterLayout;
import net.comp_lot.ui.layout.HorizontalLinearLayout;

public abstract class ProgramBlock {
    public static final UIColor COLOR_MOVE = UIColor.BLUE;
    public static final UIColor COLOR_EVENT = UIColor.YELLOW;
    public static final UIColor COLOR_CTRL = UIColor.BRIGHT_YELLOW;
    public static final UIColor COLOR_GET = UIColor.GREEN_BLUE;
    public static final UIColor COLOR_CALC = UIColor.GREEN;
    public static final UIColor COLOR_VAR = UIColor.ORANGE;
    public static final UIColor COLOR_ARY = UIColor.RED_ORANGE;
    public static final UIColor COLOR_FUN = UIColor.PINK;
    public static final UIColor COLOR_OTHER = UIColor.GRAY;
    public static final UIColor COLOR_INPUT = UIColor.DARK_GRAY;
    public static final UIColor COLOR_INPUT_ERROR = UIColor.DARK_RED;
    public static final UIColor COLOR_INPUT_ACTIVE = UIColor.DARK_BLUE;
    private static final int FONT_SIZE = 20;
    private static final int INDENT_WIDTH = 32;
    private static final int LABEL_PADDING_H = 5;
    private static final int LABEL_PADDING_V = 2;
    private static final int LABEL_MARGIN_H = 2;
    protected static final Function<String, InputState> CHECK_ALL = s -> s.matches(".+") ? InputState.OK : InputState.L_ERROR;
    protected static final Function<String, InputState> CHECK_IDENT = s -> s.matches("_?[a-zA-Z][a-zA-Z_0-9]*") ? InputState.OK : InputState.L_ERROR;
    protected static final Function<String, InputState> CHECK_FLOAT = s -> s.matches("[+-]?\\d+(?:\\.\\d+)?(?:[eE][+-]?\\d+)?") ? InputState.OK : InputState.L_ERROR;
    protected static final Function<String, InputState> CHECK_INTEGER = s -> s.matches("\\d+") ? InputState.OK : InputState.L_ERROR;
    private final DisplayInfo display;
    private final Layout layout;
    private final List<Layout> slots = new ArrayList<Layout>();
    private final List<Character> slotTypes = new ArrayList<Character>();
    private final List<Label> slotLabels = new ArrayList<Label>();
    private final List<String> strings = new ArrayList<String>();
    private final List<Function<String, InputState>> rules = new ArrayList<Function<String, InputState>>();
    private final List<ProgramBlock> blocks = new ArrayList<ProgramBlock>();
    private final boolean hasValue;
    private final boolean isExpr;
    private int indent;
    private ProgramBlock link = null;

    public ProgramBlock(DisplayInfo display, UIColor color, String label, boolean hasValue, boolean isExpr) {
        this.display = display;
        this.hasValue = hasValue;
        this.isExpr = isExpr;
        this.layout = new HorizontalLinearLayout(display, 0);
        this.layout.setPadding(4);
        if (hasValue) {
            this.layout.setBackground(new TriangleBackground(display, color, 0.25, UIColor.DARK_GRAY, 1));
            this.layout.setPaddingRight(10);
        } else {
            this.layout.setBackground(new Background(display, color, UIColor.DARK_GRAY, 1));
        }
        this.layout.setMinWidth(64);
        this.layout.setClickListener(new ClickListener());
        this.setLabel(label);
    }

    public int getIndent() {
        return this.indent;
    }

    public void setIndent(int indent) {
        this.indent = indent;
        this.layout.setMarginLeft(this.getIndent() * 32);
    }

    public int getNextIndent() {
        return this.getIndent();
    }

    public void setVerticalMargin(boolean zero) {
        this.layout.setMarginTop(0);
        this.layout.setMarginBottom(0);
    }

    protected void setLabel(String label) {
        this.layout.clear();
        this.slots.clear();
        this.slotTypes.clear();
        this.slotLabels.clear();
        this.rules.clear();
        String[] stringArray = label.split(" ");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            Label lb = new Label(this.display, 20, s);
            lb.setPaddingLeft(5);
            lb.setPaddingRight(5);
            lb.setPaddingTop(2);
            lb.setPaddingBottom(2);
            if (s.startsWith("$")) {
                lb.setMarginLeft(2);
                lb.setMarginRight(2);
                CenterLayout slot = new CenterLayout(this.display);
                this.layout.add(slot);
                this.slots.add(slot);
                this.slotTypes.add(Character.valueOf(s.charAt(s.length() - 1)));
                this.slotLabels.add(lb);
                lb.setMinWidth((int)((double)(Integer.parseInt(s.substring(1, s.length() - 1)) * 10) * this.display.getScale()));
                lb.setClickListener(new ClickListener());
                switch (s.charAt(s.length() - 1)) {
                    case 's': {
                        if (this.strings.size() < this.slots.size()) {
                            this.strings.add("");
                        }
                        this.rules.add(CHECK_IDENT);
                        break;
                    }
                    case 'f': {
                        if (this.strings.size() < this.slots.size()) {
                            this.strings.add("0.0");
                        }
                        lb.setAlign(Label.Align.CENTER);
                        lb.setCorner(Label.Corner.TRIANGLE, 5);
                        this.rules.add(CHECK_FLOAT);
                        break;
                    }
                    case 'd': {
                        lb.setCorner(Label.Corner.TRIANGLE, 5);
                    }
                    case 'n': {
                        if (this.strings.size() < this.slots.size()) {
                            this.strings.add("0");
                        }
                        lb.setAlign(Label.Align.CENTER);
                        this.rules.add(CHECK_INTEGER);
                        break;
                    }
                    default: {
                        System.err.println("unknown format : " + s.charAt(s.length() - 1));
                        this.rules.add(CHECK_ALL);
                        break;
                    }
                }
            } else {
                lb.clearBackground();
                this.layout.add(new CenterLayout(this.display, lb));
            }
            ++n2;
        }
        while (this.slots.size() > this.blocks.size()) {
            this.blocks.add(null);
        }
        int i = 0;
        while (i < this.slots.size()) {
            if (this.blocks.get(i) != null) {
                this.setValue(i, this.blocks.get(i));
            } else {
                this.setValue(i, this.strings.get(i));
            }
            ++i;
        }
    }

    public final void setValue(int i, ProgramBlock value) {
        if (value instanceof NumBlock) {
            this.setValue(i, value.getValue(0));
        } else {
            this.blocks.set(i, value);
            this.slots.get(i).clear();
            this.slots.get(i).add(value.getComponent());
        }
    }

    public final void setValue(int i, String value) {
        if (value != null) {
            this.blocks.set(i, null);
            this.strings.set(i, value);
            this.slots.get(i).clear();
            this.slots.get(i).add(this.slotLabels.get(i));
            this.slotLabels.get(i).setText(value);
            if (this.rules.get(i).apply(value) == InputState.OK) {
                this.slotLabels.get(i).setBackground(COLOR_INPUT.code());
            } else {
                this.slotLabels.get(i).setBackground(COLOR_INPUT_ERROR.code());
            }
        }
    }

    public final String getValue(int i) {
        if (this.blocks.get(i) != null) {
            return "(" + this.blocks.get(i).getCode() + ")";
        }
        return this.strings.get(i);
    }

    Label getLabel(int slot) {
        return this.slotLabels.get(slot);
    }

    protected final String getOptionValue(int i) {
        if (this.blocks.get(i) != null) {
            if (this.blocks.get(i).requireParentheses()) {
                return "(" + this.blocks.get(i).getCode() + ")";
            }
            return this.blocks.get(i).getCode();
        }
        if (this.rules.get(i).apply(this.strings.get(i)) != InputState.L_ERROR) {
            return this.strings.get(i);
        }
        switch (this.slotTypes.get(i).charValue()) {
            case 'd': 
            case 'f': 
            case 'm': {
                return "$";
            }
        }
        return "_";
    }

    public ProgramBlock getLink() {
        return this.link;
    }

    protected boolean requireParentheses() {
        return true;
    }

    public void check() {
        int i = 0;
        while (i < this.slots.size()) {
            if (this.blocks.get(i) == null) {
                this.setValue(i, this.strings.get(i));
            } else {
                this.blocks.get(i).check();
            }
            ++i;
        }
    }

    public final void setValueChecker(int i, Function<String, InputState> rule) {
        this.rules.set(i, rule);
    }

    public Function<String, List<String>> getCandidatesFunction(int slot) {
        return null;
    }

    public int getLabelIndex(Component c) {
        return this.slotLabels.indexOf(c);
    }

    public void checkInputRule(int i, boolean active) {
        if (this.rules.get(i).apply(this.getValue(i)) == InputState.OK) {
            if (active) {
                this.slotLabels.get(i).setBackground(COLOR_INPUT_ACTIVE.code());
            } else {
                this.slotLabels.get(i).setBackground(COLOR_INPUT.code());
            }
        } else {
            this.slotLabels.get(i).setBackground(COLOR_INPUT_ERROR.code());
        }
    }

    public void setCheckState(int i, InputState state) {
        if (state == InputState.OK) {
            this.slotLabels.get(i).setBackground(COLOR_INPUT.code());
        } else {
            this.slotLabels.get(i).setBackground(COLOR_INPUT_ERROR.code());
        }
    }

    public boolean hasValue() {
        return this.hasValue;
    }

    private boolean isExpr() {
        return this.isExpr;
    }

    public boolean isTopLevel() {
        return false;
    }

    public boolean isInFunction() {
        return true;
    }

    public void onRemoved() {
    }

    public void addDefinedVariables(Set<String> set) {
    }

    public void addDefinedArrays(Set<String> set) {
    }

    public Component getComponent() {
        return this.layout;
    }

    public final ProgramBlock pickBlock(Component c, boolean remove) {
        int i = 0;
        while (i < this.slots.size()) {
            if (this.blocks.get(i) != null) {
                ProgramBlock rtn;
                if (this.blocks.get(i).getComponent() == c) {
                    rtn = this.blocks.get(i);
                    if (remove) {
                        this.setValue(i, this.strings.get(i));
                    }
                    return rtn;
                }
                rtn = this.blocks.get(i).pickBlock(c, remove);
                if (rtn != null) {
                    return rtn;
                }
            } else if (this.slotLabels.get(i) == c) {
                return this;
            }
            ++i;
        }
        return null;
    }

    public final boolean dropBlock(ProgramBlock block, int x, int y, boolean drop) {
        Component c = this.getComponent().getClickedComponent(x, y);
        if (c == null || c == this.getComponent()) {
            return false;
        }
        int i = 0;
        while (i < this.slots.size()) {
            if (this.slotLabels.get(i) == c && (this.slotTypes.get(i).charValue() == 'f' || this.slotTypes.get(i).charValue() == 'd')) {
                if (drop) {
                    this.setValue(i, block);
                }
                return true;
            }
            ++i;
        }
        for (ProgramBlock child : this.blocks) {
            if (child == null || !child.dropBlock(block, x, y, drop)) continue;
            return true;
        }
        return false;
    }

    public boolean isDescendant(ProgramBlock block) {
        if (block == this) {
            return true;
        }
        return this.blocks.stream().filter(b -> b != null).anyMatch(b -> b.isDescendant(block));
    }

    public int getSlotNumber() {
        return this.slots.size();
    }

    public final BlockTextInput nextSlot(Label c) {
        int i = 0;
        while (i < this.slots.size()) {
            if (this.blocks.get(i) != null) {
                ProgramBlock pb = this.blocks.get(i).pickBlock(c, false);
                if (pb != null) {
                    BlockTextInput rtn = this.blocks.get(i).nextSlot(c);
                    if (rtn != null) {
                        return rtn;
                    }
                    return this.firstSlot(i + 1);
                }
            } else if (this.slotLabels.get(i) == c) {
                return this.firstSlot(i + 1);
            }
            ++i;
        }
        return null;
    }

    public final BlockTextInput firstSlot(int i) {
        if (i >= this.slots.size()) {
            return null;
        }
        if (this.blocks.get(i) != null) {
            BlockTextInput rtn = this.blocks.get(i).firstSlot(0);
            if (rtn != null) {
                return rtn;
            }
            return this.firstSlot(i + 1);
        }
        return new BlockTextInput(this, this.slotLabels.get(i));
    }

    public final BlockTextInput prevSlot(Label c) {
        int i = 0;
        while (i < this.slots.size()) {
            if (this.blocks.get(i) != null) {
                ProgramBlock pb = this.blocks.get(i).pickBlock(c, false);
                if (pb != null) {
                    BlockTextInput rtn = this.blocks.get(i).prevSlot(c);
                    if (rtn != null) {
                        return rtn;
                    }
                    return this.lastSlot(i - 1);
                }
            } else if (this.slotLabels.get(i) == c) {
                return this.lastSlot(i - 1);
            }
            ++i;
        }
        return null;
    }

    public final BlockTextInput lastSlot(int i) {
        if (i < 0) {
            return null;
        }
        if (this.blocks.get(i) != null) {
            BlockTextInput rtn = this.blocks.get(i).lastSlot(this.blocks.get(i).getSlotNumber() - 1);
            if (rtn != null) {
                return rtn;
            }
            return this.lastSlot(i - 1);
        }
        return new BlockTextInput(this, this.slotLabels.get(i));
    }

    public abstract String getCode();

    public final String getCodeAsSentence() {
        return this.getCode() + (this.isExpr() ? ";" : "");
    }

    public static void setLink(ProgramBlock ... blocks) {
        int i = 0;
        while (i < blocks.length) {
            blocks[i].link = blocks[(i + 1) % blocks.length];
            ++i;
        }
    }

    public String toString() {
        return this.getCode();
    }

    public static enum InputState {
        OK,
        L_ERROR,
        F_ERROR;

    }
}

