/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.system.program;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.comp_lot.craftalos.program.node.TopNode;

public class FunctionInfo {
    private static final Function FUNCTION_NOT_FOUND = new Function("", "");
    private final Map<String, Function> functions = new HashMap<String, Function>();
    private final Map<String, Integer> includes = new HashMap<String, Integer>();

    void loadFunctions(TopNode program) {
        program.getFunctions().stream().forEach(f -> {
            String[] args = f.getArgumentsNames();
            this.putFunction(new Function(f.getIdent(), args));
        });
    }

    public void putFunction(Function function) {
        if (function.getIdent().length() > 0) {
            this.functions.put(function.getIdent(), function);
        }
    }

    public void removeFunction(String ident) {
        this.functions.remove(ident);
    }

    public Function getFunctionInfo(String ident) {
        return this.functions.getOrDefault(ident, FUNCTION_NOT_FOUND);
    }

    public Collection<Function> getFunctions() {
        return this.functions.values();
    }

    public void addInclude(String name) {
        if (this.includes.containsKey(name)) {
            this.includes.put(name, this.includes.get(name) + 1);
        } else {
            this.includes.put(name, 1);
        }
    }

    public void removeInclude(String name) {
        if (this.includes.getOrDefault(name, 0) > 1) {
            this.includes.put(name, this.includes.get(name) - 1);
        } else if (this.includes.containsKey(name)) {
            this.includes.remove(name);
        }
    }

    public boolean isIncluded(String name) {
        return this.includes.containsKey(name);
    }

    public static class Function {
        private final String ident;
        private final String[] args;

        public Function(String ident, String ... args) {
            this.ident = ident;
            this.args = args;
        }

        public String getIdent() {
            return this.ident;
        }

        public String[] getArgs() {
            return this.args;
        }

        public boolean equals(Object o) {
            if (o instanceof Function) {
                Function f = (Function)o;
                if (this.args.length == f.args.length) {
                    int i = 0;
                    while (i < this.args.length) {
                        if (!this.args[i].equals(f.args[i])) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                }
            }
            return false;
        }
    }
}

